/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.events;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.orcinus.galosphere.blocks.LumiereComposterBlock;
import net.orcinus.galosphere.crafting.LumiereComposterDispenseItemBehavior;
import net.orcinus.galosphere.crafting.PickaxeDispenseItemBehavior;
import net.orcinus.galosphere.init.GAttachmentTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GPotions;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.items.components.SterlingAttached;
import net.orcinus.galosphere.network.UpdateGoldenAirPacket;
import net.orcinus.galosphere.network.UpdateSpectreBoundPacket;

@EventBusSubscriber(modid="galosphere")
public class MiscEvents {
    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            int i = (Integer)serverPlayer.getData(GAttachmentTypes.GOLDEN_AIR_SUPPLY);
            boolean flag = (Boolean)serverPlayer.getData(GAttachmentTypes.IS_SPECTRE_BOUNDED);
            if (i >= 0) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new UpdateGoldenAirPacket(i), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new UpdateSpectreBoundPacket(flag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void modifyComponents(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)GItems.STERLING_HELMET.get(), builder -> builder.set(GDataComponents.STERLING_ATTACHED.get(), (Object)new SterlingAttached(ItemStack.EMPTY)));
        event.modify((ItemLike)GItems.STERLING_HORSE_ARMOR.get(), builder -> builder.set(GDataComponents.STERLING_ATTACHED.get(), (Object)new SterlingAttached(ItemStack.EMPTY)));
        event.modify((ItemLike)GItems.PALLADIUM_BOMB.get(), builder -> {
            builder.set(GDataComponents.BOUNCY.get(), (Object)0);
            builder.set(GDataComponents.DURATION.get(), (Object)0);
            builder.set(GDataComponents.EXPLOSION.get(), (Object)0);
        });
    }

    @SubscribeEvent
    public static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, (Item)GItems.CURED_MEMBRANE.get(), GPotions.ASTRAL);
        builder.addMix(GPotions.ASTRAL, Items.REDSTONE, GPotions.LONG_ASTRAL);
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        LootTable table = event.getTable();
        List pools = table.pools;
        if (name.equals((Object)BuiltInLootTables.ANCIENT_CITY.location())) {
            pools.add(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)GItems.SPECTRE_FLARE.get())).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)))).build());
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        BlockPos pos = event.getPos();
        Level world = event.getLevel();
        BlockState state = world.getBlockState(pos);
        BlockHitResult hitResult = event.getHitVec();
        if (state.is(Blocks.COMPOSTER) && itemStack.is(GItemTags.LUMIERE_COMPOSTING_ADDITIONS) && (Integer)state.getValue((Property)ComposterBlock.LEVEL) > 0 && (Integer)state.getValue((Property)ComposterBlock.LEVEL) < 8) {
            itemStack.consume(1, (LivingEntity)player);
            world.setBlock(pos, (BlockState)((Block)GBlocks.LUMIERE_COMPOSTER.get()).defaultBlockState().setValue((Property)LumiereComposterBlock.LEVEL, (Comparable)((Integer)state.getValue((Property)ComposterBlock.LEVEL))), 2);
            world.playSound(null, pos, GSoundEvents.LUMIERE_COMPOST.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.swing(hand);
            event.setCanceled(true);
        }
        if (itemStack.is(Tags.Items.INGOTS_IRON) && (state.is(Blocks.CHIPPED_ANVIL) || state.is(Blocks.DAMAGED_ANVIL))) {
            itemStack.consume(1, (LivingEntity)player);
            Block returned = state.is(Blocks.DAMAGED_ANVIL) ? Blocks.CHIPPED_ANVIL : Blocks.ANVIL;
            world.setBlock(pos, returned.withPropertiesOf(state), 2);
            world.playSound(null, pos, SoundEvents.IRON_GOLEM_REPAIR, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.swing(hand);
            event.setCanceled(true);
        }
        if (itemStack.is(Items.GLOW_INK_SAC)) {
            BlockPlaceContext ctx = new BlockPlaceContext(world, player, hand, itemStack, hitResult);
            BlockState blockState = ((Block)GBlocks.GLOW_INK_CLUMPS.get()).getStateForPlacement(ctx);
            if (blockState == null) {
                return;
            }
            if (!state.canBeReplaced(ctx)) {
                pos = pos.relative(hitResult.getDirection());
            }
            world.setBlock(pos, blockState, 2);
            world.playSound(null, pos, blockState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            itemStack.consume(1, (LivingEntity)player);
            player.swing(hand);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GItems.LUMIERE_SHARD.get()), (DispenseItemBehavior)new LumiereComposterDispenseItemBehavior());
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GItems.GLOW_FLARE.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)GItems.GLOW_FLARE.get()));
        BuiltInRegistries.ITEM.getTagOrEmpty(ItemTags.CLUSTER_MAX_HARVESTABLES).iterator().forEachRemaining(holder -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)holder.value()), (DispenseItemBehavior)new PickaxeDispenseItemBehavior()));
    }
}

