/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.blocks.BurrowAnchorBlock;
import net.orcinus.galosphere.blocks.ChandelierBlock;
import net.orcinus.galosphere.blocks.CombustionTableBlock;
import net.orcinus.galosphere.blocks.CordycepsBlock;
import net.orcinus.galosphere.blocks.CordycepsPlantBlock;
import net.orcinus.galosphere.blocks.CrystalSlabBlock;
import net.orcinus.galosphere.blocks.CrystalStairsBlock;
import net.orcinus.galosphere.blocks.GildedBeadsBlock;
import net.orcinus.galosphere.blocks.GlintedClusterBlock;
import net.orcinus.galosphere.blocks.GlowInkClumpsBlock;
import net.orcinus.galosphere.blocks.LichenMossBlock;
import net.orcinus.galosphere.blocks.LichenMushroomBlock;
import net.orcinus.galosphere.blocks.LichenRootsBlock;
import net.orcinus.galosphere.blocks.LichenShelfBlock;
import net.orcinus.galosphere.blocks.LichenVinesBlock;
import net.orcinus.galosphere.blocks.LightStandBlock;
import net.orcinus.galosphere.blocks.LumiereComposterBlock;
import net.orcinus.galosphere.blocks.MoleBurrowBlock;
import net.orcinus.galosphere.blocks.OpalSaplingBlock;
import net.orcinus.galosphere.blocks.PalladiumDustBlock;
import net.orcinus.galosphere.blocks.PalladiumLatticeBlock;
import net.orcinus.galosphere.blocks.PalladiumLatticeVineBlock;
import net.orcinus.galosphere.blocks.PinkSaltBlock;
import net.orcinus.galosphere.blocks.PinkSaltClusterBlock;
import net.orcinus.galosphere.blocks.PinkSaltLampBlock;
import net.orcinus.galosphere.blocks.PinkSaltSlabBlock;
import net.orcinus.galosphere.blocks.PinkSaltStairsBlock;
import net.orcinus.galosphere.blocks.PinkSaltStrawBlock;
import net.orcinus.galosphere.blocks.PinkSaltWallBlock;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.blocks.RotatableChiseledBlock;
import net.orcinus.galosphere.blocks.ShadowFrameBlock;
import net.orcinus.galosphere.blocks.SoilComposterBlock;
import net.orcinus.galosphere.blocks.StrandedMembraneBlock;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.init.GTreeGrowers;

public class GBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"galosphere");
    public static final DeferredBlock<Block> COMBUSTION_TABLE = GBlocks.register("combustion_table", CombustionTableBlock::new, BlockBehaviour.Properties.of().strength(2.5f).sound(GSoundEvents.COMBUSTION_TABLE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> BURROW_ANCHOR = GBlocks.register("burrow_anchor", BurrowAnchorBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(GSoundEvents.PALLADIUM).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? 6 : 0));
    public static final DeferredBlock<Block> PALLADIUM_ORE = GBlocks.register("palladium_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.IRON_ORE));
    public static final DeferredBlock<Block> DEEPSLATE_PALLADIUM_ORE = GBlocks.register("deepslate_palladium_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final DeferredBlock<Block> RAW_PALLADIUM_BLOCK = GBlocks.register("raw_palladium_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
    public static final DeferredBlock<Block> PALLADIUM_BLOCK = GBlocks.register("palladium_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(GSoundEvents.PALLADIUM));
    public static final DeferredBlock<Block> CHANDELIER = GBlocks.register("chandelier", ChandelierBlock::new, BlockBehaviour.Properties.of().noCollission().requiresCorrectToolForDrops().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 12).noOcclusion());
    public static final DeferredBlock<Block> SOUL_CHANDELIER = GBlocks.register("soul_chandelier", ChandelierBlock::new, BlockBehaviour.Properties.of().noCollission().requiresCorrectToolForDrops().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 9).noOcclusion());
    public static final DeferredBlock<Block> PALLADIUM_TILES = GBlocks.register("palladium_tiles", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().sound(GSoundEvents.PALLADIUM).strength(3.0f, 6.0f));
    public static final DeferredBlock<Block> PALLADIUM_TILES_STAIRS = GBlocks.register("palladium_tiles_stairs", properties -> new StairBlock(((Block)PALLADIUM_TILES.get()).defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().sound(GSoundEvents.PALLADIUM).strength(3.0f, 6.0f));
    public static final DeferredBlock<Block> PALLADIUM_TILES_SLAB = GBlocks.register("palladium_tiles_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().sound(GSoundEvents.PALLADIUM).strength(3.0f, 6.0f));
    public static final DeferredBlock<Block> LIGHT_STAND = GBlocks.registerNoTabBlock("light_stand", LightStandBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().sound(GSoundEvents.PALLADIUM).strength(3.0f, 6.0f).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false && state.getValue(LightStandBlock.HALF) == DoubleBlockHalf.UPPER ? 13 : 0).pushReaction(PushReaction.DESTROY).noOcclusion());
    public static final DeferredBlock<Block> SOUL_LIGHT_STAND = GBlocks.registerNoTabBlock("soul_light_stand", LightStandBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().sound(GSoundEvents.PALLADIUM).strength(3.0f, 6.0f).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false && state.getValue(LightStandBlock.HALF) == DoubleBlockHalf.UPPER ? 10 : 0).pushReaction(PushReaction.DESTROY).noOcclusion());
    public static final DeferredBlock<Block> PALLADIUM_PANEL = GBlocks.register("palladium_panel", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().sound(GSoundEvents.PALLADIUM).strength(3.0f, 6.0f));
    public static final DeferredBlock<Block> PALLADIUM_PANEL_STAIRS = GBlocks.register("palladium_panel_stairs", properties -> new StairBlock(((Block)PALLADIUM_PANEL.get()).defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().sound(GSoundEvents.PALLADIUM).strength(3.0f, 6.0f));
    public static final DeferredBlock<Block> PALLADIUM_PANEL_SLAB = GBlocks.register("palladium_panel_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().sound(GSoundEvents.PALLADIUM).strength(3.0f, 6.0f));
    public static final DeferredBlock<Block> PALLADIUM_LATTICE = GBlocks.register("palladium_lattice", PalladiumLatticeBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(GSoundEvents.PALLADIUM_LATTICE).noOcclusion());
    public static final DeferredBlock<Block> GLOW_BERRIES_PALLADIUM_LATTICE = GBlocks.registerNoTabBlock("glow_berries_palladium_lattice", PalladiumLatticeVineBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(GSoundEvents.PALLADIUM_LATTICE).lightLevel(CaveVines.emission((int)14)).noOcclusion());
    public static final DeferredBlock<Block> PALLADIUM_DUST = GBlocks.register("palladium_dust", PalladiumDustBlock::new, BlockBehaviour.Properties.of().noCollission().ignitedByLava().pushReaction(PushReaction.DESTROY).sound(SoundType.SAND));
    public static final DeferredBlock<Block> SHADOW_FRAME = GBlocks.register("shadow_frame", ShadowFrameBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GRAY).lightLevel(state -> (Integer)state.getValue((Property)ShadowFrameBlock.LEVEL)).noCollission().sound(GSoundEvents.PALLADIUM));
    public static final DeferredBlock<Block> ALLURITE_BLOCK = GBlocks.register("allurite_block", AmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> LUMIERE_BLOCK = GBlocks.register("lumiere_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> ALLURITE_CLUSTER = GBlocks.register("allurite_cluster", properties -> new PollinatedClusterBlock(() -> GParticleTypes.ALLURITE_RAIN.get(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().noOcclusion().randomTicks().sound(GSoundEvents.ALLURITE_CLUSTER).strength(1.5f).lightLevel(state -> 7));
    public static final DeferredBlock<Block> LUMIERE_CLUSTER = GBlocks.register("lumiere_cluster", properties -> new PollinatedClusterBlock(() -> GParticleTypes.LUMIERE_RAIN.get(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().noOcclusion().randomTicks().sound(GSoundEvents.LUMIERE_CLUSTER).strength(1.5f).lightLevel(state -> 7));
    public static final DeferredBlock<Block> GLINTED_ALLURITE_CLUSTER = GBlocks.register("glinted_allurite_cluster", properties -> new GlintedClusterBlock(() -> GParticleTypes.ALLURITE_RAIN.get(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().noOcclusion().randomTicks().sound(GSoundEvents.ALLURITE_CLUSTER).strength(1.5f).lightLevel(state -> 7));
    public static final DeferredBlock<Block> GLINTED_LUMIERE_CLUSTER = GBlocks.register("glinted_lumiere_cluster", properties -> new GlintedClusterBlock(() -> GParticleTypes.LUMIERE_RAIN.get(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().noOcclusion().randomTicks().sound(GSoundEvents.LUMIERE_CLUSTER).strength(1.5f).lightLevel(state -> 7));
    public static final DeferredBlock<Block> GLINTED_AMETHYST_CLUSTER = GBlocks.register("glinted_amethyst_cluster", properties -> new GlintedClusterBlock(() -> GParticleTypes.AMETHYST_RAIN.get(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().noOcclusion().randomTicks().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(state -> 7));
    public static final DeferredBlock<Block> AMETHYST_STAIRS = GBlocks.register("amethyst_stairs", properties -> new CrystalStairsBlock(Blocks.AMETHYST_BLOCK.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK));
    public static final DeferredBlock<Block> ALLURITE_STAIRS = GBlocks.register("allurite_stairs", properties -> new StairBlock(((Block)ALLURITE_BLOCK.get()).defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> AMETHYST_SLAB = GBlocks.register("amethyst_slab", CrystalSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK));
    public static final DeferredBlock<Block> ALLURITE_SLAB = GBlocks.register("allurite_slab", CrystalSlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> LUMIERE_STAIRS = GBlocks.register("lumiere_stairs", properties -> new StairBlock(((Block)LUMIERE_BLOCK.get()).defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> LUMIERE_SLAB = GBlocks.register("lumiere_slab", CrystalSlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> SMOOTH_AMETHYST = GBlocks.register("smooth_amethyst", AmethystBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK));
    public static final DeferredBlock<Block> SMOOTH_AMETHYST_STAIRS = GBlocks.register("smooth_amethyst_stairs", properties -> new CrystalStairsBlock(((Block)SMOOTH_AMETHYST.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK));
    public static final DeferredBlock<Block> SMOOTH_AMETHYST_SLAB = GBlocks.register("smooth_amethyst_slab", CrystalSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK));
    public static final DeferredBlock<Block> SMOOTH_ALLURITE = GBlocks.register("smooth_allurite", AmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> SMOOTH_ALLURITE_STAIRS = GBlocks.register("smooth_allurite_stairs", properties -> new CrystalStairsBlock(((Block)SMOOTH_ALLURITE.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> SMOOTH_ALLURITE_SLAB = GBlocks.register("smooth_allurite_slab", CrystalSlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> SMOOTH_LUMIERE = GBlocks.register("smooth_lumiere", AmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> SMOOTH_LUMIERE_STAIRS = GBlocks.register("smooth_lumiere_stairs", properties -> new CrystalStairsBlock(((Block)SMOOTH_LUMIERE.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> SMOOTH_LUMIERE_SLAB = GBlocks.register("smooth_lumiere_slab", CrystalSlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> AMETHYST_BRICKS = GBlocks.register("amethyst_bricks", AmethystBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK));
    public static final DeferredBlock<Block> AMETHYST_BRICK_STAIRS = GBlocks.register("amethyst_brick_stairs", properties -> new CrystalStairsBlock(((Block)AMETHYST_BRICKS.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK));
    public static final DeferredBlock<Block> AMETHYST_BRICK_SLAB = GBlocks.register("amethyst_brick_slab", CrystalSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK));
    public static final DeferredBlock<Block> ALLURITE_BRICKS = GBlocks.register("allurite_bricks", AmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> ALLURITE_BRICK_STAIRS = GBlocks.register("allurite_brick_stairs", properties -> new CrystalStairsBlock(((Block)ALLURITE_BRICKS.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> ALLURITE_BRICK_SLAB = GBlocks.register("allurite_brick_slab", CrystalSlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> LUMIERE_BRICKS = GBlocks.register("lumiere_bricks", AmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> LUMIERE_BRICK_STAIRS = GBlocks.register("lumiere_brick_stairs", properties -> new CrystalStairsBlock(((Block)LUMIERE_BRICKS.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> LUMIERE_BRICK_SLAB = GBlocks.register("lumiere_brick_slab", CrystalSlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> CHISELED_AMETHYST = GBlocks.register("chiseled_amethyst", AmethystBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK));
    public static final DeferredBlock<Block> CHISELED_ALLURITE = GBlocks.register("chiseled_allurite", AmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(GSoundEvents.ALLURITE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> CHISELED_LUMIERE = GBlocks.register("chiseled_lumiere", AmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(1.5f).sound(GSoundEvents.LUMIERE).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> AMETHYST_LAMP = GBlocks.register("amethyst_lamp", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).lightLevel(state -> 15).strength(0.3f).sound(SoundType.AMETHYST));
    public static final DeferredBlock<Block> ALLURITE_LAMP = GBlocks.register("allurite_lamp", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).lightLevel(state -> 15).strength(0.3f).sound(GSoundEvents.ALLURITE));
    public static final DeferredBlock<Block> LUMIERE_LAMP = GBlocks.register("lumiere_lamp", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).lightLevel(state -> 15).strength(0.3f).sound(GSoundEvents.LUMIERE));
    public static final DeferredBlock<Block> MOLE_BURROW = GBlocks.registerNoTabBlock("mole_burrow", MoleBurrowBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.5f).sound(SoundType.ROOTED_DIRT));
    public static final DeferredBlock<Block> LICHEN_MOSS = GBlocks.register("lichen_moss", LichenMossBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(0.1f).sound(GSoundEvents.LICHEN_MOSS).lightLevel(state -> (Boolean)state.getValue((Property)LichenMossBlock.LIT) != false ? 12 : 0));
    public static final DeferredBlock<Block> LICHEN_ROOTS = GBlocks.register("lichen_roots", LichenRootsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_CYAN).noCollission().instabreak().sound(GSoundEvents.LICHEN_ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).replaceable());
    public static final DeferredBlock<Block> BOWL_LICHEN = GBlocks.register("bowl_lichen", LichenMushroomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_CYAN).instabreak().noCollission().sound(GSoundEvents.BOWL_LICHEN));
    public static final DeferredBlock<Block> LICHEN_SHELF = GBlocks.register("lichen_shelf", LichenShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_CYAN).instabreak().pushReaction(PushReaction.DESTROY).noCollission().sound(GSoundEvents.LICHEN_SHELF));
    public static final DeferredBlock<Block> LICHEN_CORDYCEPS = GBlocks.registerNoTabBlock("lichen_cordyceps", CordycepsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_CYAN).lightLevel(state -> (Boolean)state.getValue((Property)CordycepsBlock.BULB) != false ? 15 : 0).instabreak().noCollission().sound(GSoundEvents.LICHEN_CORDYCEPS));
    public static final DeferredBlock<Block> LICHEN_CORDYCEPS_PLANT = GBlocks.registerNoTabBlock("lichen_cordyceps_plant", CordycepsPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_CYAN).instabreak().noCollission().sound(GSoundEvents.LICHEN_CORDYCEPS));
    public static final DeferredBlock<Block> LICHEN_VINES = GBlocks.registerNoTabBlock("lichen_vines", LichenVinesBlock::new, BlockBehaviour.Properties.of().noCollission().lightLevel(state -> 4).instabreak().sound(GSoundEvents.LICHEN_ROOTS));
    public static final DeferredBlock<Block> GLOW_INK_CLUMPS = GBlocks.registerNoTabBlock("glow_ink_clumps", GlowInkClumpsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).instabreak().noCollission().sound(GSoundEvents.GLOW_INK_CLUMPS).lightLevel(state -> 15));
    public static final DeferredBlock<Block> PINK_SALT = GBlocks.register("pink_salt", PinkSaltBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> ROSE_PINK_SALT = GBlocks.register("rose_pink_salt", PinkSaltBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PASTEL_PINK_SALT = GBlocks.register("pastel_pink_salt", PinkSaltBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PINK_SALT_STAIRS = GBlocks.register("pink_salt_stairs", properties -> new PinkSaltStairsBlock(((Block)PINK_SALT.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> ROSE_PINK_SALT_STAIRS = GBlocks.register("rose_pink_salt_stairs", properties -> new PinkSaltStairsBlock(((Block)ROSE_PINK_SALT.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PASTEL_PINK_SALT_STAIRS = GBlocks.register("pastel_pink_salt_stairs", properties -> new PinkSaltStairsBlock(((Block)PASTEL_PINK_SALT.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PINK_SALT_SLAB = GBlocks.register("pink_salt_slab", PinkSaltSlabBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> ROSE_PINK_SALT_SLAB = GBlocks.register("rose_pink_salt_slab", PinkSaltSlabBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PASTEL_PINK_SALT_SLAB = GBlocks.register("pastel_pink_salt_slab", PinkSaltSlabBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PINK_SALT_WALL = GBlocks.register("pink_salt_wall", PinkSaltWallBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> ROSE_PINK_SALT_WALL = GBlocks.register("rose_pink_salt_wall", PinkSaltWallBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PASTEL_PINK_SALT_WALL = GBlocks.register("pastel_pink_salt_wall", PinkSaltWallBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_PINK_SALT = GBlocks.register("polished_pink_salt", PinkSaltBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_ROSE_PINK_SALT = GBlocks.register("polished_rose_pink_salt", PinkSaltBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_PASTEL_PINK_SALT = GBlocks.register("polished_pastel_pink_salt", PinkSaltBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_PINK_SALT_STAIRS = GBlocks.register("polished_pink_salt_stairs", properties -> new PinkSaltStairsBlock(((Block)PINK_SALT.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_ROSE_PINK_SALT_STAIRS = GBlocks.register("polished_rose_pink_salt_stairs", properties -> new PinkSaltStairsBlock(((Block)ROSE_PINK_SALT.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_PASTEL_PINK_SALT_STAIRS = GBlocks.register("polished_pastel_pink_salt_stairs", properties -> new PinkSaltStairsBlock(((Block)PASTEL_PINK_SALT.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_PINK_SALT_SLAB = GBlocks.register("polished_pink_salt_slab", PinkSaltSlabBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_ROSE_PINK_SALT_SLAB = GBlocks.register("polished_rose_pink_salt_slab", PinkSaltSlabBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_PASTEL_PINK_SALT_SLAB = GBlocks.register("polished_pastel_pink_salt_slab", PinkSaltSlabBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_PINK_SALT_WALL = GBlocks.register("polished_pink_salt_wall", PinkSaltWallBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_ROSE_PINK_SALT_WALL = GBlocks.register("polished_rose_pink_salt_wall", PinkSaltWallBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> POLISHED_PASTEL_PINK_SALT_WALL = GBlocks.register("polished_pastel_pink_salt_wall", PinkSaltWallBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PINK_SALT_BRICKS = GBlocks.register("pink_salt_bricks", PinkSaltBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> ROSE_PINK_SALT_BRICKS = GBlocks.register("rose_pink_salt_bricks", PinkSaltBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PASTEL_PINK_SALT_BRICKS = GBlocks.register("pastel_pink_salt_bricks", PinkSaltBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PINK_SALT_BRICK_STAIRS = GBlocks.register("pink_salt_brick_stairs", properties -> new PinkSaltStairsBlock(((Block)PINK_SALT.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> ROSE_PINK_SALT_BRICK_STAIRS = GBlocks.register("rose_pink_salt_brick_stairs", properties -> new PinkSaltStairsBlock(((Block)ROSE_PINK_SALT.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PASTEL_PINK_SALT_BRICK_STAIRS = GBlocks.register("pastel_pink_salt_brick_stairs", properties -> new PinkSaltStairsBlock(((Block)PASTEL_PINK_SALT.get()).defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PINK_SALT_BRICK_SLAB = GBlocks.register("pink_salt_brick_slab", PinkSaltSlabBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> ROSE_PINK_SALT_BRICK_SLAB = GBlocks.register("rose_pink_salt_brick_slab", PinkSaltSlabBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PASTEL_PINK_SALT_BRICK_SLAB = GBlocks.register("pastel_pink_salt_brick_slab", PinkSaltSlabBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PINK_SALT_BRICK_WALL = GBlocks.register("pink_salt_brick_wall", PinkSaltWallBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> ROSE_PINK_SALT_BRICK_WALL = GBlocks.register("rose_pink_salt_brick_wall", PinkSaltWallBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PASTEL_PINK_SALT_BRICK_WALL = GBlocks.register("pastel_pink_salt_brick_wall", PinkSaltWallBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> CHISELED_PINK_SALT = GBlocks.register("chiseled_pink_salt", RotatableChiseledBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> CHISELED_ROSE_PINK_SALT = GBlocks.register("chiseled_rose_pink_salt", RotatableChiseledBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> CHISELED_PASTEL_PINK_SALT = GBlocks.register("chiseled_pastel_pink_salt", RotatableChiseledBlock::new, BlockBehaviour.Properties.of().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f));
    public static final DeferredBlock<Block> PINK_SALT_LAMP = GBlocks.register("pink_salt_lamp", PinkSaltLampBlock::new, BlockBehaviour.Properties.of().noOcclusion().lightLevel(state -> 11).sound(GSoundEvents.PINK_SALT_LAMP).requiresCorrectToolForDrops().strength(3.5f).pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<Block> PINK_SALT_STRAW = GBlocks.register("pink_salt_straw", PinkSaltStrawBlock::new, BlockBehaviour.Properties.of().forceSolidOn().noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ).randomTicks().dynamicShape().sound(GSoundEvents.PINK_SALT).requiresCorrectToolForDrops().strength(0.75f).pushReaction(PushReaction.DESTROY).isRedstoneConductor((blockState, blockGetter, blockPos) -> false));
    public static final DeferredBlock<Block> PINK_SALT_CLUSTER = GBlocks.register("pink_salt_cluster", PinkSaltClusterBlock::new, BlockBehaviour.Properties.of().lightLevel(state -> 6).sound(GSoundEvents.PINK_SALT_CLUSTER).requiresCorrectToolForDrops().strength(1.0f));
    public static final DeferredBlock<Block> TUFF_DIRT = GBlocks.register("tuff_dirt", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT));
    public static final DeferredBlock<Block> CURED_MEMBRANE_BLOCK = GBlocks.register("cured_membrane_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).sound(GSoundEvents.CURED_MEMBRANE));
    public static final DeferredBlock<Block> STRANDED_MEMBRANE_BLOCK = GBlocks.register("stranded_membrane_block", StrandedMembraneBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).noOcclusion().sound(GSoundEvents.STRANDED_MEMBRANE).isSuffocating((state, world, pos) -> false).isViewBlocking((state, world, pos) -> false));
    public static final DeferredBlock<Block> GILDED_BEADS = GBlocks.register("gilded_beads", GildedBeadsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).noCollission().sound(GSoundEvents.GILDED_BEADS));
    public static final DeferredBlock<Block> LUMIERE_COMPOSTER = GBlocks.registerNoTabBlock("lumiere_composter", LumiereComposterBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COMPOSTER));
    public static final DeferredBlock<Block> SALINE_COMPOSTER = GBlocks.registerNoTabBlock("saline_composter", SoilComposterBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COMPOSTER));
    public static final DeferredBlock<Block> POTTED_BOWL_LICHEN = GBlocks.registerPottedPlant("potted_bowl_lichen", BOWL_LICHEN);
    public static final DeferredBlock<Block> POTTED_LICHEN_ROOTS = GBlocks.registerPottedPlant("potted_lichen_roots", LICHEN_ROOTS);
    public static final DeferredBlock<Block> OPAL_SAPLING = GBlocks.register("opal_sapling", properties -> new OpalSaplingBlock(GTreeGrowers.OPAL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().strength(1.5f).mapColor(MapColor.COLOR_ORANGE).noCollission().randomTicks().instabreak().sound(SoundType.MEDIUM_AMETHYST_BUD).pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<Block> POTTED_OPAL_SAPLING = GBlocks.registerPottedPlant("potted_opal_sapling", OPAL_SAPLING);
    public static final DeferredBlock<Block> OPAL_LOG = GBlocks.register("opal_log", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(blockState -> MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(2.0f));
    public static final DeferredBlock<Block> OPAL_LEAVES = GBlocks.register("opal_leaves", LeavesBlock::new, BlockBehaviour.Properties.of().noOcclusion().strength(0.2f).sound(SoundType.AZALEA_LEAVES).lightLevel(state -> 5));
    public static final DeferredBlock<Block> OPAL_BLOCK = GBlocks.register("opal_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(2.0f).sound(GSoundEvents.LUMIERE));
    public static final DeferredBlock<Block> OPAL_BRICKS = GBlocks.register("opal_bricks", Block::new, BlockBehaviour.Properties.of().mapColor(blockState -> MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(GSoundEvents.LUMIERE));
    public static final DeferredBlock<Block> OPAL_BRICK_STAIRS = GBlocks.register("opal_brick_stairs", properties -> new StairBlock(((Block)OPAL_BRICKS.get()).defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(blockState -> MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(GSoundEvents.LUMIERE));
    public static final DeferredBlock<Block> OPAL_BRICK_SLAB = GBlocks.register("opal_brick_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(blockState -> MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(GSoundEvents.LUMIERE));
    public static final DeferredBlock<Block> OPAL_BRICK_WALL = GBlocks.register("opal_brick_wall", WallBlock::new, BlockBehaviour.Properties.of().mapColor(blockState -> MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(GSoundEvents.LUMIERE).forceSolidOn());
    public static final DeferredBlock<Block> CHISELED_OPAL_BRICKS = GBlocks.register("chiseled_opal_bricks", Block::new, BlockBehaviour.Properties.of().mapColor(blockState -> MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(GSoundEvents.LUMIERE));

    private static DeferredBlock<Block> registerPottedPlant(String name, Supplier<Block> block) {
        return GBlocks.registerNoTabBlock(name, properties -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, block, properties), BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY));
    }

    private static DeferredBlock<Block> register(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties properties) {
        DeferredBlock<Block> block = GBlocks.registerNoTabBlock(name, function, properties);
        GItems.register(name, p -> new BlockItem((Block)block.get(), p));
        return block;
    }

    private static DeferredBlock<Block> registerNoTabBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties properties) {
        return BLOCKS.register(name, () -> (Block)function.apply(properties));
    }

    private static ResourceKey<Block> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Galosphere.id(name));
    }
}

