/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.orcinus.galosphere.entities.RopeDartProjectile;
import net.orcinus.galosphere.init.GAttachmentTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class RopeDartItem
extends Item {
    public RopeDartItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int i) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.hasData(GAttachmentTypes.ROPE_DART)) {
                RopeDartProjectile dart = (RopeDartProjectile)((Object)entity.getData(GAttachmentTypes.ROPE_DART));
                player.getCooldowns().addCooldown((Item)this, 5);
                if (!level.isClientSide()) {
                    dart.discard();
                    player.removeData(GAttachmentTypes.ROPE_DART);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.hasData(GAttachmentTypes.ROPE_DART)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isClientSide()) {
            RopeDartProjectile entity = new RopeDartProjectile(level, player);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)entity);
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), GSoundEvents.ROPE_DART_THROW.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        player.startUsingItem(usedHand);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return itemAbility != ItemAbilities.SPYGLASS_SCOPE;
    }
}

