/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.init.GCriteriaTriggers;

public class SpectreBoundSpyglassItem
extends Item {
    public SpectreBoundSpyglassItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 1200;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (!SpectreBoundSpyglass.canUseSpectreBoundSpyglass(itemStack)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!level.isClientSide) {
                GCriteriaTriggers.USE_SPECTRE_SPYGLASS.get().trigger(serverPlayer);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        player.playSound(SoundEvents.SPYGLASS_USE, 1.0f, 1.0f);
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        this.stopUsing(livingEntity);
        return itemStack;
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int i) {
        this.stopUsing(livingEntity);
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }

    private void stopUsing(LivingEntity livingEntity) {
        livingEntity.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCooldowns().addCooldown((Item)this, 20);
        }
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_SPYGLASS_ACTIONS.contains(itemAbility);
    }
}

