/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GArmorMaterials;
import net.orcinus.galosphere.init.GAttributes;
import org.jetbrains.annotations.Nullable;

public class SterlingArmorItem
extends ArmorItem {
    public static final ResourceLocation HELMET_TEXTURE = Galosphere.id("textures/entity/equipment/helmet/sterling_helmet.png");
    private static final Holder<ArmorMaterial> material = GArmorMaterials.STERLING;
    private final Supplier<ItemAttributeModifiers> itemAttributeModifiersSupplier = Suppliers.memoize(() -> {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        ResourceLocation gResourceLocation = Galosphere.id("armor." + type.getName());
        builder.add(Attributes.ARMOR, new AttributeModifier(resourceLocation, (double)((ArmorMaterial)this.getMaterial().value()).getDefense(type), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourceLocation, (double)((ArmorMaterial)this.getMaterial().value()).toughness(), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        builder.add(GAttributes.ILLAGER_RESISTANCE, new AttributeModifier(gResourceLocation, (double)SterlingArmorItem.getIllagerResistance(type.getSlot()), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        return builder.build();
    });

    public SterlingArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(GArmorMaterials.STERLING, type, properties);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return slot == EquipmentSlot.HEAD ? HELMET_TEXTURE : super.getArmorTexture(stack, entity, slot, layer, innerModel);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return (ItemAttributeModifiers)this.itemAttributeModifiersSupplier.get();
    }

    public static float getIllagerResistance(EquipmentSlot slot) {
        float[] array = new float[]{3.0f, 5.0f, 6.0f, 2.0f};
        return array[slot.getIndex()];
    }
}

