/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.util.loot_modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.orcinus.galosphere.init.GMapDecorationTypes;
import net.orcinus.galosphere.init.GStructureTags;

public class ForgottenRuinsMapLootModifier
extends LootModifier {
    public static final MapCodec<ForgottenRuinsMapLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> ForgottenRuinsMapLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ForgottenRuinsMapLootModifier::new));

    public ForgottenRuinsMapLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> objectArrayList, LootContext lootContext) {
        RandomSource random = lootContext.getRandom();
        if (random.nextInt(3) == 0) {
            Vec3 vec3 = (Vec3)lootContext.getParam(LootContextParams.ORIGIN);
            TagKey<Structure> destination = GStructureTags.ON_FORGOTTEN_RUINS_MAP;
            int searchRadius = 50;
            boolean skipKnownStructures = false;
            byte zoom = 4;
            ServerLevel serverlevel = lootContext.getLevel();
            BlockPos blockpos = serverlevel.findNearestMapStructure(destination, BlockPos.containing((Position)vec3), searchRadius, skipKnownStructures);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.create((Level)serverlevel, (int)blockpos.getX(), (int)blockpos.getZ(), (byte)zoom, (boolean)true, (boolean)true);
                MapItem.renderBiomePreviewMap((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", GMapDecorationTypes.FORGOTTEN_RUINS);
                itemstack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"filled_map.galosphere.forgotten_ruins"));
                objectArrayList.add((Object)itemstack);
            }
        }
        return objectArrayList;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

