/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.world.gen.FastNoise;

public interface PinkSaltUtil {
    public static Block getBlock(long seed, BlockPos blockPos) {
        return PinkSaltUtil.getBlock(seed, blockPos.mutable());
    }

    public static Block getBlock(long seed, BlockPos.MutableBlockPos mutable) {
        return PinkSaltUtil.getBlock((int)seed, mutable, (Block)GBlocks.PASTEL_PINK_SALT.get(), (Block)GBlocks.ROSE_PINK_SALT.get(), (Block)GBlocks.PINK_SALT.get());
    }

    public static Block getBlock(long seed, BlockPos blockPos, Block pastel, Block rose, Block normal) {
        return PinkSaltUtil.getBlock((int)seed, blockPos.mutable(), pastel, rose, normal);
    }

    public static Block getBlock(int seed, BlockPos.MutableBlockPos mutable, Block pastel, Block rose, Block normal) {
        FastNoise fastNoise = new FastNoise(seed);
        fastNoise.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
        fastNoise.SetFractalOctaves(1);
        fastNoise.SetFractalGain(0.3f);
        fastNoise.SetFrequency(0.07f);
        double noise2 = Math.abs(fastNoise.GetNoise(mutable.getX(), mutable.getZ()) + 1.0f) * 3.0f;
        Block block = noise2 > 4.0 ? pastel : (noise2 > 3.0 ? rose : normal);
        return block;
    }
}

