/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluids;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.world.gen.features.config.CrystalSpikeConfig;

public class CrystalSpikeFeature
extends Feature<CrystalSpikeConfig> {
    public CrystalSpikeFeature(Codec<CrystalSpikeConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<CrystalSpikeConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        CrystalSpikeConfig config = (CrystalSpikeConfig)context.config();
        HashSet trigList = Sets.newHashSet();
        HashSet clusterPos = Sets.newHashSet();
        boolean flag = false;
        int radiusCheck = config.xzRadius().sample(random) + 1;
        int randomChance = random.nextInt(4);
        int stepHeight = radiusCheck + 14 + Mth.nextInt((RandomSource)random, (int)10, (int)14);
        if (world.isStateAtPosition(blockPos.relative(config.crystal_direction().getDirection().getOpposite()), DripstoneUtils::isEmptyOrWaterOrLava) && world.getBlockState(blockPos).is(BlockTags.BASE_STONE_OVERWORLD) && this.placeSpike((LevelAccessor)world, blockPos, radiusCheck, stepHeight, randomChance, trigList, config.crystal_direction().getDirection(), random)) {
            flag = this.placeCrystals(world, random, config, trigList, clusterPos, flag);
        }
        return flag;
    }

    private boolean placeCrystals(WorldGenLevel world, RandomSource random, CrystalSpikeConfig config, HashSet<BlockPos> trigList, HashSet<BlockPos> clusterPos, boolean flag) {
        for (BlockPos pos : trigList) {
            if (!world.isStateAtPosition(pos, DripstoneUtils::isEmptyOrWaterOrLava)) continue;
            this.setBlock((LevelWriter)world, pos, config.crystal_state());
            clusterPos.add(pos);
            flag = true;
        }
        for (BlockPos pos : clusterPos) {
            if (random.nextInt(6) != 0) continue;
            for (Direction direction : Direction.values()) {
                BlockPos relative = pos.relative(direction);
                if (!random.nextBoolean() || !world.isStateAtPosition(relative, DripstoneUtils::isEmptyOrWater) || !world.getBlockState(pos).equals(config.crystal_state())) continue;
                BlockState blockState = random.nextFloat() > config.glinted_cluster_chance() ? config.cluster_state() : config.glinted_cluster();
                this.setBlock((LevelWriter)world, relative, (BlockState)((BlockState)blockState.setValue((Property)PollinatedClusterBlock.FACING, (Comparable)direction)).setValue((Property)PollinatedClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(relative).getType() == Fluids.WATER)));
            }
        }
        return flag;
    }

    public boolean placeSpike(LevelAccessor world, BlockPos blockPos, int startRadius, int height, int randomChance, HashSet<BlockPos> crystalPos, Direction direction, RandomSource random) {
        boolean flag = false;
        if (startRadius < 1) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            int radius = startRadius - y / 2;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = new BlockPos(blockPos.getX() + x, blockPos.getY(), blockPos.getZ() + z);
                    if (x * x + z * z > radius * radius) continue;
                    if (direction == Direction.DOWN) {
                        if (world.isStateAtPosition(pos.below(), DripstoneUtils::isEmptyOrWaterOrLava)) {
                            return this.placeSpike(world, blockPos.below(), startRadius / 2, height, randomChance, crystalPos, direction, random);
                        }
                    } else if (direction == Direction.UP) {
                        BlockPos.MutableBlockPos mut = pos.mutable();
                        for (int i = 0; i < 10 && world.isStateAtPosition(mut.above(), DripstoneUtils::isEmptyOrWaterOrLava); ++i) {
                            mut.move(Direction.UP);
                        }
                        pos = mut.immutable();
                        if (world.isStateAtPosition(pos.above(), DripstoneUtils::isEmptyOrWaterOrLava)) {
                            return false;
                        }
                    }
                    this.calciteBloom(world, pos.relative(direction), random, radius);
                    float delta = switch (randomChance) {
                        case 1 -> 5.759587f;
                        case 2 -> 0.5235988f;
                        case 3 -> 3.6651917f;
                        case 0 -> 2.617994f;
                        default -> throw new IllegalStateException("Unexpected value: " + randomChance);
                    };
                    float q = Mth.cos((float)delta) * (float)y;
                    float k = Mth.sin((float)1.5707964f) * (float)y;
                    float l = Mth.sin((float)delta) * (float)y;
                    float xx = direction == Direction.UP ? -q : q;
                    float yy = direction == Direction.UP ? -k : k;
                    float zz = direction == Direction.UP ? -l : l;
                    BlockPos trigPos = BlockPos.containing((double)((float)pos.getX() + xx), (double)((float)pos.getY() + yy), (double)((float)pos.getZ() + zz));
                    if (world.isStateAtPosition(trigPos, DripstoneUtils::isEmptyOrWaterOrLava)) {
                        crystalPos.add(trigPos);
                        flag = true;
                        continue;
                    }
                    crystalPos.remove(trigPos);
                }
            }
        }
        return flag;
    }

    private boolean calciteBloom(LevelAccessor world, BlockPos blockPos, RandomSource random, int crystalRadius) {
        int radius = crystalRadius / 4;
        int height = ConstantInt.of((int)2).sample(random);
        boolean flag = false;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -height; y <= height; ++y) {
                    BlockPos pos = new BlockPos(blockPos.getX() + x, blockPos.getY() + y, blockPos.getZ() + z);
                    for (Direction direction : Direction.values()) {
                        if (!world.getBlockState(pos).is(BlockTags.BASE_STONE_OVERWORLD) || !world.isStateAtPosition(pos.relative(direction), DripstoneUtils::isEmptyOrWaterOrLava)) continue;
                        world.setBlock(pos, Blocks.CALCITE.defaultBlockState(), 2);
                        flag = true;
                    }
                }
            }
        }
        return flag;
    }
}

