/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class SimpleWaterloggedBlockFeature
extends Feature<SimpleBlockConfiguration> {
    public SimpleWaterloggedBlockFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> featurePlaceContext) {
        SimpleBlockConfiguration simpleblockconfiguration = (SimpleBlockConfiguration)featurePlaceContext.config();
        WorldGenLevel worldgenlevel = featurePlaceContext.level();
        BlockPos blockpos = featurePlaceContext.origin();
        BlockState blockstate = simpleblockconfiguration.toPlace().getState(featurePlaceContext.random(), blockpos);
        if (blockstate.isAir()) {
            return true;
        }
        if (blockstate.canSurvive((LevelReader)worldgenlevel, blockpos)) {
            if (blockstate.getBlock() instanceof DoublePlantBlock) {
                if (!worldgenlevel.isEmptyBlock(blockpos.above())) {
                    return false;
                }
                DoublePlantBlock.placeAt((LevelAccessor)worldgenlevel, (BlockState)blockstate, (BlockPos)blockpos, (int)2);
            } else {
                if (blockstate.hasProperty((Property)BlockStateProperties.WATERLOGGED) && worldgenlevel.isWaterAt(blockpos)) {
                    blockstate = (BlockState)blockstate.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                worldgenlevel.setBlock(blockpos, blockstate, 2);
            }
            return true;
        }
        return false;
    }
}

