/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.chicken_nerf;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.sssubtlety.chicken_nerf.ChickenNerf;
import net.sssubtlety.chicken_nerf.Config;
import org.jetbrains.annotations.Nullable;

public class FeatureControl {
    @Nullable
    private static final Config CONFIG_INSTANCE;
    private static final Map<Class<? extends class_1429>, class_5321<class_52>> LAY_TABLE_BY_ANIMAL;
    private static final Map<Class<? extends class_1429>, class_3414> LAY_SOUND_BY_ANIMAL;
    private static final double DEFAULT_EGG_SUCCESS_CHANCE;

    public static void init() {
    }

    public static Optional<class_5321<class_52>> getLayTable(Class<?> animalClass) {
        return Optional.ofNullable(LAY_TABLE_BY_ANIMAL.get(animalClass));
    }

    public static boolean putLayTable(Class<? extends class_1429> animalClass, class_5321<class_52> table) {
        return LAY_TABLE_BY_ANIMAL.putIfAbsent(animalClass, table) == null;
    }

    public static class_3414 getLaySound(Class<?> animalClass) {
        class_3414 sound = LAY_SOUND_BY_ANIMAL.get(animalClass);
        return sound == null ? class_3417.field_15219 : sound;
    }

    public static boolean putLaySound(Class<? extends class_1429> animalClass, class_3414 sound) {
        return LAY_SOUND_BY_ANIMAL.putIfAbsent(animalClass, sound) == null;
    }

    public static boolean isConfigLoaded() {
        return CONFIG_INSTANCE != null;
    }

    public static double getEggSuccessChance() {
        return CONFIG_INSTANCE == null ? DEFAULT_EGG_SUCCESS_CHANCE : FeatureControl.calculateEggSuccessChance(FeatureControl.CONFIG_INSTANCE.averageChickensFromEgg);
    }

    private static double calculateEggSuccessChance(double averageChickensFromEgg) {
        return averageChickensFromEgg / (averageChickensFromEgg + 1.0);
    }

    static {
        LAY_TABLE_BY_ANIMAL = new HashMap<Class<? extends class_1429>, class_5321<class_52>>();
        LAY_SOUND_BY_ANIMAL = new HashMap<Class<? extends class_1429>, class_3414>();
        FeatureControl.putLayTable(class_1428.class, (class_5321<class_52>)class_39.field_54248);
        boolean shouldLoadConfig = FabricLoader.getInstance().getModContainer("cloth-config").map(ModContainer::getMetadata).map(ModMetadata::getVersion).filter(version -> {
            try {
                return VersionPredicate.parse((String)">=7.0.72").test(version);
            }
            catch (VersionParsingException e) {
                ChickenNerf.LOGGER.error("Failed to parse version predicate", (Throwable)e);
                return false;
            }
        }).isPresent();
        CONFIG_INSTANCE = shouldLoadConfig ? (Config)AutoConfig.register(Config.class, GsonConfigSerializer::new).getConfig() : null;
        DEFAULT_EGG_SUCCESS_CHANCE = FeatureControl.calculateEggSuccessChance(0.6);
    }

    public static interface Defaults {
        public static final double AVERAGE_CHICKENS_FROM_EGG = 0.6;
    }
}

