package fr.estecka.invarpaint.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static net.minecraft.class_9334.field_54199;
import static net.minecraft.class_9334.field_56138;

import net.minecraft.class_1297;
import net.minecraft.class_1535;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

import static fr.estecka.invarpaint.InvarpaintMod.CONFIG;

public final class PaintStackUtil
{
	static public final class_2960 INVALID_MODEL = class_2960.method_60655("invarpaint", "missing_painting");
	static public final String VARIANT_MODEL_PREFIX = "painting/";


/******************************************************************************/
/* # Set Variant                                                              */
/******************************************************************************/

	static public class_1799	SetVariant(class_1799 stack, @NotNull class_6880<class_1535> entry) {
		stack.method_57379(field_56138, entry);
		if (CONFIG.setItemModel)
			SetModel(stack, entry);
		return stack;
	}

	static public class_1799	SetVariant(class_1799 stack, @NotNull class_1297 entity) {
		var entry = GetVariantEntry(entity);
		if (entry != null)
			SetVariant(stack, entry);
		return stack;
	}


/******************************************************************************/
/* # Create Variant                                                           */
/******************************************************************************/

	static public class_1799	CreateVariant(@NotNull class_6880<class_1535> entry) {
		class_1799 stack = new class_1799(class_1802.field_8892);
		SetVariant(stack, entry);
		if (CONFIG.setItemModel)
			SetModel(stack, entry);
		return stack;
	}

	static public class_1799	CreateVariant(class_1297 entity){
		var entry = GetVariantEntry(entity);
		if (entry != null)
			return CreateVariant(entry);
		else
			return new class_1799(class_1802.field_8892);
	}


/******************************************************************************/
/* # Set Model                                                                */
/******************************************************************************/

	static public class_1799	SetModel(class_1799 stack, @NotNull class_6880<class_1535> entry) {
		return SetModel(stack, entry.method_40230().get().method_29177());
	}

	static public class_1799 SetModel(class_1799 stack, String variantName){
		class_2960 id = class_2960.method_12829(variantName);
		if (id != null)
			return SetModel(stack, id);
		else {
			stack.method_57379(field_54199, INVALID_MODEL);
			return stack;
		}
	}

	static public class_1799 SetModel(class_1799 stack, class_2960 variantId){
		stack.method_57379(field_54199, variantId.method_45138(VARIANT_MODEL_PREFIX));
		return stack;
	}


/******************************************************************************/
/* # Get Variant                                                              */
/******************************************************************************/
// TODO: Probably not compatible with NoKebab

	static public @Nullable class_6880<class_1535>	GetVariantEntry(class_1799 stack){
		return stack.method_58694(field_56138);
	}

	static public @Nullable class_6880<class_1535>	GetVariantEntry(class_1297 entity){
		return entity.method_58694(field_56138);
	}

	static public @Nullable class_2960	GetVariantId(class_1799 stack){
		var entry = GetVariantEntry(stack);
		return (entry == null) ? null : entry.method_40230().get().method_29177();
	}

	@Deprecated
	static public @Nullable String	GetVariantName(class_1297 entity){
		var entry = entity.method_58694(field_56138);
		return (entry == null) ? null : entry.method_40230().get().method_29177().toString();
	}

	@Deprecated
	static public @Nullable String	GetVariantName(class_1799 stack){
		var id = GetVariantId(stack);
		return (id == null) ? null : id.toString();
	}


/******************************************************************************/
/* # HasVariant                                                               */
/******************************************************************************/

	/**
	 * Checks that a variant exists in any form
	 */
	static public boolean	HasVariant(class_1799 stack){
		return stack.method_57826(field_56138);
	}

	/**
	 * Checks that the variant is a valid identifier.
	 * @deprecated Stacks can no longer contains invalid variants.
	 */
	@Deprecated
	static public boolean	HasVariantId(class_1799 stack){
		return HasVariant(stack);
	}
}
