package fr.estecka.invarpaint.config;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170.class_5364;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import fr.estecka.invarpaint.InvarpaintMod;
import fr.estecka.invarpaint.config.ConfigIO.Property;
import static com.mojang.brigadier.arguments.StringArgumentType.string;
import static com.mojang.brigadier.arguments.StringArgumentType.greedyString;
import static com.mojang.brigadier.arguments.StringArgumentType.getString;
import static net.minecraft.class_2170.method_9247;
import static net.minecraft.class_2170.method_9244;
import static fr.estecka.invarpaint.InvarpaintMod.CONFIG;
import static fr.estecka.invarpaint.InvarpaintMod.IO;

public class Command
{
	static public final class_2960 ID = class_2960.method_60655(InvarpaintMod.MODID, "command");

	static private final String ROOT_COMMAND = InvarpaintMod.MODID;
	static private final String PROP_ARG = "property";
	static private final String VALUE_ARG = "value";

	static public void	Register(){
		CommandRegistrationCallback.EVENT.register(ID, Command::RegisterWith);
	}

	static public void	RegisterWith(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_5364 env){
		final var root = method_9247(ROOT_COMMAND);
		final var config = method_9247("config");

		config.then(method_9244(PROP_ARG, string())
			.suggests(Command::PropertyName)
			.executes(Command::Get)
			.then(method_9244(VALUE_ARG, greedyString())
				.executes(Command::Set)
			)
		);

		root.then(config);
		root.requires(s -> s.method_9259(3));
		dispatcher.register(root);
	}


	static private CompletableFuture<Suggestions> PropertyName(final CommandContext<class_2168> context, final SuggestionsBuilder builder){
		for (String s : CONFIG.GetProperties().keySet())
			builder.suggest(s);
		return builder.buildFuture();
	}

	static private int Get(CommandContext<class_2168> context) throws CommandSyntaxException {
		String name = getString(context, PROP_ARG);

		Property<?> property = CONFIG.GetProperties().get(name);
		if (property == null){
			context.getSource().method_9213(class_2561.method_43470("No such property"));
			return 0;
		}

		String value;
		try {
			value = property.Encode();
		}
		catch (IllegalArgumentException e) {
			context.getSource().method_9213(class_2561.method_43470(e.toString()));
			return -1;
		}

		context.getSource().method_45068(class_2561.method_43470(name+"="+value));
		return 0;
	}

	static private int Set(CommandContext<class_2168> context) throws CommandSyntaxException {
		String name = getString(context, PROP_ARG);
		String value = getString(context, VALUE_ARG);

		Property<?> property = CONFIG.GetProperties().get(name);
		if (property == null){
			context.getSource().method_9213(class_2561.method_43470("No such property"));
			return 0;
		}

		try {
			property.Decode(value);
			IO.Write(CONFIG);
		}
		catch (IllegalArgumentException|IOException e) {
			context.getSource().method_9213(class_2561.method_43470(e.toString()));
			return -1;
		}

		Get(context);
		return 1;
	}
}
