package fr.estecka.invarpaint.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_6880;
import org.joml.Vector2i;

public class PaintEntityPlacer 
{
	/**
	 * Iterates over  the possible positions  where a painting  could be  placed
	 * and still cover up  the block  targeted by the player.  Iteration is done
	 * in a ring-like pattern,  such that the positions  closest to the targeted
	 * block are evaluated first.
	 * 
	 * Internally, all positions  are relative to  the bottom-left corner of the
	 * scanned surface,  but the values returned by the iterator are relative to
	 * the targeted block.
	 */
	static class SurfaceIterator
	implements Iterator<Vector2i>
	{
		private final int width, height;
		/**
		 * The position of the targeted block within the scannable surface.
		 */
		private final Vector2i targetBlock;
		/**
		 * Keeps track of which positions have already been added to the queue.
		 */
		private final boolean[][] checkList;
		private final Queue<Vector2i> queue;

		public SurfaceIterator (int variantWidth, int variantHeight){
			this.width = variantWidth;
			this.height = variantHeight;
			this.targetBlock = new Vector2i(variantWidth/2, variantHeight/2);
			this.checkList = new boolean[variantWidth][variantHeight];
			this.queue = new LinkedList<Vector2i>();


			boolean evenW = (variantWidth %2) == 0;
			boolean evenH = (variantHeight%2) == 0;

			queue.add(new Vector2i(targetBlock));
			if (evenW)
				queue.add(new Vector2i(targetBlock).add(-1,  0));
			if (evenH)
				queue.add(new Vector2i(targetBlock).add( 0, -1));
			if (evenW && evenH)
				queue.add(new Vector2i(targetBlock).add(-1, -1));
			
			for (Vector2i p : queue)
				checkList[p.x][p.y] = true;
		}

		/**
		 * Returns positions adjacent to this one.
		 * Elements are ordered so as to start from the right, and circle counter-clockwise around the center.
		 */
		private Vector2i[]	GetAdjacents(Vector2i v){
			Vector2i[] r = new Vector2i[4];
			for (int i=0; i<r.length; ++i)
				r[i] = new Vector2i(v);

			int i=0;
			r[i++].add( 1,  0); // →
			r[i++].add( 0,  1); // ↑
			r[i++].add(-1,  0); // ←
			r[i++].add( 0, -1); // ↓

			return r;
		}

		private boolean ShouldEvaluate(Vector2i v){
			return (0 <= v.x)
			    && (0 <= v.y)
			    && (v.x < width)
			    && (v.y < height)
			    && !checkList[v.x][v.y]
			    ;
		}

		public boolean	hasNext(){
			return !queue.isEmpty();
		}

		/**
		 * @return	The offset of the position to evaluate, relative to the targeted block.
		 */
		public Vector2i	next(){
			Vector2i pos = queue.remove();

			for (Vector2i adj : GetAdjacents(pos))
			if (ShouldEvaluate(adj)){
				queue.add(adj);
				checkList[adj.x][adj.y] = true;
			}

			Vector2i offset = pos;
			offset.x -= this.targetBlock.x;
			offset.y -= this.targetBlock.y;
			return offset;
		}

	}

	static public Optional<class_1534>	PlaceLockedPainting(class_1937 world, class_2338 targetPos, class_2350 facing, class_6880<class_1535> variant){
		class_1534 entity = new class_1534(world, targetPos, facing, variant);
		if (entity.method_6888())
			return Optional.of(entity);

		// The direction of the horizontal axis of the wall
		class_2382 right = facing.method_10160().method_62675();

		SurfaceIterator surface = new SurfaceIterator(variant.comp_349().comp_2670(), variant.comp_349().comp_2671());
		surface.next(); // Skip the targeted position, which was already tested.
		while (surface.hasNext()) {
			Vector2i planeOffset = surface.next();
			class_2382 worldOffset = right.method_35862(planeOffset.x).method_34592(0, planeOffset.y, 0);

			entity.method_5814(
				targetPos.method_10263() + worldOffset.method_10263(),
				targetPos.method_10264() + worldOffset.method_10264(),
				targetPos.method_10260() + worldOffset.method_10260()
			);
			if (entity.method_6888())
				return Optional.of(entity);
		}

		return Optional.empty();
	}
}
