package fr.estecka.invarpaint.core.mixin;

import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1657;
import net.minecraft.class_1790;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import fr.estecka.invarpaint.core.PaintEntityPlacer;
import fr.estecka.invarpaint.api.PaintStackUtil;
import fr.estecka.invarpaint.api.PaintTextUtil;


@Mixin(class_1790.class)
public abstract class DecorationItemMixin 
{
	@WrapOperation( method="useOnBlock", at=@At(value="INVOKE", target="Lnet/minecraft/entity/decoration/painting/PaintingEntity;placePainting(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;)Ljava/util/Optional;") )
	private Optional<class_1534> filterPlacedPainting(class_1937 world, class_2338 pos, class_2350 facing, Operation<Optional<class_1534>> original, class_1838 context) {
		Optional<class_1534> result;
		class_6880<class_1535> variantEntry = PaintStackUtil.GetVariantEntry(context.method_8041());
		class_1657 player = context.method_8036();

		if (variantEntry != null) {
			result = PaintEntityPlacer.PlaceLockedPainting(world, pos, facing, variantEntry);
			if (result.isEmpty() && player != null) {
				player.method_7353(
					PaintTextUtil.ServersideTranslatable("painting.invalid_space",
						PaintTextUtil.TranslatableVariantName(variantEntry.method_55840()).method_27692(class_124.field_1054),
						class_2561.method_43469("painting.dimensions", variantEntry.comp_349().comp_2670(), variantEntry.comp_349().comp_2671())
					),
					true
				);
			}
		}
		else if (player.method_68878() /*|| (variantName!=null && InvarpaintMod.IsNokebabInstalled())*/)
			result = original.call(world, pos, facing);
		else
			result = Optional.empty();

		// Fix for vanilla clients consuming unplaced paintings
		if (result.isEmpty() && !world.method_8608() && !player.method_68878())
			player.field_7512.method_37420();

		return result;
	}

}
