package fr.estecka.invarpaint.loot;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_120;
import net.minecraft.class_1535;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.invarpaint.api.PaintStackUtil;

public class LockVariantRandomlyLootFunction
extends class_120
{
	static public final MapCodec<LockVariantRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(
		instance -> class_120.method_53344(instance)
			.and(PoolIdentifier.CODEC.listOf().optionalFieldOf("variants").forGetter(f->f.variants))
			.apply(instance, LockVariantRandomlyLootFunction::new)
	);

	static public final class_2960 ID = class_2960.method_60655("invarpaint", "lock_variant_randomly");
	static public final class_5339<LockVariantRandomlyLootFunction> TYPE = new class_5339<LockVariantRandomlyLootFunction>(CODEC);

	static public void Register(){
		class_2378.method_10230(class_7923.field_41134, ID, TYPE);
	};


	private final Optional<List<PoolIdentifier>> variants;

	private LockVariantRandomlyLootFunction(List<class_5341> conditions, Optional<List<PoolIdentifier>> variants){
		super(conditions);
		this.variants = variants;
	}

	@Override
	public class_5339<LockVariantRandomlyLootFunction>	method_29321(){
		return TYPE;
	}

	@Override
	public class_1799	method_522(class_1799 stack, class_47 ctx){
		var registry  = ctx.method_299().method_30349().method_30530(class_7924.field_41209);
		class_5819 random = ctx.method_294();
		class_6880<class_1535> variantEntry = null;

		if (this.variants.isPresent())
			variantEntry = PoolIdentifier.GetRandom(this.variants.get(), random, registry);
		else
			variantEntry = registry.method_10240(random).orElse(null);

		if (variantEntry != null)
			PaintStackUtil.SetVariant(stack, variantEntry);

		return stack;
	}

}
