package fr.estecka.invarpaint.loot;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1535;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;

public record PoolIdentifier(boolean isNegative, boolean isTag, class_2960 id)
{
	static public final  Codec<PoolIdentifier> CODEC = Codec.STRING.comapFlatMap(PoolIdentifier::Parse, PoolIdentifier::toString);

	static public DataResult<PoolIdentifier> Parse(String data){
		boolean neg = false;
		if (data.length() < 1)
			return DataResult.error(()-> "Empty identifier");
		if(data.startsWith("!")){
			data = data.substring(1);
			neg = true;
		}

		boolean tag = false;
		if (data.length() < 1)
			return DataResult.error(()-> "Empty identifier");
		if(data.startsWith("#")){
			data = data.substring(1);
			tag = true;
		}

		class_2960 id = class_2960.method_12829(data);

		return DataResult.success(new PoolIdentifier(neg, tag, id));
	}

	public boolean Exists(class_2378<class_1535> registry){
		if (id == null)
			return false;
		if (this.isTag)
			return registry.method_40272().anyMatch(tag -> tag.method_40251().comp_327().equals(this.id));
		else
			return registry.method_10250(this.id);
	}

	public Set<class_6880<class_1535>> GetPool(class_2378<class_1535> registry){
		Set<class_6880<class_1535>> pool = new HashSet<>();

		if (!this.isTag){
			var optEntry = registry.method_10223(this.id);
			if (optEntry.isEmpty())
				pool.add(optEntry.get());
		}
		else for (var entry : registry.method_40286(class_6862.method_40092(class_7924.field_41209, this.id)))
			pool.add(entry);

		if (this.isNegative){
			Set<class_6880<class_1535>> inverse = new HashSet<>();
			var it = registry.method_42017().iterator();
			while (it.hasNext()){
				var entry = it.next();
				if (!pool.contains(entry))
					inverse.add(entry);
			}
			pool = inverse;
		}

		return pool;
	}

	static public @Nullable class_6880<class_1535> GetRandom(Collection<PoolIdentifier> list, class_5819 random, class_2378<class_1535> registry){
		Set<class_6880<class_1535>> pool = new HashSet<>();
		for (PoolIdentifier poolId : list)
			pool.addAll(poolId.GetPool(registry));

		@SuppressWarnings("unchecked")
		class_6880<class_1535>[] array = pool.toArray(class_6880[]::new);
		if (array.length < 1)
			return null;

		int roll = random.method_43048(array.length);
		return array[roll];
	}

	@Override
	public String toString(){
		String r = this.id.toString();
		if (this.isTag)
			r = "#"+r;
		if (this.isNegative)
			r = "!"+r;
		return r;
	}
}
