package fr.estecka.invarpaint.loot;

import java.util.List;
import java.util.Optional;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1535;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3853.class_1652;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import fr.estecka.invarpaint.InvarpaintMod;
import fr.estecka.invarpaint.api.PaintStackUtil;

public class SellPaintingFactory
implements class_3853.class_1652
{
	static public final int	NOVICE_LVL = 1;
	static public final int	APPRENTICE_LVL = 2;
	static public final int	JOURNEYMAN_LVL = 3;
	static public final int	EXPERT_LVL = 4;
	static public final int	MASTER_LVL = 5;

	static private final int MAX_USE = 1;
	static private final int XP_GAIN = 30;

	public static void	Register(){
		InvarpaintMod.LOGGER.info("Adding locked paintings to trade pools");

		final PoolIdentifier COMMON              = PoolIdentifier.Parse("!#invarpaint:exclusive").getOrThrow();
		final PoolIdentifier VILLAGER_EXCLUSIVES = PoolIdentifier.Parse("#invarpaint:exclusive/villager").getOrThrow();
		final PoolIdentifier WANDERER_EXCLUSIVES = PoolIdentifier.Parse("#invarpaint:exclusive/wanderer").getOrThrow();

		final SellPaintingFactory SHEPHERD_TRADE  = new SellPaintingFactory(24, true,  List.of(COMMON, VILLAGER_EXCLUSIVES));
		final SellPaintingFactory WANDERER_TRADE1 = new SellPaintingFactory(24, false, List.of(COMMON));
		final SellPaintingFactory WANDERER_TRADE2 = new SellPaintingFactory(24, false, List.of(WANDERER_EXCLUSIVES));

		//This assumes that variantless painting is the only master trade available to Shepherds, and overwrites it.
		Int2ObjectMap<class_1652[]> shepherd = class_3853.field_17067.get(class_3852.field_17063);
		shepherd.get(MASTER_LVL)[0] = SHEPHERD_TRADE;

		TradeOfferHelper.registerWanderingTraderOffers(builder->builder.addOffersToPool(
			TradeOfferHelper.WanderingTraderOffersBuilder.SELL_SPECIAL_ITEMS_POOL,
			WANDERER_TRADE1,
			WANDERER_TRADE2
		));
	}


	private final class_9306 priceLeft;
	private final Optional<class_9306> priceRight;
	private final List<PoolIdentifier> pool;

	public SellPaintingFactory(class_9306 price1, Optional<class_9306> price2, List<PoolIdentifier> pool){
		this.priceLeft  = price1;
		this.priceRight = price2;
		this.pool = pool;
	}

	public SellPaintingFactory(int emeralds, boolean canvas, List<PoolIdentifier> pool){
		this(
			new class_9306(class_1802.field_8687, emeralds),
			Optional.ofNullable(canvas ? new class_9306(class_1802.field_8892) : null),
			pool
		);
	}

	@Override
	public class_1914	method_7246(class_1297 entity, class_5819 random){
		var registry = entity.method_73183().method_30349().method_30530(class_7924.field_41209);
		class_6880<class_1535> variant = PoolIdentifier.GetRandom(this.pool, random, registry);

		if (variant == null)
			return null;

		return new class_1914(
			this.priceLeft,
			this.priceRight,
			PaintStackUtil.CreateVariant(variant),
			MAX_USE,
			XP_GAIN,
			0.05f
		);
	}
}
