package fr.estecka.invarpaint.tooltip;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1535;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import fr.estecka.invarpaint.InvarpaintClient;
import fr.estecka.invarpaint.api.PaintStackUtil;
import fr.estecka.invarpaint.api.PaintTextUtil;

public class TooltipUtil
{
	static private final class_2561 INVALID_TEXT = class_2561.method_43471("painting.invalid").method_27692(class_124.field_1061);
	static private final class_2561 EMPTY_NOTICE = class_2561.method_43470(" (").method_10852(class_2561.method_43471("painting.empty")).method_27693(")").method_27692(class_124.field_1080);

	static public class_5250	AppendPaintingName(class_5250 text, class_1799 stack){
		// I could just use translatable variables,
		// but this way is compatible with other languages
		class_2960 variantId = PaintStackUtil.GetVariantId(stack);
		if (variantId != null)
			text.method_10852(
				class_2561.method_43470(" (")
					.method_10852(PaintTextUtil.TranslatableVariantName(variantId))
					.method_27693(")")
					.method_27692(class_124.field_1054)
			);
		else
			text.method_10852(EMPTY_NOTICE);

		return text;
	}

	/**
	 * @deprecated Kept around for future reference if NoKebab is ever ported.
	 */
	@Deprecated
	static public void AddVariantTooltip(List<class_2561> tooltip, class_2960 variantId, boolean advanced){
		Optional<class_2378<class_1535>> registry = InvarpaintClient.GetPaintingRegitry();
		Optional<class_1535> variant = registry.flatMap(r -> r.method_17966(variantId));

		// In the event the registry would be absent, consider everything as valid, and print what can be known.
		if (registry.isPresent() && variant.isEmpty())
			tooltip.add(INVALID_TEXT);
		else if (variantId != null){
			class_5250 authorLine = class_2561.method_48321(variantId.method_48747("painting", "author"), "").method_27692(class_124.field_1080);
			if (variant.isPresent())
				authorLine = class_2561.method_43469("painting.dimensions", variant.get().comp_2670(), variant.get().comp_2671())
					.method_27693(" ")
					.method_10852(authorLine)
					;

			tooltip.add(authorLine);
		}

		if (advanced)
			tooltip.add(class_2561.method_43470(variantId.toString()).method_27692(class_124.field_1063));
	}

}
