package fr.estecka.invarpaint.tooltip.mixin;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1535;
import net.minecraft.class_1790;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;


@Mixin(class_1790.class)
public abstract class DecorationItemMixin 
{

	@Redirect(
		method="appendTooltip",
		at = @At(value="INVOKE", target="net/minecraft/entity/decoration/painting/PaintingVariant.title()Ljava/util/Optional;")
	)
	private Optional<class_2561> RemoveTitle(class_1535 variant){
		return Optional.empty();
	}

	@Redirect(
		method="appendTooltip",
		at = @At(value="INVOKE", target="net/minecraft/entity/decoration/painting/PaintingVariant.author()Ljava/util/Optional;")
	)
	private Optional<class_2561> RemoveAuthor(class_1535 variant){
		return Optional.empty();
	}


	@ModifyExpressionValue(
		method = "appendTooltip",
		at = @At(value="INVOKE", target="net/minecraft/text/Text.translatable(Ljava/lang/String;[Ljava/lang/Object;)Lnet/minecraft/text/MutableText;")
	)
	private class_5250 AddCondensedTooltip(class_5250 original, @Local class_6880<class_1535> variant, @Local(argsOnly=true) Consumer<class_2561> tooltipAdder, @Local(argsOnly=true) class_1836 tooltipType) {
		Optional<class_2561> author = variant.comp_349().comp_2919();
		if (author.isPresent())
			original = original.method_10852(class_2561.method_43470(" ")).method_10852(author.get());
		return original;
	}

	@Inject(
		method = "appendTooltip",
		at = @At(value="INVOKE", ordinal=0, shift=Shift.AFTER, target="java/util/function/Consumer.accept(Ljava/lang/Object;)V")
	)
	private void AddRawVariant(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type, CallbackInfo ci, @Local class_6880<class_1535> variant) {
		if (type.equals(class_1836.field_41071))
			textConsumer.accept(class_2561.method_43470(variant.method_55840()).method_27692(class_124.field_1063));
	}

}
