/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.invarpaint.config;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.estecka.invarpaint.InvarpaintMod;
import fr.estecka.invarpaint.config.ConfigIO;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class Command {
    public static final class_2960 ID = class_2960.method_60655((String)"invarpaint", (String)"command");
    private static final String ROOT_COMMAND = "invarpaint";
    private static final String PROP_ARG = "property";
    private static final String VALUE_ARG = "value";

    public static void Register() {
        CommandRegistrationCallback.EVENT.register(ID, Command::RegisterWith);
    }

    public static void RegisterWith(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 env) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)ROOT_COMMAND);
        LiteralArgumentBuilder config = class_2170.method_9247((String)"config");
        config.then(((RequiredArgumentBuilder)class_2170.method_9244((String)PROP_ARG, (ArgumentType)StringArgumentType.string()).suggests(Command::PropertyName).executes(Command::Get)).then(class_2170.method_9244((String)VALUE_ARG, (ArgumentType)StringArgumentType.greedyString()).executes(Command::Set)));
        root.then((ArgumentBuilder)config);
        root.requires(s -> s.method_9259(3));
        dispatcher.register(root);
    }

    private static CompletableFuture<Suggestions> PropertyName(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        for (String s : InvarpaintMod.CONFIG.GetProperties().keySet()) {
            builder.suggest(s);
        }
        return builder.buildFuture();
    }

    private static int Get(CommandContext<class_2168> context) throws CommandSyntaxException {
        String value;
        String name = StringArgumentType.getString(context, (String)PROP_ARG);
        ConfigIO.Property<?> property = InvarpaintMod.CONFIG.GetProperties().get(name);
        if (property == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such property"));
            return 0;
        }
        try {
            value = property.Encode();
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.toString()));
            return -1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)(name + "=" + value)));
        return 0;
    }

    private static int Set(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)PROP_ARG);
        String value = StringArgumentType.getString(context, (String)VALUE_ARG);
        ConfigIO.Property<?> property = InvarpaintMod.CONFIG.GetProperties().get(name);
        if (property == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such property"));
            return 0;
        }
        try {
            property.Decode(value);
            InvarpaintMod.IO.Write(InvarpaintMod.CONFIG);
        }
        catch (IOException | IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.toString()));
            return -1;
        }
        Command.Get(context);
        return 1;
    }
}

