/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.invarpaint.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_6880;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class PaintEntityPlacer {
    public static Optional<class_1534> PlaceLockedPainting(class_1937 world, class_2338 targetPos, class_2350 facing, class_6880<class_1535> variant) {
        class_1534 entity = new class_1534(world, targetPos, facing, variant);
        if (entity.method_6888()) {
            return Optional.of(entity);
        }
        class_2382 right = facing.method_10160().method_62675();
        SurfaceIterator surface = new SurfaceIterator(((class_1535)variant.comp_349()).comp_2670(), ((class_1535)variant.comp_349()).comp_2671());
        surface.next();
        while (surface.hasNext()) {
            Vector2i planeOffset = surface.next();
            class_2382 worldOffset = right.method_35862(planeOffset.x).method_34592(0, planeOffset.y, 0);
            entity.method_5814((double)(targetPos.method_10263() + worldOffset.method_10263()), (double)(targetPos.method_10264() + worldOffset.method_10264()), (double)(targetPos.method_10260() + worldOffset.method_10260()));
            if (!entity.method_6888()) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    static class SurfaceIterator
    implements Iterator<Vector2i> {
        private final int width;
        private final int height;
        private final Vector2i targetBlock;
        private final boolean[][] checkList;
        private final Queue<Vector2i> queue;

        public SurfaceIterator(int variantWidth, int variantHeight) {
            this.width = variantWidth;
            this.height = variantHeight;
            this.targetBlock = new Vector2i(variantWidth / 2, variantHeight / 2);
            this.checkList = new boolean[variantWidth][variantHeight];
            this.queue = new LinkedList<Vector2i>();
            boolean evenW = variantWidth % 2 == 0;
            boolean evenH = variantHeight % 2 == 0;
            this.queue.add(new Vector2i((Vector2ic)this.targetBlock));
            if (evenW) {
                this.queue.add(new Vector2i((Vector2ic)this.targetBlock).add(-1, 0));
            }
            if (evenH) {
                this.queue.add(new Vector2i((Vector2ic)this.targetBlock).add(0, -1));
            }
            if (evenW && evenH) {
                this.queue.add(new Vector2i((Vector2ic)this.targetBlock).add(-1, -1));
            }
            for (Vector2i p : this.queue) {
                this.checkList[p.x][p.y] = true;
            }
        }

        private Vector2i[] GetAdjacents(Vector2i v) {
            int i;
            Vector2i[] r = new Vector2i[4];
            for (i = 0; i < r.length; ++i) {
                r[i] = new Vector2i((Vector2ic)v);
            }
            i = 0;
            r[i++].add(1, 0);
            r[i++].add(0, 1);
            r[i++].add(-1, 0);
            r[i++].add(0, -1);
            return r;
        }

        private boolean ShouldEvaluate(Vector2i v) {
            return 0 <= v.x && 0 <= v.y && v.x < this.width && v.y < this.height && !this.checkList[v.x][v.y];
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Vector2i next() {
            Vector2i pos = this.queue.remove();
            for (Vector2i adj : this.GetAdjacents(pos)) {
                if (!this.ShouldEvaluate(adj)) continue;
                this.queue.add(adj);
                this.checkList[adj.x][adj.y] = true;
            }
            Vector2i offset = pos;
            offset.x -= this.targetBlock.x;
            offset.y -= this.targetBlock.y;
            return offset;
        }
    }
}

