/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.invarpaint.loot;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1535;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record PoolIdentifier(boolean isNegative, boolean isTag, class_2960 id) {
    public static final Codec<PoolIdentifier> CODEC = Codec.STRING.comapFlatMap(PoolIdentifier::Parse, PoolIdentifier::toString);

    public static DataResult<PoolIdentifier> Parse(String data) {
        boolean neg = false;
        if (data.length() < 1) {
            return DataResult.error(() -> "Empty identifier");
        }
        if (data.startsWith("!")) {
            data = data.substring(1);
            neg = true;
        }
        boolean tag = false;
        if (data.length() < 1) {
            return DataResult.error(() -> "Empty identifier");
        }
        if (data.startsWith("#")) {
            data = data.substring(1);
            tag = true;
        }
        class_2960 id = class_2960.method_12829((String)data);
        return DataResult.success((Object)new PoolIdentifier(neg, tag, id));
    }

    public boolean Exists(class_2378<class_1535> registry) {
        if (this.id == null) {
            return false;
        }
        if (this.isTag) {
            return registry.method_40272().anyMatch(tag -> tag.method_40251().comp_327().equals((Object)this.id));
        }
        return registry.method_10250(this.id);
    }

    public Set<class_6880<class_1535>> GetPool(class_2378<class_1535> registry) {
        HashSet<Object> pool = new HashSet<class_6880<class_1535>>();
        if (!this.isTag) {
            Optional optEntry = registry.method_10223(this.id);
            if (optEntry.isEmpty()) {
                pool.add((class_6880)optEntry.get());
            }
        } else {
            for (class_6880 entry : registry.method_40286(class_6862.method_40092((class_5321)class_7924.field_41209, (class_2960)this.id))) {
                pool.add((class_6880<class_1535>)entry);
            }
        }
        if (this.isNegative) {
            HashSet<class_6880.class_6883> inverse = new HashSet<class_6880.class_6883>();
            Iterator it = registry.method_42017().iterator();
            while (it.hasNext()) {
                class_6880.class_6883 entry = (class_6880.class_6883)it.next();
                if (pool.contains(entry)) continue;
                inverse.add(entry);
            }
            pool = inverse;
        }
        return pool;
    }

    @Nullable
    public static class_6880<class_1535> GetRandom(Collection<PoolIdentifier> list, class_5819 random, class_2378<class_1535> registry) {
        HashSet<class_6880<class_1535>> pool = new HashSet<class_6880<class_1535>>();
        for (PoolIdentifier poolId : list) {
            pool.addAll(poolId.GetPool(registry));
        }
        class_6880[] array = (class_6880[])pool.toArray(class_6880[]::new);
        if (array.length < 1) {
            return null;
        }
        int roll = random.method_43048(array.length);
        return array[roll];
    }

    @Override
    public String toString() {
        Object r = this.id.toString();
        if (this.isTag) {
            r = "#" + (String)r;
        }
        if (this.isNegative) {
            r = "!" + (String)r;
        }
        return r;
    }
}

