/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class HorizontalMiniPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/potion_bg_mini_hor.png");

    public HorizontalMiniPotionRenderer(Minecraft mc) {
        super(mc, 18, 22, 12);
    }

    private int getX(int width, int effCount) {
        return switch (this.PotAligns.HorAlign) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.HAlign.LEFT -> this.potX;
            case WidgetAligns.HAlign.MIDDLE -> {
                if (this.potX > 0) {
                    yield width / 2 - 9 - this.potX;
                }
                if (this.potX < 0) {
                    yield width / 2 - 9 - (effCount - 1) * (19 + this.potGap) - this.potX;
                }
                yield (int)((float)(width / 2 - 9) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 9.0f) - (float)this.potX);
            }
            case WidgetAligns.HAlign.RIGHT -> width - this.potX - (effCount - 1) * (this.potGap + 19);
        };
    }

    private int getY(int height) {
        return switch (this.PotAligns.VertAlign) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.VAlign.TOP -> this.potY;
            case WidgetAligns.VAlign.CENTER -> height / 2 - this.BG_HEIGHT / 2 - this.potY;
            case WidgetAligns.VAlign.BOTTOM -> height - this.potY;
        };
    }

    @Override
    public void render(GuiGraphics gui, int width, int height) {
        List<MobEffectInstance> effects = this.filteredEffects();
        if (effects.isEmpty()) {
            return;
        }
        this.preDraw(gui);
        int xPos = this.getX(width, effects.size());
        int yPos = this.getY(height);
        int x = 0;
        for (MobEffectInstance effect : effects) {
            this.drawBackground(gui, this.PBG, xPos + x, yPos, 1, this.potSide);
            this.drawIcon(gui, (Holder<MobEffect>)effect.getEffect(), xPos + x + 3, yPos + 3 + this.potIconSide);
            this.drawLevel(gui, xPos + x + 9, yPos + this.potIconSide, effect.getAmplifier());
            this.drawDurationBar(gui, effect, xPos + 3 + x, yPos + this.potTextSide, this.getBarSize(this.getBarScale(effect)), 3);
            x += 18 + this.potGap;
        }
        this.postDraw(gui);
    }
}

