/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.utils.RenderHelper;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import org.jetbrains.annotations.NotNull;

public class IconWidget
extends Widget {
    private final ResourceLocation BG = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/tf_bg.png");
    private ResourceLocation effectSprite;

    public IconWidget(int x, int y, int width, int height, String effectName) {
        super(x, y, width, height, "");
        this.setEffectAtlasSprite(effectName);
    }

    public void setEffectAtlasSprite(String effectName) {
        Optional effect = BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)effectName));
        if (effect.isEmpty()) {
            this.effectSprite = null;
            return;
        }
        this.effectSprite = RenderHelper.getMobEffectSprite((Holder<MobEffect>)((Holder)effect.get()));
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float pt) {
        super.render(gui, mouseX, mouseY, pt);
        gui.pose().pushMatrix();
        this.renderBackground(gui);
        this.renderIcon(gui);
        gui.pose().popMatrix();
    }

    private void renderIcon(GuiGraphics gui) {
        if (this.effectSprite == null) {
            return;
        }
        RenderHelper.drawSprite(gui, this.effectSprite, this.x + 2, this.y + 2, 16);
    }

    private void renderBackground(GuiGraphics gui) {
        RenderHelper.drawTextureWithBorder(gui, this.BG, this.x, this.y, this.width, this.height, 16, 0, 2, 16, 32);
    }
}

