/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud;

import dlovin.inventoryhud.InvClientThings;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.events.ClientEvents;
import dlovin.inventoryhud.events.UpdateNotificationEvent;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.overlays.ArmorOverlay;
import dlovin.inventoryhud.gui.overlays.IHudOverlay;
import dlovin.inventoryhud.gui.overlays.InventoryOverlay;
import dlovin.inventoryhud.gui.overlays.PotionOverlay;
import dlovin.inventoryhud.keybinds.KeyBinds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.AddGuiOverlayLayersEvent;
import net.minecraftforge.client.gui.overlay.ForgeLayeredDraw;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="inventoryhud")
public class InventoryHUD {
    public static InventoryHUD instance;
    public static final String modid = "inventoryhud";
    public static String version;
    private static final Logger logger;
    private static InvConfig CONFIG;
    public static boolean isActive;
    public static boolean armorHUD;
    public static boolean potionHUD;
    private InventoryGui inventoryGui;
    private List<IHudOverlay> overlays;
    private EventListener updateListener;

    public InventoryHUD(FMLJavaModLoadingContext context) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        version = ((ModContainer)ModList.get().getModContainerByObject((Object)InventoryHUD.getInstance()).get()).getModInfo().getVersion().toString();
        CONFIG = new InvConfig();
        instance = this;
        BusGroup modBusGroup = context.getModBusGroup();
        CONFIG.register((ModLoadingContext)context);
        this.overlays = new ArrayList<IHudOverlay>();
        this.overlays.add(new InventoryOverlay());
        this.overlays.add(new ArmorOverlay());
        this.overlays.add(new PotionOverlay());
        KeyBinds.init();
        FMLClientSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::clientRegistries);
        InvClientThings.initClient((ModLoadingContext)context);
        AddGuiOverlayLayersEvent.BUS.addListener(this::registerLayers);
    }

    public static InvConfig.Client getClientConfig() {
        return CONFIG.getClient();
    }

    public static void saveConfig() {
        InventoryHUD.CONFIG.clientSpec.save();
    }

    public InventoryGui getInventoryGui() {
        return this.inventoryGui;
    }

    public List<IHudOverlay> getOverlays() {
        return this.overlays;
    }

    public static InventoryHUD getInstance() {
        return instance;
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        new InventoryGui();
        new ClientEvents();
        this.updateListener = EntityJoinLevelEvent.BUS.addListener(e -> new UpdateNotificationEvent().onPlayerJoin((EntityJoinLevelEvent)e));
    }

    public void setInvGui(InventoryGui inventoryGui) {
        this.inventoryGui = inventoryGui;
        this.overlays.forEach(IHudOverlay::init);
    }

    public static void log(String message) {
        logger.info(message);
    }

    public void unregisterUpdateListener() {
        MinecraftForge.EVENT_BUS.unregister(Collections.singletonList(this.updateListener));
    }

    private void registerLayers(AddGuiOverlayLayersEvent event) {
        this.overlays.forEach(o -> event.getLayeredDraw().addBelow(ForgeLayeredDraw.PRE_SLEEP_STACK, ResourceLocation.tryBuild((String)modid, (String)o.id()), ForgeLayeredDraw.HOTBAR_AND_DECOS, o::render));
        event.getLayeredDraw().addConditionTo(ForgeLayeredDraw.PRE_SLEEP_STACK, ForgeLayeredDraw.POTION_EFFECTS, () -> (Boolean)InventoryHUD.CONFIG.getClient().Potions.get() == false);
    }

    static {
        logger = LogManager.getLogger((String)modid);
        isActive = false;
        armorHUD = false;
        potionHUD = true;
    }
}

