/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro;

import com.shyamstudio.celestCombatPro.Scheduler;
import com.shyamstudio.celestCombatPro.bstats.Metrics;
import com.shyamstudio.celestCombatPro.combat.CombatManager;
import com.shyamstudio.celestCombatPro.combat.DeathAnimationManager;
import com.shyamstudio.celestCombatPro.commands.CommandManager;
import com.shyamstudio.celestCombatPro.configs.TimeFormatter;
import com.shyamstudio.celestCombatPro.hooks.protection.GriefPreventionHook;
import com.shyamstudio.celestCombatPro.hooks.protection.WorldGuardHook;
import com.shyamstudio.celestCombatPro.language.LanguageManager;
import com.shyamstudio.celestCombatPro.language.MessageService;
import com.shyamstudio.celestCombatPro.listeners.CombatListeners;
import com.shyamstudio.celestCombatPro.listeners.EnderPearlListener;
import com.shyamstudio.celestCombatPro.listeners.ItemRestrictionListener;
import com.shyamstudio.celestCombatPro.listeners.TridentListener;
import com.shyamstudio.celestCombatPro.protection.NewbieProtectionManager;
import com.shyamstudio.celestCombatPro.rewards.KillRewardManager;
import com.shyamstudio.celestCombatPro.updates.ConfigUpdater;
import com.shyamstudio.celestCombatPro.updates.LanguageUpdater;
import com.shyamstudio.celestCombatPro.updates.UpdateChecker;
import com.sk89q.worldguard.WorldGuard;
import lombok.Generated;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CelestCombatPro
extends JavaPlugin {
    private static CelestCombatPro instance;
    private final boolean debugMode = this.getConfig().getBoolean("debug", false);
    private LanguageManager languageManager;
    private MessageService messageService;
    private UpdateChecker updateChecker;
    private ConfigUpdater configUpdater;
    private LanguageUpdater languageUpdater;
    private TimeFormatter timeFormatter;
    private CommandManager commandManager;
    private CombatManager combatManager;
    private KillRewardManager killRewardManager;
    private CombatListeners combatListeners;
    private EnderPearlListener enderPearlListener;
    private TridentListener tridentListener;
    private DeathAnimationManager deathAnimationManager;
    private NewbieProtectionManager newbieProtectionManager;
    private WorldGuardHook worldGuardHook;
    private GriefPreventionHook griefPreventionHook;
    public static boolean hasWorldGuard;
    public static boolean hasGriefPrevention;

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        instance = this;
        this.saveDefaultConfig();
        this.checkProtectionPlugins();
        this.languageManager = new LanguageManager(this, LanguageManager.LanguageFileType.MESSAGES);
        this.languageUpdater = new LanguageUpdater(this, LanguageUpdater.LanguageFileType.MESSAGES);
        this.languageUpdater.checkAndUpdateLanguageFiles();
        this.messageService = new MessageService(this, this.languageManager);
        this.updateChecker = new UpdateChecker(this);
        this.configUpdater = new ConfigUpdater(this);
        this.configUpdater.checkAndUpdateConfig();
        this.timeFormatter = new TimeFormatter(this);
        this.deathAnimationManager = new DeathAnimationManager(this);
        this.combatManager = new CombatManager(this);
        this.killRewardManager = new KillRewardManager(this);
        this.newbieProtectionManager = new NewbieProtectionManager(this);
        this.combatListeners = new CombatListeners(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.combatListeners, (Plugin)this);
        this.enderPearlListener = new EnderPearlListener(this, this.combatManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.enderPearlListener, (Plugin)this);
        this.tridentListener = new TridentListener(this, this.combatManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.tridentListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemRestrictionListener(this, this.combatManager), (Plugin)this);
        if (hasWorldGuard && this.getConfig().getBoolean("safezone_protection.enabled", true)) {
            this.worldGuardHook = new WorldGuardHook(this, this.combatManager);
            this.getServer().getPluginManager().registerEvents((Listener)this.worldGuardHook, (Plugin)this);
            this.debug("WorldGuard safezone protection enabled");
        } else if (hasWorldGuard) {
            this.getLogger().info("Found WorldGuard but safe zone barrier is disabled in config.");
        }
        if (hasGriefPrevention && this.getConfig().getBoolean("claim_protection.enabled", true)) {
            this.griefPreventionHook = new GriefPreventionHook(this, this.combatManager);
            this.getServer().getPluginManager().registerEvents((Listener)this.griefPreventionHook, (Plugin)this);
            this.debug("GriefPrevention claim protection enabled");
        } else if (hasGriefPrevention) {
            this.getLogger().info("Found GriefPrevention but claim protection is disabled in config.");
        }
        this.commandManager = new CommandManager(this);
        this.commandManager.registerCommands();
        this.setupBtatsMetrics();
        long loadTime = System.currentTimeMillis() - startTime;
        this.getLogger().info("CelestCombat has been enabled! (Loaded in " + loadTime + "ms)");
    }

    public void onDisable() {
        if (this.combatManager != null) {
            this.combatManager.shutdown();
        }
        if (this.combatListeners != null) {
            this.combatListeners.shutdown();
        }
        if (this.enderPearlListener != null) {
            this.enderPearlListener.shutdown();
        }
        if (this.tridentListener != null) {
            this.tridentListener.shutdown();
        }
        if (this.worldGuardHook != null) {
            this.worldGuardHook.cleanup();
        }
        if (this.griefPreventionHook != null) {
            this.griefPreventionHook.cleanup();
        }
        if (this.killRewardManager != null) {
            this.killRewardManager.shutdown();
        }
        if (this.newbieProtectionManager != null) {
            this.newbieProtectionManager.shutdown();
        }
        this.getLogger().info("CelestCombat has been disabled!");
    }

    private void checkProtectionPlugins() {
        boolean bl = hasWorldGuard = this.isPluginEnabled("WorldGuard") && this.isWorldGuardAPIAvailable();
        if (hasWorldGuard) {
            this.getLogger().info("WorldGuard integration enabled successfully!");
        }
        boolean bl2 = hasGriefPrevention = this.isPluginEnabled("GriefPrevention") && this.isGriefPreventionAPIAvailable();
        if (hasGriefPrevention) {
            this.getLogger().info("GriefPrevention integration enabled successfully!");
        }
    }

    private boolean isPluginEnabled(String pluginName) {
        Plugin plugin = this.getServer().getPluginManager().getPlugin(pluginName);
        return plugin != null && plugin.isEnabled();
    }

    private boolean isWorldGuardAPIAvailable() {
        try {
            Class.forName("com.sk89q.worldguard.WorldGuard");
            return WorldGuard.getInstance() != null;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    private boolean isGriefPreventionAPIAvailable() {
        try {
            Class.forName("me.ryanhamshire.GriefPrevention.GriefPrevention");
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    private void setupBtatsMetrics() {
        Scheduler.runTask(() -> {
            Metrics metrics = new Metrics((Plugin)this, 27299);
        });
    }

    public long getTimeFromConfig(String path, String defaultValue) {
        return this.timeFormatter.getTimeFromConfig(path, defaultValue);
    }

    public long getTimeFromConfigInMilliseconds(String path, String defaultValue) {
        long ticks = this.timeFormatter.getTimeFromConfig(path, defaultValue);
        return ticks * 50L;
    }

    public void refreshTimeCache() {
        if (this.timeFormatter != null) {
            this.timeFormatter.clearCache();
        }
    }

    public void debug(String message) {
        if (this.debugMode) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    public void reload() {
        if (this.worldGuardHook != null) {
            this.worldGuardHook.cleanup();
        }
        if (this.griefPreventionHook != null) {
            this.griefPreventionHook.cleanup();
        }
    }

    @Generated
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Generated
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @Generated
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public ConfigUpdater getConfigUpdater() {
        return this.configUpdater;
    }

    @Generated
    public LanguageUpdater getLanguageUpdater() {
        return this.languageUpdater;
    }

    @Generated
    public TimeFormatter getTimeFormatter() {
        return this.timeFormatter;
    }

    @Generated
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public CombatManager getCombatManager() {
        return this.combatManager;
    }

    @Generated
    public KillRewardManager getKillRewardManager() {
        return this.killRewardManager;
    }

    @Generated
    public CombatListeners getCombatListeners() {
        return this.combatListeners;
    }

    @Generated
    public EnderPearlListener getEnderPearlListener() {
        return this.enderPearlListener;
    }

    @Generated
    public TridentListener getTridentListener() {
        return this.tridentListener;
    }

    @Generated
    public DeathAnimationManager getDeathAnimationManager() {
        return this.deathAnimationManager;
    }

    @Generated
    public NewbieProtectionManager getNewbieProtectionManager() {
        return this.newbieProtectionManager;
    }

    @Generated
    public WorldGuardHook getWorldGuardHook() {
        return this.worldGuardHook;
    }

    @Generated
    public GriefPreventionHook getGriefPreventionHook() {
        return this.griefPreventionHook;
    }

    @Generated
    public static CelestCombatPro getInstance() {
        return instance;
    }

    static {
        hasWorldGuard = false;
        hasGriefPrevention = false;
    }
}

