/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.combat;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.Scheduler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CombatManager {
    private final CelestCombatPro plugin;
    private final Map<UUID, Long> playersInCombat;
    private final Map<UUID, Scheduler.Task> combatTasks;
    private final Map<UUID, UUID> combatOpponents;
    private Scheduler.Task globalCountdownTask;
    private static final long COUNTDOWN_INTERVAL = 20L;
    private final Map<UUID, Long> enderPearlCooldowns;
    private final Map<UUID, Long> tridentCooldowns = new ConcurrentHashMap<UUID, Long>();
    private long combatDurationTicks;
    private long combatDurationSeconds;
    private boolean disableFlightInCombat;
    private long enderPearlCooldownTicks;
    private long enderPearlCooldownSeconds;
    private Map<String, Boolean> worldEnderPearlSettings = new ConcurrentHashMap<String, Boolean>();
    private boolean enderPearlInCombatOnly;
    private boolean enderPearlEnabled;
    private boolean refreshCombatOnPearlLand;
    private long tridentCooldownTicks;
    private long tridentCooldownSeconds;
    private Map<String, Boolean> worldTridentSettings = new ConcurrentHashMap<String, Boolean>();
    private boolean tridentInCombatOnly;
    private boolean tridentEnabled;
    private boolean refreshCombatOnTridentLand;
    private Map<String, Boolean> worldTridentBannedSettings = new ConcurrentHashMap<String, Boolean>();
    private Scheduler.Task cleanupTask;
    private static final long CLEANUP_INTERVAL = 12000L;

    public CombatManager(CelestCombatPro plugin) {
        this.plugin = plugin;
        this.playersInCombat = new ConcurrentHashMap<UUID, Long>();
        this.combatTasks = new ConcurrentHashMap<UUID, Scheduler.Task>();
        this.combatOpponents = new ConcurrentHashMap<UUID, UUID>();
        this.enderPearlCooldowns = new ConcurrentHashMap<UUID, Long>();
        this.combatDurationTicks = plugin.getTimeFromConfig("combat.duration", "20s");
        this.combatDurationSeconds = this.combatDurationTicks / 20L;
        this.disableFlightInCombat = plugin.getConfig().getBoolean("combat.disable_flight", true);
        this.enderPearlCooldownTicks = plugin.getTimeFromConfig("enderpearl_cooldown.duration", "10s");
        this.enderPearlCooldownSeconds = this.enderPearlCooldownTicks / 20L;
        this.enderPearlEnabled = plugin.getConfig().getBoolean("enderpearl_cooldown.enabled", true);
        this.enderPearlInCombatOnly = plugin.getConfig().getBoolean("enderpearl_cooldown.in_combat_only", true);
        this.refreshCombatOnPearlLand = plugin.getConfig().getBoolean("enderpearl.refresh_combat_on_land", false);
        this.tridentCooldownTicks = plugin.getTimeFromConfig("trident_cooldown.duration", "10s");
        this.tridentCooldownSeconds = this.tridentCooldownTicks / 20L;
        this.tridentEnabled = plugin.getConfig().getBoolean("trident_cooldown.enabled", true);
        this.tridentInCombatOnly = plugin.getConfig().getBoolean("trident_cooldown.in_combat_only", true);
        this.refreshCombatOnTridentLand = plugin.getConfig().getBoolean("trident.refresh_combat_on_land", false);
        this.loadWorldTridentSettings();
        this.loadWorldEnderPearlSettings();
        this.startGlobalCountdownTimer();
    }

    private void loadWorldTridentSettings() {
        this.worldTridentSettings.clear();
        this.worldTridentBannedSettings.clear();
        if (this.plugin.getConfig().isConfigurationSection("trident_cooldown.worlds")) {
            for (String worldName : Objects.requireNonNull(this.plugin.getConfig().getConfigurationSection("trident_cooldown.worlds")).getKeys(false)) {
                boolean enabled = this.plugin.getConfig().getBoolean("trident_cooldown.worlds." + worldName, true);
                this.worldTridentSettings.put(worldName, enabled);
            }
        }
        if (this.plugin.getConfig().isConfigurationSection("trident.banned_worlds")) {
            for (String worldName : Objects.requireNonNull(this.plugin.getConfig().getConfigurationSection("trident.banned_worlds")).getKeys(false)) {
                boolean banned = this.plugin.getConfig().getBoolean("trident.banned_worlds." + worldName, false);
                this.worldTridentBannedSettings.put(worldName, banned);
            }
        }
    }

    public void reloadConfig() {
        this.combatDurationTicks = this.plugin.getTimeFromConfig("combat.duration", "20s");
        this.combatDurationSeconds = this.combatDurationTicks / 20L;
        this.disableFlightInCombat = this.plugin.getConfig().getBoolean("combat.disable_flight", true);
        this.enderPearlCooldownTicks = this.plugin.getTimeFromConfig("enderpearl_cooldown.duration", "10s");
        this.enderPearlCooldownSeconds = this.enderPearlCooldownTicks / 20L;
        this.enderPearlEnabled = this.plugin.getConfig().getBoolean("enderpearl_cooldown.enabled", true);
        this.enderPearlInCombatOnly = this.plugin.getConfig().getBoolean("enderpearl_cooldown.in_combat_only", true);
        this.refreshCombatOnPearlLand = this.plugin.getConfig().getBoolean("enderpearl.refresh_combat_on_land", false);
        this.loadWorldEnderPearlSettings();
        this.tridentCooldownTicks = this.plugin.getTimeFromConfig("trident_cooldown.duration", "10s");
        this.tridentCooldownSeconds = this.tridentCooldownTicks / 20L;
        this.tridentEnabled = this.plugin.getConfig().getBoolean("trident_cooldown.enabled", true);
        this.tridentInCombatOnly = this.plugin.getConfig().getBoolean("trident_cooldown.in_combat_only", true);
        this.refreshCombatOnTridentLand = this.plugin.getConfig().getBoolean("trident.refresh_combat_on_land", false);
        this.loadWorldTridentSettings();
    }

    private void loadWorldEnderPearlSettings() {
        this.worldEnderPearlSettings.clear();
        if (this.plugin.getConfig().isConfigurationSection("enderpearl_cooldown.worlds")) {
            for (String worldName : Objects.requireNonNull(this.plugin.getConfig().getConfigurationSection("enderpearl_cooldown.worlds")).getKeys(false)) {
                boolean enabled = this.plugin.getConfig().getBoolean("enderpearl_cooldown.worlds." + worldName, true);
                this.worldEnderPearlSettings.put(worldName, enabled);
            }
        }
    }

    private void startGlobalCountdownTimer() {
        if (this.globalCountdownTask != null) {
            this.globalCountdownTask.cancel();
        }
        this.globalCountdownTask = Scheduler.runTaskTimer(() -> {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry<UUID, Long> entry2 : new HashMap<UUID, Long>(this.playersInCombat).entrySet()) {
                Player player;
                UUID playerUUID = entry2.getKey();
                long combatEndTime = entry2.getValue();
                if (currentTime > combatEndTime) {
                    player = Bukkit.getPlayer((UUID)playerUUID);
                    if (player != null && player.isOnline()) {
                        this.removeFromCombat(player);
                        continue;
                    }
                    this.playersInCombat.remove(playerUUID);
                    this.combatOpponents.remove(playerUUID);
                    Scheduler.Task task = this.combatTasks.remove(playerUUID);
                    if (task == null) continue;
                    task.cancel();
                    continue;
                }
                player = Bukkit.getPlayer((UUID)playerUUID);
                if (player == null || !player.isOnline()) continue;
                this.updatePlayerCountdown(player, currentTime);
            }
            this.enderPearlCooldowns.entrySet().removeIf(entry -> currentTime > (Long)entry.getValue() || Bukkit.getPlayer((UUID)((UUID)entry.getKey())) == null);
            this.tridentCooldowns.entrySet().removeIf(entry -> currentTime > (Long)entry.getValue() || Bukkit.getPlayer((UUID)((UUID)entry.getKey())) == null);
        }, 0L, 20L);
    }

    private void updatePlayerCountdown(Player player, long currentTime) {
        int remainingTridentTime;
        boolean hasTridentCooldown;
        if (player == null || !player.isOnline()) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        boolean inCombat = this.playersInCombat.containsKey(playerUUID) && currentTime <= this.playersInCombat.get(playerUUID);
        boolean hasPearlCooldown = this.enderPearlCooldowns.containsKey(playerUUID) && currentTime <= this.enderPearlCooldowns.get(playerUUID);
        boolean bl = hasTridentCooldown = this.tridentCooldowns.containsKey(playerUUID) && currentTime <= this.tridentCooldowns.get(playerUUID);
        if (!(inCombat || hasPearlCooldown || hasTridentCooldown)) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        if (inCombat) {
            int remainingCombatTime = this.getRemainingCombatTime(player, currentTime);
            placeholders.put("combat_time", String.valueOf(remainingCombatTime));
            if (hasPearlCooldown && hasTridentCooldown) {
                int remainingPearlTime = this.getRemainingEnderPearlCooldown(player, currentTime);
                int remainingTridentTime2 = this.getRemainingTridentCooldown(player, currentTime);
                placeholders.put("pearl_time", String.valueOf(remainingPearlTime));
                placeholders.put("trident_time", String.valueOf(remainingTridentTime2));
                this.plugin.getMessageService().sendMessage(player, "combat_pearl_trident_countdown", placeholders);
            } else if (hasPearlCooldown) {
                int remainingPearlTime = this.getRemainingEnderPearlCooldown(player, currentTime);
                placeholders.put("pearl_time", String.valueOf(remainingPearlTime));
                this.plugin.getMessageService().sendMessage(player, "combat_pearl_countdown", placeholders);
            } else if (hasTridentCooldown) {
                int remainingTridentTime3 = this.getRemainingTridentCooldown(player, currentTime);
                placeholders.put("trident_time", String.valueOf(remainingTridentTime3));
                this.plugin.getMessageService().sendMessage(player, "combat_trident_countdown", placeholders);
            } else if (remainingCombatTime > 0) {
                placeholders.put("time", String.valueOf(remainingCombatTime));
                this.plugin.getMessageService().sendMessage(player, "combat_countdown", placeholders);
            }
        } else if (hasPearlCooldown && hasTridentCooldown) {
            int remainingPearlTime = this.getRemainingEnderPearlCooldown(player, currentTime);
            int remainingTridentTime4 = this.getRemainingTridentCooldown(player, currentTime);
            placeholders.put("pearl_time", String.valueOf(remainingPearlTime));
            placeholders.put("trident_time", String.valueOf(remainingTridentTime4));
            this.plugin.getMessageService().sendMessage(player, "pearl_trident_countdown", placeholders);
        } else if (hasPearlCooldown) {
            int remainingPearlTime = this.getRemainingEnderPearlCooldown(player, currentTime);
            if (remainingPearlTime > 0) {
                placeholders.put("time", String.valueOf(remainingPearlTime));
                this.plugin.getMessageService().sendMessage(player, "pearl_only_countdown", placeholders);
            }
        } else if (hasTridentCooldown && (remainingTridentTime = this.getRemainingTridentCooldown(player, currentTime)) > 0) {
            placeholders.put("time", String.valueOf(remainingTridentTime));
            this.plugin.getMessageService().sendMessage(player, "trident_only_countdown", placeholders);
        }
    }

    public void tagPlayer(Player player, Player attacker) {
        long currentEndTime;
        boolean alreadyInCombatWithAttacker;
        if (player == null || attacker == null) {
            return;
        }
        if (player.hasPermission("celestcombat.bypass.tag")) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        long newEndTime = System.currentTimeMillis() + this.combatDurationSeconds * 1000L;
        boolean alreadyInCombat = this.playersInCombat.containsKey(playerUUID);
        boolean bl = alreadyInCombatWithAttacker = alreadyInCombat && attacker.getUniqueId().equals(this.combatOpponents.get(playerUUID));
        if (alreadyInCombatWithAttacker && newEndTime <= (currentEndTime = this.playersInCombat.get(playerUUID).longValue())) {
            return;
        }
        if (this.shouldDisableFlight(player) && player.isFlying()) {
            player.setFlying(false);
        }
        this.combatOpponents.put(playerUUID, attacker.getUniqueId());
        this.playersInCombat.put(playerUUID, newEndTime);
        Scheduler.Task existingTask = this.combatTasks.get(playerUUID);
        if (existingTask != null) {
            existingTask.cancel();
        }
    }

    public void punishCombatLogout(Player player) {
        if (player == null) {
            return;
        }
        player.setHealth(0.0);
        this.removeFromCombat(player);
    }

    public void removeFromCombat(Player player) {
        if (player == null) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.playersInCombat.containsKey(playerUUID)) {
            return;
        }
        this.playersInCombat.remove(playerUUID);
        this.combatOpponents.remove(playerUUID);
        Scheduler.Task task = this.combatTasks.remove(playerUUID);
        if (task != null) {
            task.cancel();
        }
        if (player.isOnline()) {
            this.plugin.getMessageService().sendMessage(player, "combat_expired");
        }
    }

    public void removeFromCombatSilently(Player player) {
        if (player == null) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        this.playersInCombat.remove(playerUUID);
        this.combatOpponents.remove(playerUUID);
        Scheduler.Task task = this.combatTasks.remove(playerUUID);
        if (task != null) {
            task.cancel();
        }
    }

    public Player getCombatOpponent(Player player) {
        if (player == null) {
            return null;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.playersInCombat.containsKey(playerUUID)) {
            return null;
        }
        UUID opponentUUID = this.combatOpponents.get(playerUUID);
        if (opponentUUID == null) {
            return null;
        }
        return Bukkit.getPlayer((UUID)opponentUUID);
    }

    public boolean isInCombat(Player player) {
        if (player == null) {
            return false;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.playersInCombat.containsKey(playerUUID)) {
            return false;
        }
        long combatEndTime = this.playersInCombat.get(playerUUID);
        long currentTime = System.currentTimeMillis();
        if (currentTime > combatEndTime) {
            this.removeFromCombat(player);
            return false;
        }
        return true;
    }

    public int getRemainingCombatTime(Player player) {
        return this.getRemainingCombatTime(player, System.currentTimeMillis());
    }

    private int getRemainingCombatTime(Player player, long currentTime) {
        if (player == null) {
            return 0;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.playersInCombat.containsKey(playerUUID)) {
            return 0;
        }
        long endTime = this.playersInCombat.get(playerUUID);
        return (int)Math.ceil(Math.max(0.0, (double)(endTime - currentTime) / 1000.0));
    }

    public void updateMutualCombat(Player player1, Player player2) {
        if (player1 != null && player1.isOnline() && player2 != null && player2.isOnline()) {
            this.tagPlayer(player1, player2);
            this.tagPlayer(player2, player1);
        }
    }

    public void setEnderPearlCooldown(Player player) {
        if (player == null) {
            return;
        }
        if (!this.enderPearlEnabled) {
            return;
        }
        String worldName = player.getWorld().getName();
        if (this.worldEnderPearlSettings.containsKey(worldName) && !this.worldEnderPearlSettings.get(worldName).booleanValue()) {
            return;
        }
        if (this.enderPearlInCombatOnly && !this.isInCombat(player)) {
            return;
        }
        this.enderPearlCooldowns.put(player.getUniqueId(), System.currentTimeMillis() + this.enderPearlCooldownSeconds * 1000L);
    }

    public boolean isEnderPearlOnCooldown(Player player) {
        if (player == null) {
            return false;
        }
        if (!this.enderPearlEnabled) {
            return false;
        }
        String worldName = player.getWorld().getName();
        if (this.worldEnderPearlSettings.containsKey(worldName) && !this.worldEnderPearlSettings.get(worldName).booleanValue()) {
            return false;
        }
        if (this.enderPearlInCombatOnly && !this.isInCombat(player)) {
            return false;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.enderPearlCooldowns.containsKey(playerUUID)) {
            return false;
        }
        long cooldownEndTime = this.enderPearlCooldowns.get(playerUUID);
        long currentTime = System.currentTimeMillis();
        if (currentTime > cooldownEndTime) {
            this.enderPearlCooldowns.remove(playerUUID);
            return false;
        }
        return true;
    }

    public void refreshCombatOnPearlLand(Player player) {
        long currentEndTime;
        if (player == null || !this.refreshCombatOnPearlLand) {
            return;
        }
        if (!this.isInCombat(player)) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        long newEndTime = System.currentTimeMillis() + this.combatDurationSeconds * 1000L;
        if (newEndTime > (currentEndTime = this.playersInCombat.getOrDefault(playerUUID, 0L).longValue())) {
            this.playersInCombat.put(playerUUID, newEndTime);
            this.plugin.debug("Refreshed combat time for " + player.getName() + " due to pearl landing");
        }
    }

    public int getRemainingEnderPearlCooldown(Player player) {
        return this.getRemainingEnderPearlCooldown(player, System.currentTimeMillis());
    }

    private int getRemainingEnderPearlCooldown(Player player, long currentTime) {
        if (player == null) {
            return 0;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.enderPearlCooldowns.containsKey(playerUUID)) {
            return 0;
        }
        long endTime = this.enderPearlCooldowns.get(playerUUID);
        return (int)Math.ceil(Math.max(0.0, (double)(endTime - currentTime) / 1000.0));
    }

    public boolean shouldDisableFlight(Player player) {
        if (player == null) {
            return false;
        }
        if (!this.disableFlightInCombat || !this.isInCombat(player)) {
            return false;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        this.plugin.getMessageService().sendMessage(player, "combat_fly_disabled", placeholders);
        return true;
    }

    public void setTridentCooldown(Player player) {
        if (player == null) {
            return;
        }
        if (!this.tridentEnabled) {
            return;
        }
        String worldName = player.getWorld().getName();
        if (this.worldTridentSettings.containsKey(worldName) && !this.worldTridentSettings.get(worldName).booleanValue()) {
            return;
        }
        if (this.tridentInCombatOnly && !this.isInCombat(player)) {
            return;
        }
        this.tridentCooldowns.put(player.getUniqueId(), System.currentTimeMillis() + this.tridentCooldownSeconds * 1000L);
    }

    public boolean isTridentOnCooldown(Player player) {
        if (player == null) {
            return false;
        }
        if (!this.tridentEnabled) {
            return false;
        }
        String worldName = player.getWorld().getName();
        if (this.worldTridentSettings.containsKey(worldName) && !this.worldTridentSettings.get(worldName).booleanValue()) {
            return false;
        }
        if (this.tridentInCombatOnly && !this.isInCombat(player)) {
            return false;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.tridentCooldowns.containsKey(playerUUID)) {
            return false;
        }
        long cooldownEndTime = this.tridentCooldowns.get(playerUUID);
        long currentTime = System.currentTimeMillis();
        if (currentTime > cooldownEndTime) {
            this.tridentCooldowns.remove(playerUUID);
            return false;
        }
        return true;
    }

    public boolean isTridentBanned(Player player) {
        if (player == null) {
            return false;
        }
        String worldName = player.getWorld().getName();
        return this.worldTridentBannedSettings.getOrDefault(worldName, false);
    }

    public void refreshCombatOnTridentLand(Player player) {
        long currentEndTime;
        if (player == null || !this.refreshCombatOnTridentLand) {
            return;
        }
        if (!this.isInCombat(player)) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        long newEndTime = System.currentTimeMillis() + this.combatDurationSeconds * 1000L;
        if (newEndTime > (currentEndTime = this.playersInCombat.getOrDefault(playerUUID, 0L).longValue())) {
            this.playersInCombat.put(playerUUID, newEndTime);
            this.plugin.debug("Refreshed combat time for " + player.getName() + " due to trident landing");
        }
    }

    public int getRemainingTridentCooldown(Player player) {
        return this.getRemainingTridentCooldown(player, System.currentTimeMillis());
    }

    private int getRemainingTridentCooldown(Player player, long currentTime) {
        if (player == null) {
            return 0;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.tridentCooldowns.containsKey(playerUUID)) {
            return 0;
        }
        long endTime = this.tridentCooldowns.get(playerUUID);
        return (int)Math.ceil(Math.max(0.0, (double)(endTime - currentTime) / 1000.0));
    }

    public void shutdown() {
        if (this.globalCountdownTask != null) {
            this.globalCountdownTask.cancel();
            this.globalCountdownTask = null;
        }
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
        }
        this.combatTasks.values().forEach(Scheduler.Task::cancel);
        this.combatTasks.clear();
        this.playersInCombat.clear();
        this.combatOpponents.clear();
        this.enderPearlCooldowns.clear();
        this.tridentCooldowns.clear();
    }

    @Generated
    public Map<UUID, Long> getPlayersInCombat() {
        return this.playersInCombat;
    }

    @Generated
    public Map<UUID, Long> getEnderPearlCooldowns() {
        return this.enderPearlCooldowns;
    }

    @Generated
    public Map<UUID, Long> getTridentCooldowns() {
        return this.tridentCooldowns;
    }
}

