/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.combat;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.Scheduler;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class DeathAnimationManager {
    private final CelestCombatPro plugin;
    private final Random random = new Random();

    public DeathAnimationManager(CelestCombatPro plugin) {
        this.plugin = plugin;
    }

    public void performDeathAnimation(Player victim, Player killer) {
        if (!this.plugin.getConfig().getBoolean("death_animation.enabled", true)) {
            return;
        }
        if (killer == null && this.plugin.getConfig().getBoolean("death_animation.only_player_kill", true)) {
            return;
        }
        Location deathLocation = victim.getLocation();
        World world = deathLocation.getWorld();
        if (world == null) {
            return;
        }
        ArrayList<String> availableAnimations = new ArrayList<String>();
        if (this.plugin.getConfig().getBoolean("death_animation.animation.lightning", true)) {
            availableAnimations.add("lightning");
        }
        if (this.plugin.getConfig().getBoolean("death_animation.animation.fire_particles", true)) {
            availableAnimations.add("fire_particles");
        }
        if (availableAnimations.isEmpty()) {
            return;
        }
        String selectedAnimation = (String)availableAnimations.get(this.random.nextInt(availableAnimations.size()));
        Scheduler.runLocationTask(deathLocation, () -> {
            switch (selectedAnimation) {
                case "lightning": {
                    this.performLightningAnimation(world, deathLocation);
                    break;
                }
                case "fire_particles": {
                    this.performParticleAnimation(world, deathLocation);
                }
            }
        });
    }

    private void performLightningAnimation(World world, Location location) {
        world.strikeLightningEffect(location);
        world.playSound(location, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 1.0f, 1.0f);
    }

    private void performParticleAnimation(World world, Location location) {
        for (int i = 0; i < 50; ++i) {
            double angle = Math.PI * 2 * (double)i / 50.0;
            double x = Math.cos(angle) * 2.0;
            double z = Math.sin(angle) * 2.0;
            world.spawnParticle(Particle.FLAME, location.clone().add(x, 1.0, z), 1, 0.1, 0.1, 0.1, 0.05);
        }
        world.playSound(location, Sound.ENTITY_FIREWORK_ROCKET_LARGE_BLAST, 1.0f, 1.0f);
    }
}

