/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.commands;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.commands.BaseCommand;
import com.shyamstudio.celestCombatPro.commands.TabCompleter;
import com.shyamstudio.celestCombatPro.commands.subcommands.HelpCommand;
import com.shyamstudio.celestCombatPro.commands.subcommands.KillRewardCommand;
import com.shyamstudio.celestCombatPro.commands.subcommands.NewbieProtectionCommand;
import com.shyamstudio.celestCombatPro.commands.subcommands.ReloadCommand;
import com.shyamstudio.celestCombatPro.commands.subcommands.RemoveTagCommand;
import com.shyamstudio.celestCombatPro.commands.subcommands.TagCommand;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;

public class CommandManager
implements CommandExecutor {
    private final CelestCombatPro plugin;
    private final Map<String, BaseCommand> commands = new HashMap<String, BaseCommand>();
    private final TabCompleter tabCompleter;

    public CommandManager(CelestCombatPro plugin) {
        this.plugin = plugin;
        this.tabCompleter = new TabCompleter(this);
    }

    public void registerCommands() {
        this.registerCommand("reload", new ReloadCommand(this.plugin));
        this.registerCommand("tag", new TagCommand(this.plugin));
        this.registerCommand("help", new HelpCommand(this.plugin));
        this.registerCommand("removeTag", new RemoveTagCommand(this.plugin));
        this.registerCommand("killReward", new KillRewardCommand(this.plugin));
        this.registerCommand("newbieProtection", new NewbieProtectionCommand(this.plugin));
        PluginCommand mainCommand = this.plugin.getCommand("celestcombat");
        if (mainCommand != null) {
            mainCommand.setExecutor((CommandExecutor)this);
            mainCommand.setTabCompleter((org.bukkit.command.TabCompleter)this.tabCompleter);
        }
    }

    private void registerCommand(String name, BaseCommand command) {
        this.commands.put(name, command);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            this.commands.get("help").execute(sender, args);
            return true;
        }
        String subCommand = args[0];
        BaseCommand command = this.commands.get(subCommand);
        if (command == null) {
            this.commands.get("help").execute(sender, args);
            return true;
        }
        String[] subArgs = new String[args.length - 1];
        System.arraycopy(args, 1, subArgs, 0, args.length - 1);
        return command.execute(sender, subArgs);
    }

    @Generated
    public Map<String, BaseCommand> getCommands() {
        return this.commands;
    }
}

