/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.commands.subcommands;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.commands.BaseCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KillRewardCommand
extends BaseCommand {
    public KillRewardCommand(CelestCombatPro plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.checkSender(sender)) {
            return true;
        }
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        String subCommand = args[0];
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "check": {
                return this.executeCheck(sender, subArgs);
            }
            case "clear": {
                return this.executeClear(sender, subArgs);
            }
            case "clearAll": {
                return this.executeClearAll(sender, subArgs);
            }
        }
        this.sendUsage(sender);
        return true;
    }

    private boolean executeCheck(CommandSender sender, String[] args) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length < 1 || args.length > 2) {
            sender.sendMessage("\u00a7cUsage: /celestcombat killReward check <player> [target_player]");
            return true;
        }
        Player killer = Bukkit.getPlayer((String)args[0]);
        if (killer == null) {
            placeholders.put("player", args[0]);
            this.messageService.sendMessage(sender, "player_not_found", placeholders);
            return true;
        }
        Player victim = null;
        if (args.length == 2 && (victim = Bukkit.getPlayer((String)args[1])) == null) {
            placeholders.put("player", args[1]);
            this.messageService.sendMessage(sender, "player_not_found", placeholders);
            return true;
        }
        long remainingMs = this.plugin.getKillRewardManager().getRemainingCooldown(killer, victim);
        if (remainingMs <= 0L) {
            placeholders.put("player", killer.getName());
            if (victim != null) {
                placeholders.put("target", victim.getName());
                this.messageService.sendMessage(sender, "no_kill_cooldown_target", placeholders);
            } else {
                this.messageService.sendMessage(sender, "no_kill_cooldown", placeholders);
            }
        } else {
            String formattedTime = this.formatTime(remainingMs);
            placeholders.put("player", killer.getName());
            placeholders.put("time", formattedTime);
            if (victim != null) {
                placeholders.put("target", victim.getName());
                this.messageService.sendMessage(sender, "kill_cooldown_remaining_target", placeholders);
            } else {
                this.messageService.sendMessage(sender, "kill_cooldown_remaining", placeholders);
            }
        }
        return true;
    }

    private boolean executeClear(CommandSender sender, String[] args) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length != 1) {
            sender.sendMessage("\u00a7cUsage: /celestcombat killReward clear <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            placeholders.put("player", args[0]);
            this.messageService.sendMessage(sender, "player_not_found", placeholders);
            return true;
        }
        this.plugin.getKillRewardManager().clearPlayerCooldowns(target);
        placeholders.put("player", target.getName());
        this.messageService.sendMessage(sender, "clear_cooldown_success", placeholders);
        return true;
    }

    private boolean executeClearAll(CommandSender sender, String[] args) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length != 0) {
            sender.sendMessage("\u00a7cUsage: /celestcombat killReward clearAll");
            return true;
        }
        int cooldownCount = this.plugin.getKillRewardManager().getKillRewardCooldowns().size();
        if (cooldownCount == 0) {
            this.messageService.sendMessage(sender, "no_cooldowns_to_clear", placeholders);
            return true;
        }
        this.plugin.getKillRewardManager().getKillRewardCooldowns().clear();
        placeholders.put("count", String.valueOf(cooldownCount));
        this.messageService.sendMessage(sender, "clear_all_cooldowns_success", placeholders);
        return true;
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage("\u00a7cUsage:");
        sender.sendMessage("\u00a7c/celestcombat killReward check <player> [target_player]");
        sender.sendMessage("\u00a7c/celestcombat killReward clear <player>");
        sender.sendMessage("\u00a7c/celestcombat killReward clearAll");
    }

    private String formatTime(long milliseconds) {
        long days = TimeUnit.MILLISECONDS.toDays(milliseconds);
        long hours = TimeUnit.MILLISECONDS.toHours(milliseconds) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds) % 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(milliseconds) % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            sb.append(seconds).append("s");
        }
        return sb.length() > 0 ? sb.toString().trim() : "0s";
    }

    @Override
    public String getPermission() {
        return "celestcombat.command.use";
    }

    @Override
    public boolean isPlayerOnly() {
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("check", "clear", "clearAll").stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length >= 2) {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "check": {
                    if (args.length != 2 && args.length != 3) break;
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
                }
                case "clear": {
                    if (args.length != 2) break;
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                }
            }
        }
        return super.tabComplete(sender, args);
    }
}

