/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.commands.subcommands;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.commands.BaseCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class NewbieProtectionCommand
extends BaseCommand {
    public NewbieProtectionCommand(CelestCombatPro plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.checkSender(sender)) {
            return true;
        }
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        String subCommand = args[0];
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand.toLowerCase()) {
            case "give": {
                return this.executeGive(sender, subArgs);
            }
            case "remove": {
                return this.executeRemove(sender, subArgs);
            }
            case "check": {
                return this.executeCheck(sender, subArgs);
            }
        }
        this.sendUsage(sender);
        return true;
    }

    private boolean executeGive(CommandSender sender, String[] args) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length != 1) {
            sender.sendMessage("\u00a7cUsage: /celestcombat newbieProtection give <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            placeholders.put("player", args[0]);
            this.messageService.sendMessage(sender, "player_not_found", placeholders);
            return true;
        }
        if (this.plugin.getNewbieProtectionManager().hasProtection(target)) {
            placeholders.put("player", target.getName());
            this.messageService.sendMessage(sender, "newbie_protection_already_has", placeholders);
            return true;
        }
        this.plugin.getNewbieProtectionManager().grantProtection(target);
        placeholders.put("player", target.getName());
        this.messageService.sendMessage(sender, "newbie_protection_give_success", placeholders);
        return true;
    }

    private boolean executeRemove(CommandSender sender, String[] args) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length != 1) {
            sender.sendMessage("\u00a7cUsage: /celestcombat newbieProtection remove <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            placeholders.put("player", args[0]);
            this.messageService.sendMessage(sender, "player_not_found", placeholders);
            return true;
        }
        if (!this.plugin.getNewbieProtectionManager().hasProtection(target)) {
            placeholders.put("player", target.getName());
            this.messageService.sendMessage(sender, "newbie_protection_not_protected", placeholders);
            return true;
        }
        this.plugin.getNewbieProtectionManager().removeProtection(target, false);
        placeholders.put("player", target.getName());
        this.messageService.sendMessage(sender, "newbie_protection_remove_success", placeholders);
        return true;
    }

    private boolean executeCheck(CommandSender sender, String[] args) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length != 1) {
            sender.sendMessage("\u00a7cUsage: /celestcombat newbieProtection check <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            placeholders.put("player", args[0]);
            this.messageService.sendMessage(sender, "player_not_found", placeholders);
            return true;
        }
        if (!this.plugin.getNewbieProtectionManager().hasProtection(target)) {
            placeholders.put("player", target.getName());
            this.messageService.sendMessage(sender, "newbie_protection_not_protected", placeholders);
            return true;
        }
        long remainingTime = this.plugin.getNewbieProtectionManager().getRemainingTime(target);
        String formattedTime = this.formatTime(remainingTime);
        placeholders.put("player", target.getName());
        placeholders.put("time", formattedTime);
        this.messageService.sendMessage(sender, "newbie_protection_check_protected", placeholders);
        return true;
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage("\u00a7cUsage:");
        sender.sendMessage("\u00a7c/celestcombat newbieProtection give <player>");
        sender.sendMessage("\u00a7c/celestcombat newbieProtection remove <player>");
        sender.sendMessage("\u00a7c/celestcombat newbieProtection check <player>");
    }

    private String formatTime(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (secs > 0L || sb.length() == 0) {
            sb.append(secs).append("s");
        }
        return sb.toString().trim();
    }

    @Override
    public String getPermission() {
        return "celestcombat.command.use";
    }

    @Override
    public boolean isPlayerOnly() {
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("give", "remove", "check").stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return super.tabComplete(sender, args);
    }
}

