/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.commands.subcommands;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.commands.BaseCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;

public class RemoveTagCommand
extends BaseCommand {
    public RemoveTagCommand(CelestCombatPro plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.checkSender(sender)) {
            return true;
        }
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "player": {
                return this.executeRemovePlayer(sender, subArgs);
            }
            case "world": {
                return this.executeRemoveWorld(sender, subArgs);
            }
            case "all": {
                return this.executeRemoveAll(sender, subArgs);
            }
        }
        this.sendUsage(sender);
        return true;
    }

    private boolean executeRemovePlayer(CommandSender sender, String[] args) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length != 1) {
            sender.sendMessage("\u00a7cUsage: /celestcombat removeTag player <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            placeholders.put("player", args[0]);
            this.messageService.sendMessage(sender, "player_not_found", placeholders);
            return true;
        }
        if (!this.plugin.getCombatManager().isInCombat(target)) {
            placeholders.put("player", target.getName());
            this.messageService.sendMessage(sender, "player_not_in_combat", placeholders);
            return true;
        }
        this.plugin.getCombatManager().removeFromCombatSilently(target);
        placeholders.put("player", target.getName());
        this.messageService.sendMessage(sender, "combat_remove_success", placeholders);
        return true;
    }

    private boolean executeRemoveWorld(CommandSender sender, String[] args) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length != 1) {
            sender.sendMessage("\u00a7cUsage: /celestcombat removeTag world <world>");
            return true;
        }
        World targetWorld = Bukkit.getWorld((String)args[0]);
        if (targetWorld == null) {
            placeholders.put("world", args[0]);
            this.messageService.sendMessage(sender, "world_not_found", placeholders);
            return true;
        }
        List playersInCombat = Bukkit.getOnlinePlayers().stream().filter(player -> player.getWorld().equals((Object)targetWorld)).filter(player -> this.plugin.getCombatManager().isInCombat((Player)player)).collect(Collectors.toList());
        if (playersInCombat.isEmpty()) {
            placeholders.put("world", targetWorld.getName());
            this.messageService.sendMessage(sender, "no_players_in_combat_world", placeholders);
            return true;
        }
        int removedCount = 0;
        for (Player player2 : playersInCombat) {
            this.plugin.getCombatManager().removeFromCombatSilently(player2);
            ++removedCount;
        }
        placeholders.put("world", targetWorld.getName());
        placeholders.put("count", String.valueOf(removedCount));
        this.messageService.sendMessage(sender, "combat_remove_world_success", placeholders);
        return true;
    }

    private boolean executeRemoveAll(CommandSender sender, String[] args) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length != 0) {
            sender.sendMessage("\u00a7cUsage: /celestcombat removeTag all");
            return true;
        }
        List playersInCombat = Bukkit.getOnlinePlayers().stream().filter(player -> this.plugin.getCombatManager().isInCombat((Player)player)).collect(Collectors.toList());
        if (playersInCombat.isEmpty()) {
            this.messageService.sendMessage(sender, "no_players_in_combat_server", placeholders);
            return true;
        }
        int removedCount = 0;
        for (Player player2 : playersInCombat) {
            this.plugin.getCombatManager().removeFromCombatSilently(player2);
            ++removedCount;
        }
        placeholders.put("count", String.valueOf(removedCount));
        this.messageService.sendMessage(sender, "combat_remove_all_success", placeholders);
        return true;
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage("\u00a7cUsage:");
        sender.sendMessage("\u00a7c/celestcombat removeTag player <player>");
        sender.sendMessage("\u00a7c/celestcombat removeTag world <world>");
        sender.sendMessage("\u00a7c/celestcombat removeTag all");
    }

    @Override
    public String getPermission() {
        return "celestcombat.command.use";
    }

    @Override
    public boolean isPlayerOnly() {
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("player", "world", "all").stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "player": {
                    return Bukkit.getOnlinePlayers().stream().filter(player -> this.plugin.getCombatManager().isInCombat((Player)player)).map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                }
                case "world": {
                    return Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                }
            }
        }
        return super.tabComplete(sender, args);
    }
}

