/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.commands.subcommands;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.commands.BaseCommand;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TagCommand
extends BaseCommand {
    public TagCommand(CelestCombatPro plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.checkSender(sender)) {
            return true;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (args.length < 1 || args.length > 2) {
            sender.sendMessage("\u00a7cUsage: /celestcombat tag <player1> [player2]");
            return true;
        }
        Player player1 = Bukkit.getPlayer((String)args[0]);
        if (player1 == null) {
            placeholders.put("player", args[0]);
            this.messageService.sendMessage(sender, "player_not_found", placeholders);
            return true;
        }
        if (args.length == 1) {
            this.plugin.getCombatManager().updateMutualCombat(player1, player1);
            placeholders.put("player", player1.getName());
            this.messageService.sendMessage(sender, "combat_tag_single_success", placeholders);
        } else {
            Player player2 = Bukkit.getPlayer((String)args[1]);
            if (player2 == null) {
                placeholders.put("player", args[1]);
                this.messageService.sendMessage(sender, "player_not_found", placeholders);
                return true;
            }
            this.plugin.getCombatManager().updateMutualCombat(player1, player2);
            placeholders.put("player1", player1.getName());
            placeholders.put("player2", player2.getName());
            this.messageService.sendMessage(sender, "combat_tag_success", placeholders);
        }
        return true;
    }

    @Override
    public String getPermission() {
        return "celestcombat.command.use";
    }

    @Override
    public boolean isPlayerOnly() {
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1 || args.length == 2) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
        }
        return super.tabComplete(sender, args);
    }
}

