/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.hooks.protection;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.Scheduler;
import com.shyamstudio.celestCombatPro.combat.CombatManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.util.Vector;

public class GriefPreventionHook
implements Listener {
    private final CelestCombatPro plugin;
    private final CombatManager combatManager;
    private final Map<UUID, Long> lastMessageTime = new ConcurrentHashMap<UUID, Long>();
    private final long MESSAGE_COOLDOWN = 2000L;
    private final Map<UUID, Set<Location>> playerBarriers = new ConcurrentHashMap<UUID, Set<Location>>();
    private final Map<Location, Material> originalBlocks = new ConcurrentHashMap<Location, Material>();
    private final Map<Location, Set<UUID>> barrierViewers = new ConcurrentHashMap<Location, Set<UUID>>();
    private boolean globalEnabled;
    private final Map<String, Boolean> worldSettings = new HashMap<String, Boolean>();
    private int barrierDetectionRadius;
    private int barrierHeight;
    private Material barrierMaterial;
    private double pushBackForce;
    private ClaimPermission requiredPermission;
    private final Map<String, Boolean> claimCache = new ConcurrentHashMap<String, Boolean>();
    private long lastCacheClean = System.currentTimeMillis();
    private static final long CACHE_CLEAN_INTERVAL = 30000L;
    private static final int MAX_CACHE_SIZE = 1000;

    public GriefPreventionHook(CelestCombatPro plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
        this.reloadConfig();
        this.startCleanupTask();
    }

    public void reloadConfig() {
        this.globalEnabled = this.plugin.getConfig().getBoolean("claim_protection.enabled", true);
        this.barrierDetectionRadius = this.plugin.getConfig().getInt("claim_protection.barrier_detection_radius", 5);
        this.barrierHeight = this.plugin.getConfig().getInt("claim_protection.barrier_height", 3);
        this.barrierMaterial = this.loadBarrierMaterial();
        this.pushBackForce = this.plugin.getConfig().getDouble("claim_protection.push_back_force", 0.6);
        this.requiredPermission = this.loadRequiredPermission();
        this.loadWorldSettings();
        this.claimCache.clear();
    }

    private void loadWorldSettings() {
        ConfigurationSection worldSection;
        this.worldSettings.clear();
        if (this.plugin.getConfig().isConfigurationSection("claim_protection.worlds") && (worldSection = this.plugin.getConfig().getConfigurationSection("claim_protection.worlds")) != null) {
            for (String worldName : worldSection.getKeys(false)) {
                boolean enabled = worldSection.getBoolean(worldName, this.globalEnabled);
                this.worldSettings.put(worldName, enabled);
                this.plugin.debug("Claim protection for world '" + worldName + "': " + (enabled ? "enabled" : "disabled"));
            }
        }
        this.plugin.debug("Loaded " + this.worldSettings.size() + " world-specific claim protection settings");
    }

    private boolean isEnabledInWorld(World world) {
        if (world == null) {
            return false;
        }
        String worldName = world.getName();
        if (this.worldSettings.containsKey(worldName)) {
            return this.worldSettings.get(worldName);
        }
        return this.globalEnabled;
    }

    private boolean isEnabledAtLocation(Location location) {
        return location != null && this.isEnabledInWorld(location.getWorld());
    }

    private ClaimPermission loadRequiredPermission() {
        String permissionName = this.plugin.getConfig().getString("claim_protection.required_permission", "BUILD");
        try {
            ClaimPermission permission;
            switch (permissionName.toUpperCase()) {
                case "MANAGE": {
                    permission = ClaimPermission.Manage;
                    break;
                }
                case "ACCESS": {
                    permission = ClaimPermission.Access;
                    break;
                }
                case "EDIT": {
                    permission = ClaimPermission.Edit;
                    break;
                }
                case "BUILD": {
                    permission = ClaimPermission.Build;
                    break;
                }
                case "CONTAINER": {
                    permission = ClaimPermission.Inventory;
                    break;
                }
                default: {
                    this.plugin.getLogger().warning("Invalid claim permission '" + permissionName + "' in config. Using BUILD instead.");
                    this.plugin.getLogger().warning("Valid permissions are: MANAGE, ACCESS, EDIT, BUILD, INVENTORY");
                    return ClaimPermission.Build;
                }
            }
            this.plugin.debug("Using claim permission: " + permission.name() + " for protection checks.");
            return permission;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error loading claim permission '" + permissionName + "': " + e.getMessage());
            this.plugin.getLogger().warning("Valid permissions are: MANAGE, ACCESS, EDIT, BUILD, INVENTORY");
            return ClaimPermission.Build;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabledAtLocation(event.getTo())) {
            this.removePlayerBarriers(player);
            return;
        }
        if (!this.combatManager.isInCombat(player)) {
            this.removePlayerBarriers(player);
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
            return;
        }
        boolean fromProtected = this.isInProtectedClaim(from, player);
        boolean toProtected = this.isInProtectedClaim(to, player);
        if (!fromProtected && toProtected) {
            this.pushPlayerBack(player, from, to);
            this.sendCooldownMessage(player);
        }
        this.updatePlayerBarriers(player);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabledAtLocation(player.getLocation())) {
            this.removePlayerBarriers(player);
            return;
        }
        if (!this.combatManager.isInCombat(player)) {
            this.removePlayerBarriers(player);
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Location blockLoc = event.getClickedBlock().getLocation();
        Set<Location> playerBarrierSet = this.playerBarriers.get(player.getUniqueId());
        if (playerBarrierSet != null && this.containsBlockLocation(playerBarrierSet, blockLoc)) {
            event.setCancelled(true);
            Scheduler.runTaskLater(() -> this.refreshBarrierBlock(blockLoc, player), 1L);
        }
    }

    private boolean containsBlockLocation(Set<Location> locations, Location blockLoc) {
        Location normalizedBlockLoc = this.normalizeToBlockLocation(blockLoc);
        for (Location loc : locations) {
            Location normalizedLoc = this.normalizeToBlockLocation(loc);
            if (!normalizedLoc.equals((Object)normalizedBlockLoc)) continue;
            return true;
        }
        return false;
    }

    private Location normalizeToBlockLocation(Location loc) {
        return new Location(loc.getWorld(), (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ());
    }

    private void refreshBarrierBlock(Location loc, Player player) {
        Location normalizedLoc = this.normalizeToBlockLocation(loc);
        Set<UUID> viewers = this.barrierViewers.get(normalizedLoc);
        if (viewers != null && viewers.contains(player.getUniqueId())) {
            player.sendBlockChange(normalizedLoc, this.barrierMaterial.createBlockData());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.isEnabledAtLocation(event.getBlock().getLocation())) {
            return;
        }
        Location blockLoc = this.normalizeToBlockLocation(event.getBlock().getLocation());
        if (this.originalBlocks.containsKey(blockLoc)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.removePlayerBarriers(player);
        this.lastMessageTime.remove(playerUUID);
    }

    private void pushPlayerBack(Player player, Location from, Location to) {
        Vector direction = from.toVector().subtract(to.toVector()).normalize();
        direction.multiply(this.pushBackForce);
        Location pushLocation = player.getLocation().clone();
        pushLocation.add(direction);
        pushLocation.setY(this.getSafeY(pushLocation));
        pushLocation.setPitch(player.getLocation().getPitch());
        pushLocation.setYaw(player.getLocation().getYaw());
        player.setVelocity(direction);
    }

    private double getSafeY(Location loc) {
        int y;
        Block block = loc.getBlock();
        if (!block.getType().isSolid()) {
            return loc.getY();
        }
        for (y = 1; y <= 2; ++y) {
            Block above = block.getRelative(0, y, 0);
            if (above.getType().isSolid()) continue;
            return loc.getBlockY() + y;
        }
        for (y = 1; y <= 2; ++y) {
            Block below = block.getRelative(0, -y, 0);
            if (below.getType().isSolid() || below.getRelative(0, -1, 0).getType().isSolid()) continue;
            return loc.getBlockY() - y;
        }
        return loc.getY();
    }

    private void updatePlayerBarriers(Player player) {
        if (!this.isEnabledAtLocation(player.getLocation())) {
            this.removePlayerBarriers(player);
            return;
        }
        if (!this.combatManager.isInCombat(player)) {
            this.removePlayerBarriers(player);
            return;
        }
        Set<Location> newBarriers = this.findNearbyBarrierLocations(player.getLocation(), player);
        Set currentBarriers = this.playerBarriers.getOrDefault(player.getUniqueId(), new HashSet());
        HashSet toRemove = new HashSet(currentBarriers);
        toRemove.removeAll(newBarriers);
        for (Location loc : toRemove) {
            this.removeBarrierBlock(loc, player);
        }
        HashSet<Location> toAdd = new HashSet<Location>(newBarriers);
        toAdd.removeAll(currentBarriers);
        for (Location loc : toAdd) {
            this.createBarrierBlock(loc, player);
        }
        if (newBarriers.isEmpty()) {
            this.playerBarriers.remove(player.getUniqueId());
        } else {
            this.playerBarriers.put(player.getUniqueId(), newBarriers);
        }
    }

    private Set<Location> findNearbyBarrierLocations(Location playerLoc, Player player) {
        HashSet<Location> barrierLocations = new HashSet<Location>();
        int radius = this.barrierDetectionRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -2; y <= this.barrierHeight; ++y) {
                    Location checkLoc = playerLoc.clone().add((double)x, (double)y, (double)z);
                    if (checkLoc.distance(playerLoc) > (double)radius || !this.isBorderLocation(checkLoc, player)) continue;
                    barrierLocations.add(this.normalizeToBlockLocation(checkLoc));
                }
            }
        }
        return barrierLocations;
    }

    private boolean isBorderLocation(Location loc, Player player) {
        int[][] directions;
        if (!this.isInProtectedClaim(loc, player)) {
            return false;
        }
        for (int[] dir : directions = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}}) {
            Location adjacent = loc.clone().add((double)dir[0], (double)dir[1], (double)dir[2]);
            if (this.isInProtectedClaim(adjacent, player)) continue;
            return true;
        }
        return false;
    }

    private void createBarrierBlock(Location loc, Player player) {
        Location normalizedLoc = this.normalizeToBlockLocation(loc);
        Block block = normalizedLoc.getBlock();
        if (block.getType() != Material.AIR && block.getType().isSolid()) {
            return;
        }
        this.originalBlocks.put(normalizedLoc, block.getType());
        this.barrierViewers.computeIfAbsent(normalizedLoc, k -> new HashSet()).add(player.getUniqueId());
        player.sendBlockChange(normalizedLoc, this.barrierMaterial.createBlockData());
    }

    private void removeBarrierBlock(Location loc, Player player) {
        Location normalizedLoc = this.normalizeToBlockLocation(loc);
        Set<UUID> viewers = this.barrierViewers.get(normalizedLoc);
        if (viewers != null) {
            viewers.remove(player.getUniqueId());
            if (viewers.isEmpty()) {
                this.barrierViewers.remove(normalizedLoc);
                Material originalType = this.originalBlocks.remove(normalizedLoc);
                if (originalType != null) {
                    player.sendBlockChange(normalizedLoc, originalType.createBlockData());
                }
            } else {
                Material originalType = this.originalBlocks.get(normalizedLoc);
                if (originalType != null) {
                    player.sendBlockChange(normalizedLoc, originalType.createBlockData());
                }
            }
        }
    }

    private void removePlayerBarriers(Player player) {
        Set<Location> barriers = this.playerBarriers.remove(player.getUniqueId());
        if (barriers != null) {
            for (Location loc : barriers) {
                this.removeBarrierBlock(loc, player);
            }
        }
    }

    private void startCleanupTask() {
        Scheduler.runTaskTimerAsync(() -> {
            long currentTime = System.currentTimeMillis();
            this.cleanupPlayerBarriers();
            this.cleanupMessageCooldowns(currentTime);
            this.cleanupClaimCache(currentTime);
        }, 100L, 100L);
    }

    private void cleanupPlayerBarriers() {
        Iterator<Map.Entry<UUID, Set<Location>>> iterator = this.playerBarriers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Set<Location>> entry = iterator.next();
            UUID playerUUID = entry.getKey();
            Player player = this.plugin.getServer().getPlayer(playerUUID);
            if (player != null && player.isOnline() && this.combatManager.isInCombat(player)) continue;
            Set<Location> barriers = entry.getValue();
            if (player != null && player.isOnline()) {
                for (Location loc : barriers) {
                    this.removeBarrierBlock(loc, player);
                }
            } else {
                for (Location loc : barriers) {
                    this.cleanupOfflinePlayerBarrier(loc, playerUUID);
                }
            }
            iterator.remove();
        }
    }

    private void cleanupOfflinePlayerBarrier(Location loc, UUID playerUUID) {
        Location normalizedLoc = this.normalizeToBlockLocation(loc);
        Set<UUID> viewers = this.barrierViewers.get(normalizedLoc);
        if (viewers != null) {
            viewers.remove(playerUUID);
            if (viewers.isEmpty()) {
                this.barrierViewers.remove(normalizedLoc);
                this.originalBlocks.remove(normalizedLoc);
            }
        }
    }

    private void cleanupMessageCooldowns(long currentTime) {
        this.lastMessageTime.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 20000L);
    }

    private void cleanupClaimCache(long currentTime) {
        if (currentTime - this.lastCacheClean > 30000L) {
            if (this.claimCache.size() > 1000) {
                this.claimCache.clear();
            }
            this.lastCacheClean = currentTime;
        }
    }

    private boolean isInProtectedClaim(Location location, Player player) {
        if (location == null) {
            return false;
        }
        String cacheKey = location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ() + ":" + player.getUniqueId().toString();
        Boolean cached = this.claimCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        try {
            Claim claim = GriefPrevention.instance.dataStore.getClaimAt(location, false, null);
            boolean isProtected = false;
            if (claim != null) {
                Supplier permissionResult = claim.checkPermission(player, this.requiredPermission, null);
                isProtected = permissionResult != null;
            }
            this.claimCache.put(cacheKey, isProtected);
            return isProtected;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error checking GriefPrevention claim: " + e.getMessage());
            return false;
        }
    }

    private boolean isLocationSafe(Location location) {
        if (location == null) {
            return false;
        }
        Block feet = location.getBlock();
        Block head = location.clone().add(0.0, 1.0, 0.0).getBlock();
        Block ground = location.clone().add(0.0, -1.0, 0.0).getBlock();
        return !(feet.getType() != Material.AIR && feet.getType().isSolid() || head.getType() != Material.AIR && head.getType().isSolid() || !ground.getType().isSolid());
    }

    private void sendCooldownMessage(Player player) {
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastMessageTime.get(playerUUID);
        if (lastTime != null && currentTime - lastTime < 2000L) {
            return;
        }
        this.lastMessageTime.put(playerUUID, currentTime);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("time", String.valueOf(this.combatManager.getRemainingCombatTime(player)));
        this.plugin.getMessageService().sendMessage(player, "combat_no_claim_entry", placeholders);
    }

    private Material loadBarrierMaterial() {
        String materialName = this.plugin.getConfig().getString("claim_protection.barrier_material", "BLUE_STAINED_GLASS");
        try {
            Material material = Material.valueOf((String)materialName.toUpperCase());
            if (!material.isBlock()) {
                this.plugin.getLogger().warning("Barrier material '" + materialName + "' is not a valid block material. Using BLUE_STAINED_GLASS instead.");
                return Material.BLUE_STAINED_GLASS;
            }
            this.plugin.debug("Using barrier material: " + material.name() + " for claim protection.");
            return material;
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid barrier material '" + materialName + "' in config. Using BLUE_STAINED_GLASS instead.");
            this.plugin.getLogger().warning("Valid materials can be found at: https://jd.papermc.io/paper/1.21.5/org/bukkit/Material.html");
            return Material.BLUE_STAINED_GLASS;
        }
    }

    public void cleanup() {
        this.playerBarriers.clear();
        this.originalBlocks.clear();
        this.barrierViewers.clear();
        this.lastMessageTime.clear();
        this.claimCache.clear();
        this.worldSettings.clear();
    }
}

