/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.hooks.protection;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.Scheduler;
import com.shyamstudio.celestCombatPro.combat.CombatManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class WorldGuardHook
implements Listener {
    private final CelestCombatPro plugin;
    private final CombatManager combatManager;
    private final Map<UUID, Long> lastMessageTime = new ConcurrentHashMap<UUID, Long>();
    private final long MESSAGE_COOLDOWN = 2000L;
    private final Map<UUID, UUID> combatPlayerPearls = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, PearlLocationData> pearlThrowLocations = new ConcurrentHashMap<UUID, PearlLocationData>();
    private final Map<UUID, Set<Location>> playerBarriers = new ConcurrentHashMap<UUID, Set<Location>>();
    private final Map<Location, Material> originalBlocks = new ConcurrentHashMap<Location, Material>();
    private final Map<Location, Set<UUID>> barrierViewers = new ConcurrentHashMap<Location, Set<UUID>>();
    private boolean globalEnabled;
    private Map<String, Boolean> worldSettings;
    private int barrierDetectionRadius;
    private int barrierHeight;
    private Material barrierMaterial;
    private double pushBackForce;
    private final Map<String, SafeZoneInfo> safeZoneCache = new ConcurrentHashMap<String, SafeZoneInfo>();
    private final Map<String, Long> regionCheckCache = new ConcurrentHashMap<String, Long>();
    private long lastCacheClean = System.currentTimeMillis();
    private static final long CACHE_CLEAN_INTERVAL = 30000L;
    private static final long CACHE_TTL = 10000L;
    private static final int MAX_CACHE_SIZE = 2000;
    private final Map<UUID, Long> lastBarrierUpdate = new ConcurrentHashMap<UUID, Long>();
    private static final long BARRIER_UPDATE_INTERVAL = 250L;
    private final Map<String, RegionManager> regionManagerCache = new ConcurrentHashMap<String, RegionManager>();
    private final RegionQuery regionQuery;

    public WorldGuardHook(CelestCombatPro plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
        this.regionQuery = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        this.reloadConfig();
        this.startCleanupTask();
    }

    public void reloadConfig() {
        this.globalEnabled = this.plugin.getConfig().getBoolean("safezone_protection.enabled", true);
        this.worldSettings = this.loadWorldSettings();
        this.barrierDetectionRadius = this.plugin.getConfig().getInt("safezone_protection.barrier_detection_radius", 5);
        this.barrierHeight = this.plugin.getConfig().getInt("safezone_protection.barrier_height", 3);
        this.barrierMaterial = this.loadBarrierMaterial();
        this.pushBackForce = this.plugin.getConfig().getDouble("safezone_protection.push_back_force", 0.6);
        this.safeZoneCache.clear();
        this.regionCheckCache.clear();
        this.regionManagerCache.clear();
        this.plugin.debug("WorldGuard safezone protection - Global enabled: " + this.globalEnabled);
        this.plugin.debug("WorldGuard safezone protection - World settings: " + String.valueOf(this.worldSettings));
    }

    private Map<String, Boolean> loadWorldSettings() {
        HashMap<String, Boolean> settings = new HashMap<String, Boolean>();
        if (this.plugin.getConfig().isConfigurationSection("safezone_protection.worlds")) {
            Set worldKeys = this.plugin.getConfig().getConfigurationSection("safezone_protection.worlds").getKeys(false);
            for (String worldName : worldKeys) {
                boolean enabled = this.plugin.getConfig().getBoolean("safezone_protection.worlds." + worldName, this.globalEnabled);
                settings.put(worldName, enabled);
                this.plugin.debug("World '" + worldName + "' safezone protection: " + enabled);
            }
        }
        return settings;
    }

    private boolean isEnabledInWorld(World world) {
        if (world == null) {
            return false;
        }
        String worldName = world.getName();
        if (this.worldSettings.containsKey(worldName)) {
            return this.worldSettings.get(worldName);
        }
        return this.globalEnabled;
    }

    private boolean isEnabledInWorld(Location location) {
        return location != null && this.isEnabledInWorld(location.getWorld());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (!(event.getEntity() instanceof EnderPearl)) {
            return;
        }
        ProjectileSource source = event.getEntity().getShooter();
        if (!(source instanceof Player)) {
            return;
        }
        Player player = (Player)source;
        if (!this.isEnabledInWorld(player.getWorld())) {
            return;
        }
        if (this.combatManager.isInCombat(player)) {
            this.combatPlayerPearls.put(event.getEntity().getUniqueId(), player.getUniqueId());
            this.pearlThrowLocations.put(player.getUniqueId(), new PearlLocationData(player.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof EnderPearl)) {
            return;
        }
        Location hitLocation = event.getEntity().getLocation();
        if (!this.isEnabledInWorld(hitLocation)) {
            return;
        }
        UUID projectileId = event.getEntity().getUniqueId();
        UUID playerUUID = this.combatPlayerPearls.remove(projectileId);
        if (playerUUID == null) {
            return;
        }
        Player player = this.plugin.getServer().getPlayer(playerUUID);
        Location teleportDestination = this.calculateTeleportDestination(event, event.getEntity());
        if (this.isSafeZone(teleportDestination)) {
            event.setCancelled(true);
            this.handlePearlTeleportBack(player, playerUUID);
        }
        this.pearlThrowLocations.remove(playerUUID);
    }

    private Location calculateTeleportDestination(ProjectileHitEvent event, Projectile projectile) {
        if (event.getHitBlock() != null) {
            Block hitPosition = event.getHitBlock();
            Location teleportDestination = new Location(projectile.getWorld(), (double)hitPosition.getX(), (double)hitPosition.getY(), (double)hitPosition.getZ());
            if (event.getHitBlockFace() != null) {
                teleportDestination.add(event.getHitBlockFace().getDirection().multiply(0.5));
            }
            return teleportDestination;
        }
        return projectile.getLocation();
    }

    private void handlePearlTeleportBack(Player player, UUID playerUUID) {
        if (player != null && player.isOnline()) {
            PearlLocationData pearlData = this.pearlThrowLocations.get(playerUUID);
            if (pearlData != null && !pearlData.isExpired()) {
                Location originalLocation = pearlData.location;
                player.teleportAsync(originalLocation).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.sendCooldownMessage(player, "combat_no_pearl_safezone");
                    } else {
                        this.handleFailedTeleport(player, originalLocation);
                    }
                });
            } else {
                this.sendCooldownMessage(player, "combat_no_pearl_safezone");
            }
        }
    }

    private void handleFailedTeleport(Player player, Location originalLocation) {
        Location safeLocation = this.findSafeLocation(originalLocation);
        if (safeLocation != null) {
            player.teleportAsync(safeLocation);
            this.sendCooldownMessage(player, "combat_no_pearl_safezone");
        } else {
            player.setHealth(0.0);
            this.plugin.getLogger().warning("Killed player " + player.getName() + " as no safe location could be found");
            this.sendCooldownMessage(player, "combat_killed_no_safe_location");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!CelestCombatPro.hasWorldGuard) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.isEnabledInWorld(player.getWorld())) {
            this.removePlayerBarriers(player);
            return;
        }
        if (!this.combatManager.isInCombat(player)) {
            this.removePlayerBarriers(player);
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null || from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
            return;
        }
        SafeZoneInfo fromInfo = this.getSafeZoneInfo(from);
        SafeZoneInfo toInfo = this.getSafeZoneInfo(to);
        if (!fromInfo.isSafeZone && toInfo.isSafeZone) {
            this.pushPlayerBack(player, from, to);
            this.sendCooldownMessage(player, "combat_no_safezone_entry");
        }
        this.updatePlayerBarriersThrottled(player);
    }

    private void updatePlayerBarriersThrottled(Player player) {
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastUpdate = this.lastBarrierUpdate.get(playerUUID);
        if (lastUpdate == null || currentTime - lastUpdate > 250L) {
            this.updatePlayerBarriers(player);
            this.lastBarrierUpdate.put(playerUUID, currentTime);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabledInWorld(player.getWorld())) {
            this.removePlayerBarriers(player);
            return;
        }
        if (!this.combatManager.isInCombat(player)) {
            this.removePlayerBarriers(player);
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Location blockLoc = event.getClickedBlock().getLocation();
        Set<Location> playerBarrierSet = this.playerBarriers.get(player.getUniqueId());
        if (playerBarrierSet != null && this.containsBlockLocation(playerBarrierSet, blockLoc)) {
            event.setCancelled(true);
            Scheduler.runTaskLater(() -> this.refreshBarrierBlock(blockLoc, player), 1L);
        }
    }

    private boolean containsBlockLocation(Set<Location> locations, Location blockLoc) {
        Location normalizedBlockLoc = this.normalizeToBlockLocation(blockLoc);
        for (Location loc : locations) {
            if (!this.normalizeToBlockLocation(loc).equals((Object)normalizedBlockLoc)) continue;
            return true;
        }
        return false;
    }

    private Location normalizeToBlockLocation(Location loc) {
        return new Location(loc.getWorld(), (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ());
    }

    private void refreshBarrierBlock(Location loc, Player player) {
        Location normalizedLoc = this.normalizeToBlockLocation(loc);
        Set<UUID> viewers = this.barrierViewers.get(normalizedLoc);
        if (viewers != null && viewers.contains(player.getUniqueId())) {
            player.sendBlockChange(normalizedLoc, this.barrierMaterial.createBlockData());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        Location blockLoc = this.normalizeToBlockLocation(event.getBlock().getLocation());
        if (this.originalBlocks.containsKey(blockLoc)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.removePlayerBarriers(player);
        this.lastMessageTime.remove(playerUUID);
        this.pearlThrowLocations.remove(playerUUID);
        this.lastBarrierUpdate.remove(playerUUID);
        this.combatPlayerPearls.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(playerUUID));
    }

    private void pushPlayerBack(Player player, Location from, Location to) {
        Vector direction = from.toVector().subtract(to.toVector()).normalize();
        direction.multiply(this.pushBackForce);
        Location pushLocation = player.getLocation().clone();
        pushLocation.add(direction);
        pushLocation.setY(this.getSafeY(pushLocation));
        pushLocation.setPitch(player.getLocation().getPitch());
        pushLocation.setYaw(player.getLocation().getYaw());
        player.setVelocity(direction);
    }

    private double getSafeY(Location loc) {
        int y;
        Block block = loc.getBlock();
        if (!block.getType().isSolid()) {
            return loc.getY();
        }
        for (y = 1; y <= 2; ++y) {
            Block above = block.getRelative(0, y, 0);
            if (above.getType().isSolid()) continue;
            return loc.getBlockY() + y;
        }
        for (y = 1; y <= 2; ++y) {
            Block below = block.getRelative(0, -y, 0);
            if (below.getType().isSolid() || below.getRelative(0, -1, 0).getType().isSolid()) continue;
            return loc.getBlockY() - y;
        }
        return loc.getY();
    }

    private void updatePlayerBarriers(Player player) {
        if (!this.combatManager.isInCombat(player)) {
            this.removePlayerBarriers(player);
            return;
        }
        Set<Location> newBarriers = this.findNearbyBarrierLocations(player.getLocation());
        Set currentBarriers = this.playerBarriers.getOrDefault(player.getUniqueId(), new HashSet());
        HashSet toRemove = new HashSet(currentBarriers);
        toRemove.removeAll(newBarriers);
        for (Location loc : toRemove) {
            this.removeBarrierBlock(loc, player);
        }
        HashSet<Location> toAdd = new HashSet<Location>(newBarriers);
        toAdd.removeAll(currentBarriers);
        for (Location loc : toAdd) {
            this.createBarrierBlock(loc, player);
        }
        if (newBarriers.isEmpty()) {
            this.playerBarriers.remove(player.getUniqueId());
        } else {
            this.playerBarriers.put(player.getUniqueId(), newBarriers);
        }
    }

    private Set<Location> findNearbyBarrierLocations(Location playerLoc) {
        HashSet<Location> barrierLocations = new HashSet<Location>();
        int radius = this.barrierDetectionRadius;
        double radiusSquared = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if ((double)(x * x + z * z) > radiusSquared) continue;
                for (int y = -2; y <= this.barrierHeight; ++y) {
                    Location checkLoc = playerLoc.clone().add((double)x, (double)y, (double)z);
                    if (!this.isBorderLocation(checkLoc)) continue;
                    barrierLocations.add(this.normalizeToBlockLocation(checkLoc));
                }
            }
        }
        return barrierLocations;
    }

    private boolean isBorderLocation(Location loc) {
        int[][] directions;
        SafeZoneInfo info = this.getSafeZoneInfo(loc);
        if (!info.isSafeZone) {
            return false;
        }
        for (int[] dir : directions = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}}) {
            Location adjacent = loc.clone().add((double)dir[0], (double)dir[1], (double)dir[2]);
            if (this.getSafeZoneInfo((Location)adjacent).isSafeZone) continue;
            return true;
        }
        return false;
    }

    private void createBarrierBlock(Location loc, Player player) {
        Location normalizedLoc = this.normalizeToBlockLocation(loc);
        Block block = normalizedLoc.getBlock();
        if (block.getType() != Material.AIR && block.getType().isSolid()) {
            return;
        }
        this.originalBlocks.put(normalizedLoc, block.getType());
        this.barrierViewers.computeIfAbsent(normalizedLoc, k -> new HashSet()).add(player.getUniqueId());
        player.sendBlockChange(normalizedLoc, this.barrierMaterial.createBlockData());
    }

    private void removeBarrierBlock(Location loc, Player player) {
        Location normalizedLoc = this.normalizeToBlockLocation(loc);
        Set<UUID> viewers = this.barrierViewers.get(normalizedLoc);
        if (viewers != null) {
            viewers.remove(player.getUniqueId());
            if (viewers.isEmpty()) {
                this.barrierViewers.remove(normalizedLoc);
                Material originalType = this.originalBlocks.remove(normalizedLoc);
                if (originalType != null) {
                    player.sendBlockChange(normalizedLoc, originalType.createBlockData());
                }
            } else {
                Material originalType = this.originalBlocks.get(normalizedLoc);
                if (originalType != null) {
                    player.sendBlockChange(normalizedLoc, originalType.createBlockData());
                }
            }
        }
    }

    private void removePlayerBarriers(Player player) {
        Set<Location> barriers = this.playerBarriers.remove(player.getUniqueId());
        if (barriers != null) {
            for (Location loc : barriers) {
                this.removeBarrierBlock(loc, player);
            }
        }
    }

    private void startCleanupTask() {
        Scheduler.runTaskTimerAsync(() -> {
            long currentTime = System.currentTimeMillis();
            this.cleanupPlayerBarriers();
            this.cleanupExpiredPearlLocations();
            this.cleanupMessageCooldowns(currentTime);
            this.cleanupCaches(currentTime);
        }, 100L, 100L);
    }

    private void cleanupPlayerBarriers() {
        this.playerBarriers.entrySet().removeIf(entry -> {
            UUID playerUUID = (UUID)entry.getKey();
            Player player = this.plugin.getServer().getPlayer(playerUUID);
            if (!(player != null && player.isOnline() && this.combatManager.isInCombat(player) && this.isEnabledInWorld(player.getWorld()))) {
                Set barriers = (Set)entry.getValue();
                if (player != null && player.isOnline()) {
                    for (Location loc : barriers) {
                        this.removeBarrierBlock(loc, player);
                    }
                } else {
                    for (Location loc : barriers) {
                        this.cleanupOfflinePlayerBarrier(loc, playerUUID);
                    }
                }
                return true;
            }
            return false;
        });
    }

    private void cleanupOfflinePlayerBarrier(Location loc, UUID playerUUID) {
        Location normalizedLoc = this.normalizeToBlockLocation(loc);
        Set<UUID> viewers = this.barrierViewers.get(normalizedLoc);
        if (viewers != null) {
            viewers.remove(playerUUID);
            if (viewers.isEmpty()) {
                this.barrierViewers.remove(normalizedLoc);
                this.originalBlocks.remove(normalizedLoc);
            }
        }
    }

    private void cleanupExpiredPearlLocations() {
        this.pearlThrowLocations.entrySet().removeIf(entry -> ((PearlLocationData)entry.getValue()).isExpired());
    }

    private void cleanupMessageCooldowns(long currentTime) {
        this.lastMessageTime.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 20000L);
    }

    private void cleanupCaches(long currentTime) {
        if (currentTime - this.lastCacheClean > 30000L) {
            this.safeZoneCache.entrySet().removeIf(entry -> ((SafeZoneInfo)entry.getValue()).isExpired());
            this.regionCheckCache.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 10000L);
            if (this.safeZoneCache.size() > 2000) {
                this.safeZoneCache.clear();
            }
            if (this.regionCheckCache.size() > 2000) {
                this.regionCheckCache.clear();
            }
            this.lastCacheClean = currentTime;
        }
    }

    private SafeZoneInfo getSafeZoneInfo(Location location) {
        if (location == null) {
            return new SafeZoneInfo(false, false);
        }
        String cacheKey = location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ();
        SafeZoneInfo cached = this.safeZoneCache.get(cacheKey);
        if (cached != null && !cached.isExpired()) {
            return cached;
        }
        try {
            String worldName = location.getWorld().getName();
            RegionManager regionManager = this.regionManagerCache.get(worldName);
            if (regionManager == null && (regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)location.getWorld()))) != null) {
                this.regionManagerCache.put(worldName, regionManager);
            }
            boolean hasRegions = false;
            boolean isSafeZone = false;
            if (regionManager != null) {
                BlockVector3 pos = BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ());
                ApplicableRegionSet regions = regionManager.getApplicableRegions(pos);
                boolean bl = hasRegions = !regions.getRegions().isEmpty();
                if (hasRegions) {
                    com.sk89q.worldedit.util.Location worldGuardLoc = BukkitAdapter.adapt((Location)location);
                    boolean pvpAllowed = this.regionQuery.testState(worldGuardLoc, null, new StateFlag[]{Flags.PVP});
                    isSafeZone = !pvpAllowed;
                }
            }
            SafeZoneInfo info = new SafeZoneInfo(isSafeZone, hasRegions);
            this.safeZoneCache.put(cacheKey, info);
            return info;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error checking WorldGuard: " + e.getMessage());
            return new SafeZoneInfo(false, false);
        }
    }

    private boolean isSafeZone(Location location) {
        return this.getSafeZoneInfo((Location)location).isSafeZone;
    }

    private Location findSafeLocation(Location location) {
        if (location == null) {
            return null;
        }
        int searchRadius = 10;
        if (this.isLocationSafe(location)) {
            return location;
        }
        for (int y = 1; y <= searchRadius; ++y) {
            Location above = location.clone().add(0.0, (double)y, 0.0);
            if (this.isLocationSafe(above)) {
                return above;
            }
            Location below = location.clone().add(0.0, (double)(-y), 0.0);
            if (!this.isLocationSafe(below)) continue;
            return below;
        }
        for (int distance = 1; distance <= searchRadius; ++distance) {
            for (int x = -distance; x <= distance; ++x) {
                for (int z = -distance; z <= distance; ++z) {
                    if (Math.abs(x) < distance && Math.abs(z) < distance) continue;
                    for (int y = -distance; y <= distance; ++y) {
                        Location checkLoc = location.clone().add((double)x, (double)y, (double)z);
                        if (!this.isLocationSafe(checkLoc)) continue;
                        return checkLoc;
                    }
                }
            }
        }
        return null;
    }

    private boolean isLocationSafe(Location location) {
        if (location == null) {
            return false;
        }
        if (this.isSafeZone(location)) {
            return false;
        }
        Block feet = location.getBlock();
        Block head = location.clone().add(0.0, 1.0, 0.0).getBlock();
        Block ground = location.clone().add(0.0, -1.0, 0.0).getBlock();
        return !(feet.getType() != Material.AIR && feet.getType().isSolid() || head.getType() != Material.AIR && head.getType().isSolid() || !ground.getType().isSolid());
    }

    private void sendCooldownMessage(Player player, String messageKey) {
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastMessageTime.get(playerUUID);
        if (lastTime != null && currentTime - lastTime < 2000L) {
            return;
        }
        this.lastMessageTime.put(playerUUID, currentTime);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("time", String.valueOf(this.combatManager.getRemainingCombatTime(player)));
        this.plugin.getMessageService().sendMessage(player, messageKey, placeholders);
    }

    private Material loadBarrierMaterial() {
        String materialName = this.plugin.getConfig().getString("safezone_protection.barrier_material", "RED_STAINED_GLASS");
        try {
            Material material = Material.valueOf((String)materialName.toUpperCase());
            if (!material.isBlock()) {
                this.plugin.getLogger().warning("Barrier material '" + materialName + "' is not a valid block material. Using RED_STAINED_GLASS instead.");
                return Material.RED_STAINED_GLASS;
            }
            this.plugin.debug("Using barrier material: " + material.name() + " for safezone protection.");
            return material;
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid barrier material '" + materialName + "' in config. Using RED_STAINED_GLASS instead.");
            this.plugin.getLogger().warning("Valid materials can be found at: https://jd.papermc.io/paper/1.21.5/org/bukkit/Material.html");
            return Material.RED_STAINED_GLASS;
        }
    }

    public void cleanup() {
        this.combatPlayerPearls.clear();
        this.pearlThrowLocations.clear();
        this.playerBarriers.clear();
        this.originalBlocks.clear();
        this.barrierViewers.clear();
        this.lastMessageTime.clear();
        this.safeZoneCache.clear();
        this.regionCheckCache.clear();
        this.regionManagerCache.clear();
        this.lastBarrierUpdate.clear();
        this.worldSettings.clear();
    }

    private static class PearlLocationData {
        final Location location;
        final long timestamp;

        PearlLocationData(Location location) {
            this.location = location.clone();
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 60000L;
        }
    }

    private static class SafeZoneInfo {
        final boolean isSafeZone;
        final boolean hasRegions;
        final long timestamp;

        SafeZoneInfo(boolean isSafeZone, boolean hasRegions) {
            this.isSafeZone = isSafeZone;
            this.hasRegions = hasRegions;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 10000L;
        }
    }
}

