/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.listeners;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.combat.CombatManager;
import com.shyamstudio.celestCombatPro.combat.DeathAnimationManager;
import com.shyamstudio.celestCombatPro.language.MessageService;
import com.shyamstudio.celestCombatPro.protection.NewbieProtectionManager;
import com.shyamstudio.celestCombatPro.rewards.KillRewardManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;

public class CombatListeners
implements Listener {
    private final CelestCombatPro plugin;
    private CombatManager combatManager;
    private NewbieProtectionManager newbieProtectionManager;
    private KillRewardManager killRewardManager;
    private DeathAnimationManager deathAnimationManager;
    private MessageService messageService;
    private final Map<UUID, Boolean> playerLoggedOutInCombat = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, UUID> lastDamageSource = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, Long> lastDamageTime = new ConcurrentHashMap<UUID, Long>();
    private static final long DAMAGE_RECORD_CLEANUP_THRESHOLD = TimeUnit.MINUTES.toMillis(5L);

    public CombatListeners(CelestCombatPro plugin) {
        this.plugin = plugin;
        this.combatManager = plugin.getCombatManager();
        this.newbieProtectionManager = plugin.getNewbieProtectionManager();
        this.killRewardManager = plugin.getKillRewardManager();
        this.deathAnimationManager = plugin.getDeathAnimationManager();
        this.messageService = plugin.getMessageService();
    }

    public void reload() {
        this.combatManager = this.plugin.getCombatManager();
        this.newbieProtectionManager = this.plugin.getNewbieProtectionManager();
        this.killRewardManager = this.plugin.getKillRewardManager();
        this.deathAnimationManager = this.plugin.getDeathAnimationManager();
        this.messageService = this.plugin.getMessageService();
        this.plugin.debug("CombatListeners managers reloaded successfully");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Projectile projectile;
        Player attacker = null;
        Player victim = null;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        victim = (Player)event.getEntity();
        Entity damager = event.getDamager();
        if (damager instanceof Player) {
            attacker = (Player)damager;
        } else if (damager instanceof Projectile && (projectile = (Projectile)damager).getShooter() instanceof Player) {
            attacker = (Player)projectile.getShooter();
        }
        if (attacker != null && this.newbieProtectionManager.shouldProtectFromPvP() && this.newbieProtectionManager.hasProtection(victim)) {
            boolean shouldBlock = this.newbieProtectionManager.handleDamageReceived(victim, attacker);
            if (shouldBlock) {
                event.setCancelled(true);
                this.plugin.debug("Blocked PvP damage to protected newbie: " + victim.getName());
                return;
            }
        } else if (attacker == null && this.newbieProtectionManager.shouldProtectFromMobs() && this.newbieProtectionManager.hasProtection(victim)) {
            event.setCancelled(true);
            this.plugin.debug("Blocked mob damage to protected newbie: " + victim.getName());
            return;
        }
        if (attacker != null && this.newbieProtectionManager.hasProtection(attacker)) {
            this.newbieProtectionManager.handleDamageDealt(attacker);
        }
        if (attacker != null && victim != null && !attacker.equals((Object)victim)) {
            this.lastDamageSource.put(victim.getUniqueId(), attacker.getUniqueId());
            this.lastDamageTime.put(victim.getUniqueId(), System.currentTimeMillis());
            this.combatManager.tagPlayer(attacker, victim);
            this.combatManager.tagPlayer(victim, attacker);
            this.cleanupStaleDamageRecords();
        }
    }

    private void cleanupStaleDamageRecords() {
        long currentTime = System.currentTimeMillis();
        this.lastDamageTime.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > DAMAGE_RECORD_CLEANUP_THRESHOLD);
        this.lastDamageSource.keySet().removeIf(uuid -> !this.lastDamageTime.containsKey(uuid));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.newbieProtectionManager.handlePlayerQuit(player);
        if (this.combatManager.isInCombat(player)) {
            this.playerLoggedOutInCombat.put(player.getUniqueId(), true);
            this.combatManager.punishCombatLogout(player);
        } else {
            this.playerLoggedOutInCombat.put(player.getUniqueId(), false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerKick(PlayerKickEvent event) {
        Player player = event.getPlayer();
        this.newbieProtectionManager.handlePlayerQuit(player);
        if (this.combatManager.isInCombat(player)) {
            if (this.plugin.getConfig().getBoolean("combat.exempt_admin_kick", true)) {
                Player opponent = this.combatManager.getCombatOpponent(player);
                this.combatManager.removeFromCombatSilently(player);
                if (opponent != null) {
                    this.combatManager.removeFromCombat(opponent);
                }
            } else {
                Player opponent = this.combatManager.getCombatOpponent(player);
                this.playerLoggedOutInCombat.put(player.getUniqueId(), true);
                this.combatManager.punishCombatLogout(player);
                if (opponent != null && opponent.isOnline()) {
                    this.killRewardManager.giveKillReward(opponent, player);
                    this.deathAnimationManager.performDeathAnimation(player, opponent);
                } else {
                    this.deathAnimationManager.performDeathAnimation(player, null);
                }
                this.combatManager.removeFromCombatSilently(player);
                if (opponent != null) {
                    this.combatManager.removeFromCombat(opponent);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        UUID victimId = victim.getUniqueId();
        if (this.newbieProtectionManager.hasProtection(victim)) {
            this.newbieProtectionManager.removeProtection(victim, false);
            this.plugin.debug("Removed newbie protection from " + victim.getName() + " due to death");
        }
        if (killer != null && !killer.equals((Object)victim)) {
            this.killRewardManager.giveKillReward(killer, victim);
            this.deathAnimationManager.performDeathAnimation(victim, killer);
            this.combatManager.removeFromCombat(victim);
            this.combatManager.removeFromCombat(killer);
        } else if (this.combatManager.isInCombat(victim)) {
            Player opponent = this.combatManager.getCombatOpponent(victim);
            if (opponent != null && opponent.isOnline()) {
                this.killRewardManager.giveKillReward(opponent, victim);
                this.deathAnimationManager.performDeathAnimation(victim, opponent);
            } else if (this.lastDamageSource.containsKey(victimId)) {
                UUID lastAttackerUuid = this.lastDamageSource.get(victimId);
                Player lastAttacker = this.plugin.getServer().getPlayer(lastAttackerUuid);
                if (lastAttacker != null && lastAttacker.isOnline() && !lastAttacker.equals((Object)victim)) {
                    this.killRewardManager.giveKillReward(lastAttacker, victim);
                    this.deathAnimationManager.performDeathAnimation(victim, lastAttacker);
                } else {
                    this.deathAnimationManager.performDeathAnimation(victim, null);
                }
            } else {
                this.deathAnimationManager.performDeathAnimation(victim, null);
            }
            this.combatManager.removeFromCombat(victim);
            if (opponent != null) {
                this.combatManager.removeFromCombat(opponent);
            }
            this.lastDamageSource.remove(victimId);
            this.lastDamageTime.remove(victimId);
        } else {
            this.deathAnimationManager.performDeathAnimation(victim, null);
            this.lastDamageSource.remove(victimId);
            this.lastDamageTime.remove(victimId);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.newbieProtectionManager.handlePlayerJoin(player);
        if (this.playerLoggedOutInCombat.containsKey(playerUUID)) {
            if (this.playerLoggedOutInCombat.get(playerUUID).booleanValue()) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", player.getName());
                this.messageService.sendMessage(player, "player_died_combat_logout", placeholders);
            }
            this.playerLoggedOutInCombat.remove(playerUUID);
        }
        this.lastDamageSource.remove(playerUUID);
        this.lastDamageTime.remove(playerUUID);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (this.combatManager.isInCombat(player)) {
            String command = event.getMessage().split(" ")[0].toLowerCase().substring(1);
            String blockMode = this.plugin.getConfig().getString("combat.command_block_mode", "whitelist").toLowerCase();
            boolean shouldBlock = false;
            if ("blacklist".equalsIgnoreCase(blockMode)) {
                List blockedCommands = this.plugin.getConfig().getStringList("combat.blocked_commands");
                for (String blockedCmd : blockedCommands) {
                    if (!command.equalsIgnoreCase(blockedCmd) && (!blockedCmd.endsWith("*") || !command.startsWith(blockedCmd.substring(0, blockedCmd.length() - 1)))) continue;
                    shouldBlock = true;
                    break;
                }
            } else {
                List allowedCommands = this.plugin.getConfig().getStringList("combat.allowed_commands");
                shouldBlock = true;
                for (String allowedCmd : allowedCommands) {
                    if (!command.equalsIgnoreCase(allowedCmd) && (!allowedCmd.endsWith("*") || !command.startsWith(allowedCmd.substring(0, allowedCmd.length() - 1)))) continue;
                    shouldBlock = false;
                    break;
                }
            }
            if (shouldBlock) {
                event.setCancelled(true);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", player.getName());
                placeholders.put("command", command);
                placeholders.put("time", String.valueOf(this.combatManager.getRemainingCombatTime(player)));
                this.messageService.sendMessage(player, "command_blocked_in_combat", placeholders);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (event.isFlying() && this.combatManager.shouldDisableFlight(player)) {
            event.setCancelled(true);
        }
    }

    public void shutdown() {
        this.playerLoggedOutInCombat.clear();
        this.lastDamageSource.clear();
        this.lastDamageTime.clear();
    }
}

