/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.listeners;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.Scheduler;
import com.shyamstudio.celestCombatPro.combat.CombatManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class EnderPearlListener
implements Listener {
    private final CelestCombatPro plugin;
    private final CombatManager combatManager;
    private final Map<UUID, Scheduler.Task> pearlCountdownTasks = new ConcurrentHashMap<UUID, Scheduler.Task>();
    private final Map<Integer, UUID> activePearls = new ConcurrentHashMap<Integer, UUID>();

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEnderPearlUse(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        Action action = event.getAction();
        if (item != null && item.getType() == Material.ENDER_PEARL && (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && this.combatManager.isEnderPearlOnCooldown(player)) {
            event.setCancelled(true);
            int remainingTime = this.combatManager.getRemainingEnderPearlCooldown(player);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            placeholders.put("time", String.valueOf(remainingTime));
            this.plugin.getMessageService().sendMessage(player, "enderpearl_cooldown", placeholders);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntity() instanceof EnderPearl && event.getEntity().getShooter() instanceof Player) {
            Player player = (Player)event.getEntity().getShooter();
            if (this.combatManager.isEnderPearlOnCooldown(player)) {
                event.setCancelled(true);
                int remainingTime = this.combatManager.getRemainingEnderPearlCooldown(player);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", player.getName());
                placeholders.put("time", String.valueOf(remainingTime));
                this.plugin.getMessageService().sendMessage(player, "enderpearl_cooldown", placeholders);
            } else {
                this.combatManager.setEnderPearlCooldown(player);
                this.startPearlCountdown(player);
                this.activePearls.put(event.getEntity().getEntityId(), player.getUniqueId());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent event) {
        int pearlId;
        if (event.getEntity() instanceof EnderPearl && this.activePearls.containsKey(pearlId = event.getEntity().getEntityId())) {
            UUID playerUUID = this.activePearls.remove(pearlId);
            Player player = this.plugin.getServer().getPlayer(playerUUID);
            if (player != null && player.isOnline()) {
                this.combatManager.refreshCombatOnPearlLand(player);
            }
        }
    }

    private void startPearlCountdown(Player player) {
        if (player == null) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        Scheduler.Task existingTask = this.pearlCountdownTasks.get(playerUUID);
        if (existingTask != null) {
            existingTask.cancel();
        }
        long updateInterval = 20L;
        Scheduler.Task task = Scheduler.runTaskTimer(() -> {
            if (!player.isOnline()) {
                this.cancelPearlCountdown(playerUUID);
                return;
            }
            if (!this.combatManager.isEnderPearlOnCooldown(player)) {
                this.cancelPearlCountdown(playerUUID);
                return;
            }
            int remainingTime = this.combatManager.getRemainingEnderPearlCooldown(player);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            placeholders.put("time", String.valueOf(remainingTime));
            if (!this.combatManager.isInCombat(player)) {
                this.plugin.getMessageService().sendMessage(player, "pearl_only_countdown", placeholders);
            }
        }, 0L, updateInterval);
        this.pearlCountdownTasks.put(playerUUID, task);
    }

    private void cancelPearlCountdown(UUID playerUUID) {
        Scheduler.Task task = this.pearlCountdownTasks.remove(playerUUID);
        if (task != null) {
            task.cancel();
        }
    }

    public void shutdown() {
        this.pearlCountdownTasks.values().forEach(Scheduler.Task::cancel);
        this.pearlCountdownTasks.clear();
        this.activePearls.clear();
    }

    @Generated
    public EnderPearlListener(CelestCombatPro plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
    }
}

