/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.listeners;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.combat.CombatManager;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;

public class ItemRestrictionListener
implements Listener {
    private final CelestCombatPro plugin;
    private final CombatManager combatManager;

    public static String formatItemName(Material material) {
        if (material == null) {
            return "Unknown Item";
        }
        String[] words = material.name().split("_");
        StringBuilder formattedName = new StringBuilder();
        for (String word : words) {
            formattedName.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        return formattedName.toString().trim();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (!this.plugin.getConfig().getBoolean("combat.item_restrictions.enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (this.combatManager.isInCombat(player)) {
            List disabledItems = this.plugin.getConfig().getStringList("combat.item_restrictions.disabled_items");
            if (this.isItemDisabled(item.getType(), disabledItems)) {
                event.setCancelled(true);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", player.getName());
                placeholders.put("item", ItemRestrictionListener.formatItemName(item.getType()));
                this.plugin.getMessageService().sendMessage(player, "item_use_blocked_in_combat", placeholders);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMoveEvent(PlayerMoveEvent event) {
        List disabledItems;
        if (!this.plugin.getConfig().getBoolean("combat.item_restrictions.enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.combatManager.isInCombat(player) && (disabledItems = this.plugin.getConfig().getStringList("combat.item_restrictions.disabled_items")).contains("ELYTRA") && player.isGliding()) {
            player.setGliding(false);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            placeholders.put("item", "Elytra");
            this.plugin.getMessageService().sendMessage(player, "item_use_blocked_in_combat", placeholders);
        }
    }

    private boolean isItemDisabled(Material itemType, List<String> disabledItems) {
        return disabledItems.stream().anyMatch(disabledItem -> itemType.name().equalsIgnoreCase((String)disabledItem) || itemType.name().contains((CharSequence)disabledItem));
    }

    @Generated
    public ItemRestrictionListener(CelestCombatPro plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
    }
}

