/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.listeners;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.Scheduler;
import com.shyamstudio.celestCombatPro.combat.CombatManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.inventory.ItemStack;

public class TridentListener
implements Listener {
    private final CelestCombatPro plugin;
    private final CombatManager combatManager;
    private final Map<UUID, Scheduler.Task> tridentCountdownTasks = new ConcurrentHashMap<UUID, Scheduler.Task>();
    private final Map<Integer, UUID> activeTridents = new ConcurrentHashMap<Integer, UUID>();
    private final Map<UUID, Location> riptideOriginalLocations = new ConcurrentHashMap<UUID, Location>();

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTridentUse(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        Action action = event.getAction();
        if (item != null && item.getType() == Material.TRIDENT && (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK)) {
            if (this.combatManager.isTridentBanned(player)) {
                event.setCancelled(true);
                this.sendBannedMessage(player);
                return;
            }
            if (item.containsEnchantment(Enchantment.RIPTIDE)) {
                if (this.combatManager.isTridentOnCooldown(player)) {
                    event.setCancelled(true);
                    this.sendCooldownMessage(player);
                    return;
                }
                this.riptideOriginalLocations.put(player.getUniqueId(), player.getLocation().clone());
            } else if (this.combatManager.isTridentOnCooldown(player)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onRiptideUse(PlayerRiptideEvent event) {
        Player player = event.getPlayer();
        if (this.combatManager.isTridentBanned(player)) {
            this.sendBannedMessage(player);
            this.rollbackRiptide(player);
            return;
        }
        if (this.combatManager.isTridentOnCooldown(player)) {
            this.sendCooldownMessage(player);
            this.rollbackRiptide(player);
            return;
        }
        this.combatManager.setTridentCooldown(player);
        this.startTridentCountdown(player);
        this.combatManager.refreshCombatOnTridentLand(player);
        this.riptideOriginalLocations.remove(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntity() instanceof Trident && event.getEntity().getShooter() instanceof Player) {
            Player player = (Player)event.getEntity().getShooter();
            if (this.combatManager.isTridentBanned(player)) {
                event.setCancelled(true);
                this.sendBannedMessage(player);
                return;
            }
            if (this.combatManager.isTridentOnCooldown(player)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player);
            } else {
                this.combatManager.setTridentCooldown(player);
                this.startTridentCountdown(player);
                this.activeTridents.put(event.getEntity().getEntityId(), player.getUniqueId());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent event) {
        int tridentId;
        if (event.getEntity() instanceof Trident && this.activeTridents.containsKey(tridentId = event.getEntity().getEntityId())) {
            UUID playerUUID = this.activeTridents.remove(tridentId);
            Player player = this.plugin.getServer().getPlayer(playerUUID);
            if (player != null && player.isOnline()) {
                this.combatManager.refreshCombatOnTridentLand(player);
            }
        }
    }

    private void rollbackRiptide(Player player) {
        Location originalLocation = this.riptideOriginalLocations.remove(player.getUniqueId());
        if (originalLocation != null) {
            Scheduler.runTaskLater(() -> {
                if (player.isOnline()) {
                    player.setVelocity(player.getVelocity().multiply(0));
                    if (player.getLocation().distance(originalLocation) > 5.0) {
                        player.teleport(originalLocation);
                    }
                }
            }, 2L);
        } else {
            Scheduler.runTask(() -> player.setVelocity(player.getVelocity().multiply(0)));
        }
    }

    private void startTridentCountdown(Player player) {
        if (player == null) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        Scheduler.Task existingTask = this.tridentCountdownTasks.get(playerUUID);
        if (existingTask != null) {
            existingTask.cancel();
        }
        long updateInterval = 20L;
        Scheduler.Task task = Scheduler.runTaskTimer(() -> {
            if (!player.isOnline()) {
                this.cancelTridentCountdown(playerUUID);
                return;
            }
            if (!this.combatManager.isTridentOnCooldown(player)) {
                this.cancelTridentCountdown(playerUUID);
                return;
            }
            int remainingTime = this.combatManager.getRemainingTridentCooldown(player);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            placeholders.put("time", String.valueOf(remainingTime));
            if (!this.combatManager.isInCombat(player)) {
                this.plugin.getMessageService().sendMessage(player, "trident_only_countdown", placeholders);
            }
        }, 0L, updateInterval);
        this.tridentCountdownTasks.put(playerUUID, task);
    }

    private void cancelTridentCountdown(UUID playerUUID) {
        Scheduler.Task task = this.tridentCountdownTasks.remove(playerUUID);
        if (task != null) {
            task.cancel();
        }
    }

    private void sendBannedMessage(Player player) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        this.plugin.getMessageService().sendMessage(player, "trident_banned", placeholders);
    }

    private void sendCooldownMessage(Player player) {
        int remainingTime = this.combatManager.getRemainingTridentCooldown(player);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("time", String.valueOf(remainingTime));
        this.plugin.getMessageService().sendMessage(player, "trident_cooldown", placeholders);
    }

    public void shutdown() {
        this.tridentCountdownTasks.values().forEach(Scheduler.Task::cancel);
        this.tridentCountdownTasks.clear();
        this.activeTridents.clear();
        this.riptideOriginalLocations.clear();
    }

    @Generated
    public TridentListener(CelestCombatPro plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
    }
}

