/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.protection;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.Scheduler;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class NewbieProtectionManager {
    private final CelestCombatPro plugin;
    private final File protectionFile;
    private FileConfiguration protectionConfig;
    private final Map<UUID, Long> protectedPlayers = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, BossBar> protectionBossBars = new ConcurrentHashMap<UUID, BossBar>();
    private boolean enabled;
    private long protectionDurationTicks;
    private long protectionDurationSeconds;
    private boolean useBossBar;
    private boolean useActionBar;
    private String bossBarTitle;
    private BarColor bossBarColor;
    private BarStyle bossBarStyle;
    private Map<String, Boolean> worldProtectionSettings = new ConcurrentHashMap<String, Boolean>();
    private boolean protectFromPvP;
    private boolean protectFromMobs;
    private boolean removeOnDamageDealt;
    private Scheduler.Task updateTask;
    private Scheduler.Task cleanupTask;
    private Scheduler.Task saveTask;
    private static final long UPDATE_INTERVAL = 20L;
    private static final long CLEANUP_INTERVAL = 12000L;
    private static final long SAVE_INTERVAL = 6000L;

    public NewbieProtectionManager(CelestCombatPro plugin) {
        this.plugin = plugin;
        this.protectionFile = new File(plugin.getDataFolder(), "newbie_protection_data.yml");
        this.loadConfig();
        this.loadProtectionData();
        this.startUpdateTask();
        this.startCleanupTask();
        this.startAutoSaveTask();
    }

    public void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.enabled = config.getBoolean("newbie_protection.enabled", true);
        this.protectionDurationTicks = this.plugin.getTimeFromConfig("newbie_protection.duration", "10m");
        this.protectionDurationSeconds = this.protectionDurationTicks / 20L;
        this.useBossBar = config.getBoolean("newbie_protection.display.use_bossbar", true);
        this.useActionBar = config.getBoolean("newbie_protection.display.use_actionbar", false);
        this.bossBarTitle = config.getString("newbie_protection.display.bossbar.title", "&#4CAF50PvP Protection: &#FFFFFF%time%");
        String colorStr = config.getString("newbie_protection.display.bossbar.color", "GREEN");
        try {
            this.bossBarColor = BarColor.valueOf((String)colorStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.bossBarColor = BarColor.YELLOW;
            this.plugin.getLogger().warning("Invalid boss bar color: " + colorStr + ", using GREEN");
        }
        String styleStr = config.getString("newbie_protection.display.bossbar.style", "SOLID");
        try {
            this.bossBarStyle = BarStyle.valueOf((String)styleStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.bossBarStyle = BarStyle.SOLID;
            this.plugin.getLogger().warning("Invalid boss bar style: " + styleStr + ", using SOLID");
        }
        this.protectFromPvP = config.getBoolean("newbie_protection.protect_from_pvp", true);
        this.protectFromMobs = config.getBoolean("newbie_protection.protect_from_mobs", false);
        this.removeOnDamageDealt = config.getBoolean("newbie_protection.remove_on_damage_dealt", true);
        this.loadWorldProtectionSettings();
        this.plugin.debug("NewbieProtectionManager config loaded - Enabled: " + this.enabled + ", Duration: " + this.protectionDurationSeconds + "s, Boss bar: " + this.useBossBar + ", Action bar: " + this.useActionBar);
    }

    private void loadWorldProtectionSettings() {
        this.worldProtectionSettings.clear();
        if (this.plugin.getConfig().isConfigurationSection("newbie_protection.worlds")) {
            for (String worldName : Objects.requireNonNull(this.plugin.getConfig().getConfigurationSection("newbie_protection.worlds")).getKeys(false)) {
                boolean enabledInWorld = this.plugin.getConfig().getBoolean("newbie_protection.worlds." + worldName, true);
                this.worldProtectionSettings.put(worldName, enabledInWorld);
            }
        }
        this.plugin.debug("Loaded world-specific newbie protection settings: " + String.valueOf(this.worldProtectionSettings));
    }

    private void loadProtectionData() {
        if (!this.protectionFile.exists()) {
            try {
                this.protectionFile.getParentFile().mkdirs();
                this.protectionFile.createNewFile();
                this.plugin.debug("Created new newbie_protection_data.yml file");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create newbie_protection_data.yml: " + e.getMessage());
                return;
            }
        }
        this.protectionConfig = YamlConfiguration.loadConfiguration((File)this.protectionFile);
        int loadedCount = 0;
        long currentTime = System.currentTimeMillis();
        for (String uuidStr : this.protectionConfig.getKeys(false)) {
            try {
                UUID playerUUID = UUID.fromString(uuidStr);
                long expirationTime = this.protectionConfig.getLong(uuidStr);
                if (expirationTime <= currentTime) continue;
                this.protectedPlayers.put(playerUUID, expirationTime);
                ++loadedCount;
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID in protection data: " + uuidStr);
            }
        }
        this.plugin.getLogger().info("Loaded " + loadedCount + " active newbie protections");
    }

    public void saveProtectionData() {
        this.saveProtectionData(false);
    }

    public void saveProtectionData(boolean synchronous) {
        if (this.protectionConfig == null) {
            this.protectionConfig = new YamlConfiguration();
        }
        for (String key : this.protectionConfig.getKeys(false)) {
            this.protectionConfig.set(key, null);
        }
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<UUID, Long> entry : this.protectedPlayers.entrySet()) {
            if (entry.getValue() <= currentTime) continue;
            this.protectionConfig.set(entry.getKey().toString(), (Object)entry.getValue());
        }
        if (synchronous || !this.plugin.isEnabled()) {
            try {
                this.protectionConfig.save(this.protectionFile);
                this.plugin.debug("Saved newbie protection data to file (synchronous)");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save newbie_protection_data.yml: " + e.getMessage());
            }
        } else {
            Scheduler.runTaskAsync(() -> {
                try {
                    this.protectionConfig.save(this.protectionFile);
                    this.plugin.debug("Saved newbie protection data to file");
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("Failed to save newbie_protection_data.yml: " + e.getMessage());
                }
            });
        }
    }

    public boolean isEnabledInWorld(String worldName) {
        if (!this.enabled) {
            return false;
        }
        return this.worldProtectionSettings.getOrDefault(worldName, true);
    }

    public void grantProtection(Player player) {
        if (!this.enabled || player == null) {
            return;
        }
        String worldName = player.getWorld().getName();
        if (!this.isEnabledInWorld(worldName)) {
            this.plugin.debug("Newbie protection not enabled in world: " + worldName);
            return;
        }
        UUID playerUUID = player.getUniqueId();
        long expirationTime = System.currentTimeMillis() + this.protectionDurationSeconds * 1000L;
        this.protectedPlayers.put(playerUUID, expirationTime);
        if (this.useBossBar) {
            this.createBossBar(player);
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("duration", this.formatTime(this.protectionDurationSeconds));
        this.plugin.getMessageService().sendMessage(player, "newbie_protection_granted", placeholders);
        this.plugin.debug("Granted newbie protection to " + player.getName() + " until " + String.valueOf(new Date(expirationTime)));
    }

    public boolean hasProtection(Player player) {
        if (!this.enabled || player == null) {
            return false;
        }
        String worldName = player.getWorld().getName();
        if (!this.isEnabledInWorld(worldName)) {
            return false;
        }
        UUID playerUUID = player.getUniqueId();
        Long expirationTime = this.protectedPlayers.get(playerUUID);
        if (expirationTime == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= expirationTime) {
            this.removeProtection(player, false);
            return false;
        }
        return true;
    }

    public void removeProtection(Player player, boolean sendMessage) {
        boolean hadProtection;
        if (player == null) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        boolean bl = hadProtection = this.protectedPlayers.remove(playerUUID) != null;
        if (hadProtection) {
            BossBar bossBar = this.protectionBossBars.remove(playerUUID);
            if (bossBar != null) {
                bossBar.removeAll();
            }
            this.plugin.debug("Removed newbie protection from " + player.getName());
        }
    }

    public boolean handleDamageReceived(Player player, Player attacker) {
        if (!this.hasProtection(player)) {
            return false;
        }
        if (attacker != null && attacker != player) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            placeholders.put("attacker", attacker.getName());
            this.plugin.getMessageService().sendMessage(attacker, "newbie_protection_attack_blocked", placeholders);
        }
        return true;
    }

    public void handleDamageDealt(Player player) {
        if (this.removeOnDamageDealt && this.hasProtection(player)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            this.plugin.getMessageService().sendMessage(player, "newbie_protection_removed_attack", placeholders);
            this.removeProtection(player, false);
        }
    }

    public long getRemainingTime(Player player) {
        if (!this.hasProtection(player)) {
            return 0L;
        }
        UUID playerUUID = player.getUniqueId();
        Long expirationTime = this.protectedPlayers.get(playerUUID);
        if (expirationTime == null) {
            return 0L;
        }
        long remainingMillis = expirationTime - System.currentTimeMillis();
        return Math.max(0L, remainingMillis / 1000L);
    }

    private void createBossBar(Player player) {
        if (!this.useBossBar || player == null) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        BossBar existingBar = this.protectionBossBars.get(playerUUID);
        if (existingBar != null) {
            existingBar.removeAll();
        }
        String title = this.bossBarTitle.replace("%time%", this.formatTime(this.getRemainingTime(player)));
        title = this.plugin.getLanguageManager().colorize(title);
        BossBar bossBar = Bukkit.createBossBar((String)title, (BarColor)this.bossBarColor, (BarStyle)this.bossBarStyle, (BarFlag[])new BarFlag[0]);
        bossBar.setProgress(1.0);
        bossBar.addPlayer(player);
        this.protectionBossBars.put(playerUUID, bossBar);
    }

    private void updateBossBar(Player player) {
        if (!this.useBossBar || player == null) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        BossBar bossBar = this.protectionBossBars.get(playerUUID);
        if (bossBar == null) {
            return;
        }
        long remainingTime = this.getRemainingTime(player);
        if (remainingTime <= 0L) {
            bossBar.removeAll();
            this.protectionBossBars.remove(playerUUID);
            return;
        }
        String title = this.bossBarTitle.replace("%time%", this.formatTime(remainingTime));
        title = this.plugin.getLanguageManager().colorize(title);
        bossBar.setTitle(title);
        double progress = Math.max(0.0, Math.min(1.0, (double)remainingTime / (double)this.protectionDurationSeconds));
        bossBar.setProgress(progress);
    }

    private void sendActionBar(Player player) {
        if (!this.useActionBar || player == null || !player.isOnline()) {
            return;
        }
        long remainingTime = this.getRemainingTime(player);
        if (remainingTime <= 0L) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("time", this.formatTime(remainingTime));
        this.plugin.getMessageService().sendMessage(player, "newbie_protection_actionbar", placeholders);
    }

    private String formatTime(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (secs > 0L || sb.length() == 0) {
            sb.append(secs).append("s");
        }
        return sb.toString().trim();
    }

    private void startUpdateTask() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        this.updateTask = Scheduler.runTaskTimer(() -> {
            for (UUID playerUUID : new HashSet<UUID>(this.protectedPlayers.keySet())) {
                Player player = Bukkit.getPlayer((UUID)playerUUID);
                if (player == null || !player.isOnline() || !this.hasProtection(player)) continue;
                if (this.useBossBar) {
                    this.updateBossBar(player);
                }
                if (!this.useActionBar) continue;
                this.sendActionBar(player);
            }
        }, 0L, 20L);
    }

    private void startCleanupTask() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
        }
        this.cleanupTask = Scheduler.runTaskTimerAsync(() -> {
            long currentTime = System.currentTimeMillis();
            int removedCount = 0;
            Iterator<Map.Entry<UUID, Long>> iterator = this.protectedPlayers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Long> entry = iterator.next();
                if (currentTime < entry.getValue()) continue;
                UUID playerUUID = entry.getKey();
                iterator.remove();
                Scheduler.runTask(() -> {
                    BossBar bossBar = this.protectionBossBars.remove(playerUUID);
                    if (bossBar != null) {
                        bossBar.removeAll();
                    }
                });
                ++removedCount;
            }
            if (removedCount > 0) {
                this.plugin.debug("Cleaned up " + removedCount + " expired newbie protections");
            }
        }, 12000L, 12000L);
    }

    private void startAutoSaveTask() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        this.saveTask = Scheduler.runTaskTimerAsync(this::saveProtectionData, 6000L, 6000L);
    }

    public void clearPlayerProtection(Player player) {
        if (player == null) {
            return;
        }
        this.removeProtection(player, false);
        this.plugin.debug("Manually cleared newbie protection for " + player.getName());
    }

    public void reloadConfig() {
        this.loadConfig();
        this.plugin.debug("NewbieProtectionManager configuration reloaded");
    }

    public void handlePlayerJoin(Player player) {
        if (!this.enabled || player == null) {
            return;
        }
        if (player.hasPlayedBefore()) {
            this.plugin.debug("Player " + player.getName() + " has played before, not granting newbie protection");
            return;
        }
        this.grantProtection(player);
    }

    public void handlePlayerQuit(Player player) {
        if (player == null) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        BossBar bossBar = this.protectionBossBars.remove(playerUUID);
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    public boolean shouldProtectFromPvP() {
        return this.protectFromPvP;
    }

    public boolean shouldProtectFromMobs() {
        return this.protectFromMobs;
    }

    public void shutdown() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
        }
        if (this.saveTask != null) {
            this.saveTask.cancel();
            this.saveTask = null;
        }
        for (BossBar bossBar : this.protectionBossBars.values()) {
            bossBar.removeAll();
        }
        this.protectionBossBars.clear();
        this.saveProtectionData(true);
        this.protectedPlayers.clear();
    }

    @Generated
    public Map<UUID, Long> getProtectedPlayers() {
        return this.protectedPlayers;
    }
}

