/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.rewards;

import com.shyamstudio.celestCombatPro.CelestCombatPro;
import com.shyamstudio.celestCombatPro.Scheduler;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class KillRewardManager {
    private final CelestCombatPro plugin;
    private final File cooldownFile;
    private FileConfiguration cooldownConfig;
    private final Map<String, Long> killRewardCooldowns = new ConcurrentHashMap<String, Long>();
    private boolean enabled;
    private List<String> rewardCommands;
    private boolean useGlobalCooldown;
    private boolean useSamePlayerCooldown;
    private long globalCooldownDuration;
    private long samePlayerCooldownDuration;
    private Scheduler.Task cleanupTask;
    private Scheduler.Task saveTask;
    private static final long CLEANUP_INTERVAL = 12000L;
    private static final long SAVE_INTERVAL = 6000L;
    private static final String GLOBAL_COOLDOWN_PREFIX = "global:";
    private static final String PLAYER_COOLDOWN_PREFIX = "player:";

    public KillRewardManager(CelestCombatPro plugin) {
        this.plugin = plugin;
        this.cooldownFile = new File(plugin.getDataFolder(), "kill_cooldowns_data.yml");
        this.loadConfig();
        this.loadCooldownData();
        this.startCleanupTask();
        this.startAutoSaveTask();
    }

    public void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.enabled = config.getBoolean("kill_rewards.enabled", true);
        this.rewardCommands = config.getStringList("kill_rewards.commands");
        this.useGlobalCooldown = config.getBoolean("kill_rewards.cooldown.use_global_cooldown", false);
        this.useSamePlayerCooldown = config.getBoolean("kill_rewards.cooldown.use_same_player_cooldown", true);
        this.globalCooldownDuration = this.plugin.getTimeFromConfigInMilliseconds("kill_rewards.cooldown.duration", "1d");
        this.samePlayerCooldownDuration = this.plugin.getTimeFromConfigInMilliseconds("kill_rewards.cooldown.same_player_duration", "1d");
        this.plugin.debug("KillRewardManager config loaded - Enabled: " + this.enabled + ", Global cooldown: " + this.useGlobalCooldown + ", Same player cooldown: " + this.useSamePlayerCooldown);
    }

    private void loadCooldownData() {
        if (!this.cooldownFile.exists()) {
            try {
                this.cooldownFile.getParentFile().mkdirs();
                this.cooldownFile.createNewFile();
                this.plugin.debug("Created new kill_cooldowns_data.yml file");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create kill_cooldowns_data.yml: " + e.getMessage());
                return;
            }
        }
        this.cooldownConfig = YamlConfiguration.loadConfiguration((File)this.cooldownFile);
        int loadedCount = 0;
        long currentTime = System.currentTimeMillis();
        for (String key : this.cooldownConfig.getKeys(false)) {
            long expirationTime = this.cooldownConfig.getLong(key);
            if (expirationTime <= currentTime) continue;
            this.killRewardCooldowns.put(key, expirationTime);
            ++loadedCount;
        }
        this.plugin.getLogger().info("Loaded " + loadedCount + " active kill reward cooldowns");
    }

    public void saveCooldownData() {
        this.saveCooldownData(false);
    }

    public void saveCooldownData(boolean synchronous) {
        if (this.cooldownConfig == null) {
            this.cooldownConfig = new YamlConfiguration();
        }
        for (String key : this.cooldownConfig.getKeys(false)) {
            this.cooldownConfig.set(key, null);
        }
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : this.killRewardCooldowns.entrySet()) {
            if (entry.getValue() <= currentTime) continue;
            this.cooldownConfig.set(entry.getKey(), (Object)entry.getValue());
        }
        if (synchronous || !this.plugin.isEnabled()) {
            try {
                this.cooldownConfig.save(this.cooldownFile);
                this.plugin.debug("Saved kill reward cooldowns to file (synchronous)");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save kill_cooldowns_data.yml: " + e.getMessage());
            }
        } else {
            Scheduler.runTaskAsync(() -> {
                try {
                    this.cooldownConfig.save(this.cooldownFile);
                    this.plugin.debug("Saved kill reward cooldowns to file");
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("Failed to save kill_cooldowns_data.yml: " + e.getMessage());
                }
            });
        }
    }

    public boolean isOnCooldown(Player killer, Player victim) {
        if (!this.enabled || killer == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (this.useGlobalCooldown) {
            String globalKey = GLOBAL_COOLDOWN_PREFIX + String.valueOf(killer.getUniqueId());
            Long cooldownEnd = this.killRewardCooldowns.get(globalKey);
            return cooldownEnd != null && currentTime < cooldownEnd;
        }
        if (this.useSamePlayerCooldown && victim != null) {
            String playerKey = PLAYER_COOLDOWN_PREFIX + String.valueOf(killer.getUniqueId()) + ":" + String.valueOf(victim.getUniqueId());
            Long cooldownEnd = this.killRewardCooldowns.get(playerKey);
            return cooldownEnd != null && currentTime < cooldownEnd;
        }
        return false;
    }

    public void setCooldown(Player killer, Player victim) {
        if (!this.enabled || killer == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.useGlobalCooldown) {
            String globalKey = GLOBAL_COOLDOWN_PREFIX + String.valueOf(killer.getUniqueId());
            long expirationTime = currentTime + this.globalCooldownDuration;
            this.killRewardCooldowns.put(globalKey, expirationTime);
            this.plugin.debug("Set global kill reward cooldown for " + killer.getName() + " until " + String.valueOf(new Date(expirationTime)));
        } else if (this.useSamePlayerCooldown && victim != null) {
            String playerKey = PLAYER_COOLDOWN_PREFIX + String.valueOf(killer.getUniqueId()) + ":" + String.valueOf(victim.getUniqueId());
            long expirationTime = currentTime + this.samePlayerCooldownDuration;
            this.killRewardCooldowns.put(playerKey, expirationTime);
            this.plugin.debug("Set same-player kill reward cooldown for " + killer.getName() + " -> " + victim.getName() + " until " + String.valueOf(new Date(expirationTime)));
        }
    }

    private void executeRewardCommands(Player killer, Player victim) {
        if (this.rewardCommands == null || this.rewardCommands.isEmpty()) {
            return;
        }
        AtomicBoolean anyCommandSuccessful = new AtomicBoolean(false);
        Scheduler.runTask(() -> {
            for (String command : this.rewardCommands) {
                String processedCommand = command.replace("%killer%", killer.getName()).replace("%victim%", victim.getName());
                try {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processedCommand);
                    this.plugin.debug("Executed kill reward command: " + processedCommand);
                    anyCommandSuccessful.set(true);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to execute kill reward command '" + processedCommand + "': " + e.getMessage());
                }
            }
            if (anyCommandSuccessful.get()) {
                this.sendKillRewardMessage(killer, victim);
            }
        });
    }

    private void sendKillRewardMessage(Player killer, Player victim) {
        if (killer == null || !killer.isOnline()) {
            return;
        }
        try {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("killer", killer.getName());
            placeholders.put("victim", victim != null ? victim.getName() : "Unknown");
            this.plugin.getMessageService().sendMessage(killer, "kill_reward_received", placeholders);
            this.plugin.debug("Sent kill reward message to " + killer.getName());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to send kill reward message to " + killer.getName() + ": " + e.getMessage());
        }
    }

    public void giveKillReward(Player killer, Player victim) {
        if (!this.enabled || killer == null || victim == null || killer.equals((Object)victim)) {
            this.plugin.debug("Kill reward skipped - enabled: " + this.enabled + ", killer: " + (killer != null ? killer.getName() : "null") + ", victim: " + (victim != null ? victim.getName() : "null") + ", same player: " + (killer != null && killer.equals((Object)victim)));
            return;
        }
        if (this.isOnCooldown(killer, victim)) {
            this.plugin.debug("Kill reward cooldown active for " + killer.getName() + " -> " + victim.getName());
            return;
        }
        this.plugin.debug("Processing kill reward for " + killer.getName() + " -> " + victim.getName());
        this.setCooldown(killer, victim);
        this.executeRewardCommands(killer, victim);
    }

    public long getRemainingCooldown(Player killer, Player victim) {
        if (!this.enabled || killer == null) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        Long cooldownEnd = null;
        if (this.useGlobalCooldown) {
            String globalKey = GLOBAL_COOLDOWN_PREFIX + String.valueOf(killer.getUniqueId());
            cooldownEnd = this.killRewardCooldowns.get(globalKey);
        } else if (this.useSamePlayerCooldown && victim != null) {
            String playerKey = PLAYER_COOLDOWN_PREFIX + String.valueOf(killer.getUniqueId()) + ":" + String.valueOf(victim.getUniqueId());
            cooldownEnd = this.killRewardCooldowns.get(playerKey);
        }
        if (cooldownEnd == null || currentTime >= cooldownEnd) {
            return 0L;
        }
        return cooldownEnd - currentTime;
    }

    private void startCleanupTask() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
        }
        this.cleanupTask = Scheduler.runTaskTimerAsync(() -> {
            long currentTime = System.currentTimeMillis();
            int removedCount = 0;
            Iterator<Map.Entry<String, Long>> iterator = this.killRewardCooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Long> entry = iterator.next();
                if (currentTime < entry.getValue()) continue;
                iterator.remove();
                ++removedCount;
            }
            if (removedCount > 0) {
                this.plugin.debug("Cleaned up " + removedCount + " expired kill reward cooldowns");
            }
        }, 12000L, 12000L);
    }

    private void startAutoSaveTask() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        this.saveTask = Scheduler.runTaskTimerAsync(this::saveCooldownData, 6000L, 6000L);
    }

    public void clearPlayerCooldowns(Player player) {
        if (player == null) {
            return;
        }
        String playerUUID = player.getUniqueId().toString();
        this.killRewardCooldowns.entrySet().removeIf(entry -> ((String)entry.getKey()).contains(playerUUID));
        this.plugin.debug("Cleared all kill reward cooldowns for " + player.getName());
    }

    public void shutdown() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
        }
        if (this.saveTask != null) {
            this.saveTask.cancel();
            this.saveTask = null;
        }
        this.saveCooldownData(true);
        this.killRewardCooldowns.clear();
    }

    @Generated
    public Map<String, Long> getKillRewardCooldowns() {
        return this.killRewardCooldowns;
    }
}

