/*
 * Decompiled with CFR 0.152.
 */
package com.shyamstudio.celestCombatPro.updates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.shyamstudio.celestCombatPro.Scheduler;
import com.shyamstudio.celestCombatPro.updates.Version;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker
implements Listener {
    private final JavaPlugin plugin;
    private final String projectId = "Kp9Kt4QT";
    private boolean updateAvailable = false;
    private final String currentVersion;
    private String latestVersion = "";
    private String downloadUrl = "";
    private String directLink = "";
    private static final String CONSOLE_RESET = "\u001b[0m";
    private static final String CONSOLE_BRIGHT_GREEN = "\u001b[92m";
    private static final String CONSOLE_YELLOW = "\u001b[33m";
    private static final String CONSOLE_BRIGHT_BLUE = "\u001b[94m";
    private static final String CONSOLE_LAVENDER = "\u001b[38;5;183m";
    private static final String CONSOLE_PINK = "\u001b[38;5;206m";
    private static final String CONSOLE_DEEP_PINK = "\u001b[38;5;198m";
    private final Map<UUID, LocalDate> notifiedPlayers = new HashMap<UUID, LocalDate>();

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        ((CompletableFuture)this.checkForUpdates().thenAccept(hasUpdate -> {
            if (hasUpdate.booleanValue()) {
                this.displayConsoleUpdateMessage();
            }
        })).exceptionally(ex -> {
            plugin.getLogger().warning("Failed to check for updates: " + ex.getMessage());
            return null;
        });
    }

    private void displayConsoleUpdateMessage() {
        String modrinthLink = "https://modrinth.com/plugin/Kp9Kt4QT/version/" + this.latestVersion;
        String frameColor = CONSOLE_BRIGHT_BLUE;
        this.plugin.getLogger().info(frameColor + "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u001b[0m");
        this.plugin.getLogger().info(frameColor + "\u001b[92m         \ud83c\udf1f Celest Combat Update Available \ud83c\udf1f\u001b[0m");
        this.plugin.getLogger().info(frameColor + "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u001b[0m");
        this.plugin.getLogger().info("");
        this.plugin.getLogger().info(frameColor + "\u001b[0m\ud83d\udce6 Current version: \u001b[33m" + this.formatConsoleText(this.currentVersion, 31) + CONSOLE_RESET);
        this.plugin.getLogger().info(frameColor + "\u001b[0m\u2705 Latest version: \u001b[92m" + this.formatConsoleText(this.latestVersion, 32) + CONSOLE_RESET);
        this.plugin.getLogger().info("");
        this.plugin.getLogger().info(frameColor + "\u001b[0m\ud83d\udce5 Download the latest version at:\u001b[0m");
        this.plugin.getLogger().info(frameColor + " \u001b[92m" + this.formatConsoleText(modrinthLink, 51) + CONSOLE_RESET);
        this.plugin.getLogger().info("");
        this.plugin.getLogger().info(frameColor + "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u001b[0m");
    }

    private String formatConsoleText(String text, int maxLength) {
        if (text.length() > maxLength) {
            return text.substring(0, maxLength - 3) + "...";
        }
        return text + " ".repeat(maxLength - text.length());
    }

    public CompletableFuture<Boolean> checkForUpdates() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Version current;
                Version latest;
                URL url = new URL("https://api.modrinth.com/v2/project/Kp9Kt4QT/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "CelestCombat-UpdateChecker/1.0");
                if (connection.getResponseCode() != 200) {
                    this.plugin.getLogger().warning("Failed to check for updates. HTTP Error: " + connection.getResponseCode());
                    return false;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String response = reader.lines().collect(Collectors.joining("\n"));
                reader.close();
                JsonArray versions = JsonParser.parseString((String)response).getAsJsonArray();
                if (versions.isEmpty()) {
                    return false;
                }
                JsonObject latestVersionObj = null;
                for (JsonElement element : versions) {
                    JsonObject version = element.getAsJsonObject();
                    String versionType = version.get("version_type").getAsString();
                    if (!versionType.equals("release")) continue;
                    if (latestVersionObj == null) {
                        latestVersionObj = version;
                        continue;
                    }
                    String currentDate = latestVersionObj.get("date_published").getAsString();
                    String newDate = version.get("date_published").getAsString();
                    if (newDate.compareTo(currentDate) <= 0) continue;
                    latestVersionObj = version;
                }
                if (latestVersionObj == null) {
                    return false;
                }
                this.latestVersion = latestVersionObj.get("version_number").getAsString();
                String versionId = latestVersionObj.get("id").getAsString();
                this.downloadUrl = "https://modrinth.com/plugin/Kp9Kt4QT/version/" + this.latestVersion;
                JsonArray files = latestVersionObj.getAsJsonArray("files");
                if (!files.isEmpty()) {
                    JsonObject primaryFile = files.get(0).getAsJsonObject();
                    this.directLink = primaryFile.get("url").getAsString();
                }
                this.updateAvailable = (latest = new Version(this.latestVersion)).compareTo(current = new Version(this.currentVersion)) > 0;
                return this.updateAvailable;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error checking for updates: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        });
    }

    private void sendUpdateNotification(Player player) {
        if (!this.updateAvailable || !player.hasPermission("celestcombat.update.notify")) {
            return;
        }
        TextColor primaryBlue = TextColor.fromHexString((String)"#3B82F6");
        TextColor green = TextColor.fromHexString((String)"#22C55E");
        TextColor redPink = TextColor.fromHexString((String)"#EF4444");
        TextColor orange = TextColor.fromHexString((String)"#F97316");
        TextColor white = TextColor.fromHexString((String)"#F3F4F6");
        Component borderTop = Component.text((String)"\u2500\u2500\u2500\u2500\u2500 CelestCombat Update \u2500\u2500\u2500\u2500\u2500").color(primaryBlue);
        Component borderBottom = Component.text((String)"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500").color(primaryBlue);
        Component updateMsg = Component.text((String)"\u27a4 New update available!").color(green);
        Component versionsComponent = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2726 Current: ").color(white)).append(Component.text((String)this.currentVersion).color(redPink))).append(Component.text((String)"  \u2726 Latest: ").color(white))).append(Component.text((String)this.latestVersion).color(green));
        Component downloadButton = ((TextComponent)((TextComponent)Component.text((String)"\u25b6 [Click to download latest version]").color(orange)).clickEvent(ClickEvent.openUrl((String)this.downloadUrl))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((TextComponent)Component.text((String)"Download version ").color(white)).append(Component.text((String)this.latestVersion).color(green))));
        player.sendMessage(" ");
        player.sendMessage(borderTop);
        player.sendMessage(" ");
        player.sendMessage(updateMsg);
        player.sendMessage(versionsComponent);
        player.sendMessage(downloadButton);
        player.sendMessage(" ");
        player.sendMessage(borderBottom);
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.8f, 1.2f);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("celestcombat.update.notify")) {
            UUID playerId = player.getUniqueId();
            LocalDate today = LocalDate.now();
            this.notifiedPlayers.entrySet().removeIf(entry -> ((LocalDate)entry.getValue()).isBefore(today));
            if (this.notifiedPlayers.containsKey(playerId) && this.notifiedPlayers.get(playerId).isEqual(today)) {
                return;
            }
            if (this.updateAvailable) {
                Scheduler.runTaskLater(() -> {
                    this.sendUpdateNotification(player);
                    this.notifiedPlayers.put(playerId, today);
                }, 40L);
            } else {
                this.checkForUpdates().thenAccept(hasUpdate -> {
                    if (hasUpdate.booleanValue()) {
                        Scheduler.runTask(() -> {
                            this.sendUpdateNotification(player);
                            this.notifiedPlayers.put(playerId, today);
                        });
                    }
                });
            }
        }
    }
}

