/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.events.EventType;
import mcjty.incontrol.events.EventTypeBlockBroken;
import mcjty.incontrol.events.EventTypeCustom;
import mcjty.incontrol.events.EventTypeMobKilled;
import mcjty.incontrol.events.EventsConditions;
import mcjty.incontrol.events.NumberAction;
import mcjty.incontrol.events.PhaseAction;
import mcjty.incontrol.events.SpawnEventAction;

public class EventsRule {
    private final EventType eventType;
    private final EventsConditions conditions;
    private final SpawnEventAction action;
    private final PhaseAction phaseAction;
    private final NumberAction numberAction;
    private static final Map<String, Cmd> COMMANDS = new HashMap<String, Cmd>();

    private EventsRule(Builder builder) {
        this.conditions = builder.conditions;
        this.action = builder.action;
        this.eventType = builder.eventType;
        this.phaseAction = builder.phaseAction;
        this.numberAction = builder.numberAction;
    }

    public static Builder create() {
        return new Builder();
    }

    public static void parse(JsonObject object, Builder builder) {
        EventType et;
        Enum type = null;
        JsonObject parameters = null;
        block13: for (String attr : object.keySet()) {
            Cmd cmd = COMMANDS.get(attr);
            if (cmd == null) {
                ErrorHandler.error("Invalid command '" + attr + "' for events rule!");
                return;
            }
            switch (cmd) {
                case ON: {
                    JsonElement on = object.get("on");
                    type = EventType.Type.getType(on.getAsString());
                    if (type != null) continue block13;
                    ErrorHandler.error("Invalid 'on' value '" + on.getAsString() + "' for events rule!");
                    return;
                }
                case PARAMETERS: {
                    parameters = object.getAsJsonObject("parameters");
                    break;
                }
                case SPAWN: {
                    Record action = SpawnEventAction.parse(object);
                    if (action == null) continue block13;
                    builder.action((SpawnEventAction)action);
                    break;
                }
                case PHASE: {
                    Record action = PhaseAction.parse(object);
                    if (action == null) continue block13;
                    builder.action((PhaseAction)action);
                    break;
                }
                case NUMBER: {
                    Record action = NumberAction.parse(object);
                    if (action == null) continue block13;
                    builder.action((NumberAction)action);
                    break;
                }
                case CONDITIONS: {
                    JsonObject conditions = object.getAsJsonObject("conditions");
                    EventsConditions.Builder conditionsBuilder = EventsConditions.create();
                    EventsConditions.parse(conditions, conditionsBuilder);
                    EventsConditions cnd = conditionsBuilder.build();
                    cnd.validate();
                    builder.conditions(cnd);
                }
            }
        }
        if (type == null) {
            ErrorHandler.error("No 'on' specified for events rule!");
            return;
        }
        switch (1.$SwitchMap$mcjty$incontrol$events$EventType$Type[type.ordinal()]) {
            case 1: {
                et = new EventTypeMobKilled();
                if (et.parse(parameters)) break;
                return;
            }
            case 2: {
                et = new EventTypeBlockBroken();
                if (et.parse(parameters)) break;
                return;
            }
            case 3: {
                et = new EventTypeCustom();
                if (et.parse(parameters)) break;
                return;
            }
            default: {
                ErrorHandler.error("Unknown event type '" + String.valueOf(type) + "' for events rule!");
                return;
            }
        }
        builder.eventType(et);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public EventsConditions getConditions() {
        return this.conditions;
    }

    public SpawnEventAction getSpawnAction() {
        return this.action;
    }

    public PhaseAction getPhaseAction() {
        return this.phaseAction;
    }

    public NumberAction getNumberAction() {
        return this.numberAction;
    }

    static {
        for (Cmd cmd : Cmd.values()) {
            COMMANDS.put(cmd.name().toLowerCase(), cmd);
        }
    }

    public static class Builder {
        private EventsConditions conditions = EventsConditions.DEFAULT;
        private SpawnEventAction action;
        private PhaseAction phaseAction;
        private NumberAction numberAction;
        private EventType eventType;

        public Builder conditions(EventsConditions conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder action(SpawnEventAction action) {
            this.action = action;
            return this;
        }

        public Builder action(PhaseAction phaseAction) {
            this.phaseAction = phaseAction;
            return this;
        }

        public Builder action(NumberAction numberAction) {
            this.numberAction = numberAction;
            return this;
        }

        public Builder eventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public EventsRule build() {
            return new EventsRule(this);
        }
    }

    static enum Cmd {
        ON,
        PARAMETERS,
        SPAWN,
        PHASE,
        NUMBER,
        CONDITIONS;

    }
}

