/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks.base;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface ILockableBlock {
    public static final BooleanProperty LOCKED = BooleanProperty.m_61465_((String)"locked");
    public static final BooleanProperty BOUND = BooleanProperty.m_61465_((String)"bound");

    public static boolean isLocked(@Nonnull BlockState state) {
        return (Boolean)state.m_61143_((Property)LOCKED);
    }

    public static void setIsLocked(@Nonnull Player player, @Nonnull BlockState state, @Nonnull BlockPos pos, boolean locked) {
        Level level = player.m_9236_();
        if (level != null) {
            state = (BlockState)state.m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(locked));
            level.m_7731_(pos, state, 1);
            level.m_5594_(null, pos, SoundEvents.f_11745_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
            player.m_5661_((Component)Component.m_237115_((String)("info.lock.toggle_" + (locked ? "on" : "off"))), true);
        }
    }

    public static boolean isBound(@Nonnull BlockState state) {
        return (Boolean)state.m_61143_((Property)BOUND);
    }

    public static boolean tryToBindToKey(@Nonnull Player player, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        Level level;
        if (ILockableBlock.isBound(state) || (level = player.m_9236_()) != null) {
            // empty if block
        }
        return false;
    }

    public static void bindToKey(@Nonnull Player player, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        Level level = player.m_9236_();
        if (level != null) {
            // empty if block
        }
    }
}

