/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.command;

import com.lazrproductions.cuffed.restraints.RestraintAPI;
import com.lazrproductions.cuffed.restraints.base.AbstractRestraint;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.command.EnumArgument;

public class CuffedDebugCommand {
    public CuffedDebugCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctx) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cuffed").requires(source -> source.m_6761_(3) || !source.m_230897_())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"registries").then(Commands.m_82127_((String)"check").executes(this::executeRegistriesCheck))).then(Commands.m_82127_((String)"list").executes(this::executeRegistriesList))).then(Commands.m_82127_((String)"listItems").executes(this::executeRegistriesListItems))).then(Commands.m_82127_((String)"listRestraintsAndItems").executes(this::executeRegistriesListItemAndRestraints)))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)ctx)).then(Commands.m_82129_((String)"type", (ArgumentType)EnumArgument.enumArgument(RestraintType.class)).executes(this::executeGet))))));
    }

    private int executeRegistriesCheck(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (sender != null) {
            int numReg = RestraintAPI.Registries.size();
            int numRes = RestraintAPI.Registries.total();
            if (numReg > 0) {
                sender.m_213846_((Component)Component.m_237113_((String)("Found " + numReg + " registries for restraints containing a total of " + numRes + " restraints.")));
            } else {
                sender.m_213846_((Component)Component.m_237113_((String)"Found no registries contianing restraints, something is wrong!"));
            }
        }
        return 0;
    }

    private int executeRegistriesList(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (sender != null) {
            int numReg = RestraintAPI.Registries.size();
            int numRes = RestraintAPI.Registries.total();
            if (numReg > 0) {
                Object s = "[";
                for (AbstractRestraint i : RestraintAPI.Registries.getAllRestraints()) {
                    s = (String)s + i.getId() + ", ";
                }
                s = ((String)s).substring(0, ((String)s).length() - 2);
                s = (String)s + "]";
                sender.m_213846_((Component)Component.m_237113_((String)("Listing all " + numRes + " restraints registered in the " + numReg + " registries.\n" + (String)s)));
            } else {
                sender.m_213846_((Component)Component.m_237113_((String)"Found no registries contianing restraints, something is wrong!"));
            }
        }
        return 0;
    }

    private int executeRegistriesListItems(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (sender != null) {
            int numReg = RestraintAPI.Registries.size();
            int numRes = RestraintAPI.Registries.total();
            if (numReg > 0) {
                Object s = "[";
                for (Item i : RestraintAPI.Registries.getAllRestraintItems()) {
                    s = (String)s + i.m_5524_() + ", ";
                }
                s = ((String)s).substring(0, ((String)s).length() - 2);
                s = (String)s + "]";
                sender.m_213846_((Component)Component.m_237113_((String)("Listing all " + numRes + " restraint items registered in the " + numReg + " registries.\n" + (String)s)));
            } else {
                sender.m_213846_((Component)Component.m_237113_((String)"Found no registries contianing restraints, something is wrong!"));
            }
        }
        return 0;
    }

    private int executeRegistriesListItemAndRestraints(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (sender != null) {
            int numReg = RestraintAPI.Registries.size();
            int numRes = RestraintAPI.Registries.total();
            if (numReg > 0) {
                Object s = "[";
                for (Pair<Item, AbstractRestraint> i : RestraintAPI.Registries.getAllRestraintItemsAndTheirRestraints()) {
                    s = (String)s + "{restraint:\"" + ((AbstractRestraint)i.getSecond()).getId() + "\",item:\"" + ((Item)i.getFirst()).m_5524_() + "\"}, ";
                }
                s = ((String)s).substring(0, ((String)s).length() - 2);
                s = (String)s + "]";
                sender.m_213846_((Component)Component.m_237113_((String)("Listing all " + numRes + " restraints and their items registered in the " + numReg + " registries.\n" + (String)s)));
            } else {
                sender.m_213846_((Component)Component.m_237113_((String)"Found no registries contianing restraints, something is wrong!"));
            }
        }
        return 0;
    }

    private int executeGet(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (sender != null) {
                RestraintType type = (RestraintType)((Object)ctx.getArgument("type", RestraintType.class));
                ItemStack stack = ItemArgument.m_120963_(ctx, (String)"item").m_120980_(1, false);
                if (stack != null && !stack.m_41619_()) {
                    AbstractRestraint r = RestraintAPI.getRestraintFromStack(stack, type, sender, sender);
                    if (r != null) {
                        sender.m_213846_((Component)Component.m_237113_((String)("Found the following restraint for the given item and type:\n" + r.serializeNBT())));
                    } else {
                        sender.m_213846_((Component)Component.m_237113_((String)"Could not find a restraint for that item and type!"));
                    }
                    return 1;
                }
                sender.m_213846_((Component)Component.m_237113_((String)"An error occurred!"));
            }
            return 0;
        }
        catch (CommandSyntaxException e) {
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (sender != null) {
                sender.m_213846_((Component)Component.m_237113_((String)"Command syntax error"));
            }
            return 0;
        }
    }
}

