/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.command;

import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.cap.RestrainableCapability;
import com.lazrproductions.cuffed.entity.base.IAnchorableEntity;
import com.lazrproductions.cuffed.entity.base.INicknamable;
import com.lazrproductions.cuffed.restraints.RestraintAPI;
import com.lazrproductions.cuffed.restraints.base.AbstractArmRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractHeadRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractLegRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractRestraint;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.command.EnumArgument;

public class HandcuffCommand {
    public HandcuffCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctx) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cuffed").requires(source -> source.m_6761_(3) || !source.m_230897_())).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"apply").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)ctx)).then(Commands.m_82129_((String)"type", (ArgumentType)EnumArgument.enumArgument(RestraintType.class)).executes(this::executeApply))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"type", (ArgumentType)EnumArgument.enumArgument(RestraintType.class)).executes(this::executeRemove)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"anchor").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(this::executeSetAnchor)))).then(Commands.m_82127_((String)"remove").executes(this::executeRemoveAnchor)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"nickname").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"new nickname", (ArgumentType)ComponentArgument.m_87114_()).executes(this::executeSetNickname)))).then(Commands.m_82127_((String)"reset").executes(this::executeResetNickname)))));
    }

    private int executeApply(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            RestraintType type = (RestraintType)((Object)ctx.getArgument("type", RestraintType.class));
            ItemStack stack = ItemArgument.m_120963_(ctx, (String)"item").m_120980_(1, false);
            if (player != null && stack != null && !stack.m_41619_()) {
                ServerPlayer captor;
                ServerPlayer serverPlayer = captor = sender != null ? sender : player;
                if (type == RestraintType.Arm) {
                    AbstractRestraint abstractRestraint = RestraintAPI.getRestraintFromStack(stack, RestraintType.Arm, player, captor);
                    if (abstractRestraint instanceof AbstractArmRestraint) {
                        AbstractArmRestraint arm = (AbstractArmRestraint)abstractRestraint;
                        RestrainableCapability c = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
                        if (c.TryEquipRestraint(player, captor, arm)) {
                            if (sender != null) {
                                sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.arms.success", (Object[])new Object[]{player.m_7755_(), stack.m_41611_()}));
                            }
                        } else if (sender != null) {
                            sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.arms.failure.alreadyrestrained", (Object[])new Object[]{stack.m_41611_(), player.m_7755_()}).m_130940_(ChatFormatting.RED));
                        }
                    } else if (sender != null) {
                        sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.arms.failure.wrong_type", (Object[])new Object[]{stack.m_41611_(), player.m_7755_()}).m_130940_(ChatFormatting.RED));
                    }
                } else if (type == RestraintType.Leg) {
                    Object c = RestraintAPI.getRestraintFromStack(stack, RestraintType.Leg, player, captor);
                    if (c instanceof AbstractLegRestraint) {
                        AbstractLegRestraint leg = (AbstractLegRestraint)c;
                        c = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
                        if (((RestrainableCapability)c).TryEquipRestraint(player, captor, leg)) {
                            if (sender != null) {
                                sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.legs.success", (Object[])new Object[]{player.m_7755_(), stack.m_41611_()}));
                            }
                        } else if (sender != null) {
                            sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.legs.failure.alreadyrestrained", (Object[])new Object[]{stack.m_41611_(), player.m_7755_()}).m_130940_(ChatFormatting.RED));
                        }
                    } else if (sender != null) {
                        sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.legs.failure.wrong_type", (Object[])new Object[]{stack.m_41611_(), player.m_7755_()}).m_130940_(ChatFormatting.RED));
                    }
                } else if (type == RestraintType.Head) {
                    Object c = RestraintAPI.getRestraintFromStack(stack, RestraintType.Head, player, captor);
                    if (c instanceof AbstractHeadRestraint) {
                        AbstractHeadRestraint head = (AbstractHeadRestraint)c;
                        c = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
                        if (((RestrainableCapability)c).TryEquipRestraint(player, captor, head)) {
                            if (sender != null) {
                                sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.head.success", (Object[])new Object[]{player.m_7755_(), stack.m_41611_()}));
                            }
                        } else if (sender != null) {
                            sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.head.failure.alreadyrestrained", (Object[])new Object[]{stack.m_41611_(), player.m_7755_()}).m_130940_(ChatFormatting.RED));
                        }
                    } else if (sender != null) {
                        sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.head.failure.wrong_type", (Object[])new Object[]{stack.m_41611_(), player.m_7755_()}).m_130940_(ChatFormatting.RED));
                    }
                } else if (sender != null) {
                    sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.apply.failure", (Object[])new Object[]{stack.m_41611_(), player.m_7755_()}));
                }
                return 1;
            }
            return 0;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private int executeRemove(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            RestraintType t = (RestraintType)((Object)ctx.getArgument("type", RestraintType.class));
            if (player != null) {
                ServerPlayer captor;
                RestrainableCapability c = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
                ServerPlayer serverPlayer = captor = sender != null ? sender : player;
                if (c.TryUnequipRestraint(player, captor, t)) {
                    if (sender != null) {
                        sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.remove.success", (Object[])new Object[]{player.m_7755_(), Component.m_237115_((String)(t == RestraintType.Arm ? "info.cuffed.arms" : (t == RestraintType.Head ? "info.cuffed.head" : "info.cuffed.legs")))}));
                    }
                } else if (sender != null) {
                    sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.remove.failure", (Object[])new Object[]{player.m_7755_(), Component.m_237115_((String)(t == RestraintType.Arm ? "info.cuffed.arms" : (t == RestraintType.Head ? "info.cuffed.head" : "info.cuffed.legs")))}));
                }
                return 1;
            }
            return 0;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private int executeSetNickname(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            Component n = ComponentArgument.m_87117_(ctx, (String)"new nickname");
            if (player != null && n != null) {
                INicknamable nicknamable = (INicknamable)player;
                nicknamable.setNickname(n);
                if (sender != null) {
                    sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.nickname.set", (Object[])new Object[]{player.m_7755_(), n}));
                }
                return 1;
            }
            return 0;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private int executeResetNickname(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (player != null) {
                INicknamable nicknamable = (INicknamable)player;
                nicknamable.setNickname(null);
                if (sender != null) {
                    sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.nickname.reset", (Object[])new Object[]{player.m_7755_()}));
                }
                return 1;
            }
            return 0;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private int executeSetAnchor(CommandContext<CommandSourceStack> ctx) {
        try {
            Entity anchor = EntityArgument.m_91452_(ctx, (String)"entity");
            ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (anchor != null && player != null) {
                IAnchorableEntity anchorable = (IAnchorableEntity)player;
                anchorable.setAnchoredTo(anchor);
                if (sender != null) {
                    sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.anchor.set", (Object[])new Object[]{player.m_5446_(), anchor.m_5446_()}));
                }
                return 1;
            }
            return 0;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private int executeRemoveAnchor(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (player != null) {
                IAnchorableEntity anchorable = (IAnchorableEntity)player;
                anchorable.setAnchoredTo(null);
                if (sender != null) {
                    sender.m_213846_((Component)Component.m_237110_((String)"command.cuffed.anchor.remove", (Object[])new Object[]{player.m_5446_()}));
                }
                return 1;
            }
            return 0;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }
}

