/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.effect;

import com.lazrproductions.cuffed.init.ModEffects;
import com.lazrproductions.cuffed.init.ModParticleTypes;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class WoundedEffect
extends MobEffect {
    static final UUID ATTRIBUTE_HEALTH_UUID = UUID.fromString("b4d14f56-f45a-4966-8b05-59d1862caa5f");
    static final UUID ATTRIBUTE_SLOWNESS_UUID = UUID.fromString("e14e9c5e-e0cc-4414-aa0d-a59afacd67b1");

    public WoundedEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void m_6742_(@Nonnull LivingEntity entity, int amplifier) {
        if ((double)entity.m_217043_().m_188501_() < (double)amplifier / 100.0) {
            double x = entity.m_20182_().m_7096_() + (double)entity.m_217043_().m_188501_() * 0.8 - 0.4;
            double y = entity.m_20182_().m_7098_() + 1.0 + (double)entity.m_217043_().m_188501_() * 0.8 - 0.4;
            double z = entity.m_20182_().m_7094_() + (double)entity.m_217043_().m_188501_() * 0.8 - 0.4;
            entity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.BLOOD_DRIP_FALL_PARTICLE.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void m_6386_(@Nonnull LivingEntity entity, @Nonnull AttributeMap attributes, int amplifier) {
        super.m_6386_(entity, attributes, amplifier);
        AttributeInstance health = entity.m_21051_(Attributes.f_22276_);
        AttributeInstance slowness = entity.m_21051_(Attributes.f_22279_);
        if (health != null) {
            health.m_22120_(ATTRIBUTE_HEALTH_UUID);
            entity.m_6469_(entity.m_269291_().m_269425_(), 1.0f);
        }
        if (slowness != null) {
            slowness.m_22120_(ATTRIBUTE_SLOWNESS_UUID);
        }
    }

    public void m_6385_(@Nonnull LivingEntity entity, @Nonnull AttributeMap attributeMap, int amplifier) {
        AttributeInstance slowness;
        super.m_6385_(entity, attributeMap, amplifier);
        AttributeInstance health = entity.m_21051_(Attributes.f_22276_);
        double reductionAmount = -((double)amplifier) / 100.0;
        if (health != null) {
            health.m_22120_(ATTRIBUTE_HEALTH_UUID);
            health.m_22125_(new AttributeModifier(ATTRIBUTE_HEALTH_UUID, "woundedHealthReduction", reductionAmount, AttributeModifier.Operation.MULTIPLY_BASE));
            entity.m_6469_(entity.m_269291_().m_269425_(), 1.0f);
        }
        if ((slowness = entity.m_21051_(Attributes.f_22279_)) != null) {
            slowness.m_22120_(ATTRIBUTE_SLOWNESS_UUID);
            slowness.m_22125_(new AttributeModifier(ATTRIBUTE_SLOWNESS_UUID, "woundedSpeedReduction", reductionAmount * 0.8, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public static void woundEntity(@Nonnull LivingEntity entity, int percentage, boolean overwrite) {
        MobEffectInstance inst = entity.m_21124_((MobEffect)ModEffects.WOUNDED_EFFECT.get());
        int amplifier = percentage;
        if (inst != null && !overwrite) {
            int oldPercentage = inst.m_19564_();
            amplifier = Mth.m_14045_((int)(oldPercentage + percentage), (int)0, (int)100);
        }
        MobEffectInstance newInst = new MobEffectInstance((MobEffect)ModEffects.WOUNDED_EFFECT.get(), -1, amplifier);
        entity.m_21195_((MobEffect)ModEffects.WOUNDED_EFFECT.get());
        entity.m_7292_(newInst);
    }

    public static void woundEntity(@Nonnull LivingEntity entity, int percentage) {
        WoundedEffect.woundEntity(entity, percentage, false);
    }

    public static void treatEntity(@Nonnull LivingEntity entity) {
        if (entity.m_21023_((MobEffect)ModEffects.WOUNDED_EFFECT.get())) {
            entity.m_21195_((MobEffect)ModEffects.WOUNDED_EFFECT.get());
        }
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 2));
    }
}

