/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.mixin;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.entity.base.IAnchorableEntity;
import com.lazrproductions.cuffed.init.ModDamageTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IAnchorableEntity {
    private static final EntityDataAccessor<Integer> DATA_ANCHOR_ID = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String ANCHOR_TAG = "Anchor";
    @Nullable
    private Entity anchor = null;
    private boolean shouldBeLoaded = false;
    private UUID uuidToBeLoaded;
    boolean wasAnchored;

    public LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Override
    public boolean isAnchored() {
        return this.getAnchor() != null;
    }

    @Override
    public Entity getAnchor() {
        return this.anchor;
    }

    @Override
    public Entity getAnchorClientSide() {
        return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(DATA_ANCHOR_ID)).intValue());
    }

    @Override
    public void setAnchoredTo(@Nullable Entity e) {
        if (!this.m_9236_().m_5776_()) {
            if (e == null) {
                this.setAnchor(null);
                this.wasAnchored = false;
                ItemStack stack = new ItemStack((ItemLike)Items.f_42026_, 1);
                ItemEntity en = new ItemEntity(this.m_9236_(), this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), stack);
                en.m_32060_();
                this.m_9236_().m_7967_((Entity)en);
            } else {
                this.setAnchor(e);
            }
        }
    }

    @Override
    public void setAnchor(@Nullable Entity e) {
        this.anchor = e;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void onDefineSynchedData(CallbackInfo info) {
        this.f_19804_.m_135372_(DATA_ANCHOR_ID, (Object)-1);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo callback) {
        LivingEntity thisEntity = (LivingEntity)this;
        if (!this.m_9236_().m_5776_()) {
            Level level;
            if (this.shouldBeLoaded && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel l = (ServerLevel)level;
                Entity a = l.m_8791_(this.uuidToBeLoaded);
                this.setAnchor(a);
                if (a != null) {
                    this.shouldBeLoaded = false;
                }
            }
            if ((this.anchor == null || this.anchor.m_213877_()) && this.wasAnchored) {
                this.setAnchoredTo(null);
                this.wasAnchored = false;
            }
            if (this.anchor != null) {
                this.wasAnchored = true;
                this.f_19804_.m_135381_(DATA_ANCHOR_ID, (Object)this.anchor.m_19879_());
                double minDist = ((Float)CuffedMod.SERVER_CONFIG.ANCHORING_MAX_CHAIN_LENGTH.get()).floatValue();
                double maxDist = (this.f_19789_ > 0.2f ? (Float)CuffedMod.SERVER_CONFIG.ANCHORING_MAX_CHAIN_LENGTH.get() : (Float)CuffedMod.SERVER_CONFIG.ANCHORING_SUFFOCATION_LENGTH.get()).floatValue();
                if ((double)this.m_20270_(this.getAnchor()) > minDist) {
                    float distance = this.m_20270_(this.getAnchor());
                    double dx = (this.getAnchor().m_20185_() - this.m_20185_()) / (double)distance;
                    double dy = (this.getAnchor().m_20186_() - this.m_20186_()) / (double)distance;
                    double dz = (this.getAnchor().m_20189_() - this.m_20189_()) / (double)distance;
                    this.m_20334_(Math.copySign(dx * dx * ((double)distance / 5.0) * 0.45, dx), Math.copySign(dy * dy * ((double)distance / 5.0) * 0.45, dy), Math.copySign(dz * dz * ((double)distance / 5.0) * 0.45, dz));
                    if ((double)this.m_20270_(this.getAnchor()) > maxDist) {
                        this.m_6469_(ModDamageTypes.GetModSource(this, ModDamageTypes.HANG, this.anchor), 2.0f);
                    }
                }
            } else {
                this.f_19804_.m_135381_(DATA_ANCHOR_ID, (Object)-1);
            }
        } else if (thisEntity instanceof Player) {
            Player player = (Player)thisEntity;
            if (this.getAnchorClientSide() != null) {
                double minDist = ((Float)CuffedMod.SERVER_CONFIG.ANCHORING_MAX_CHAIN_LENGTH.get()).floatValue();
                if ((double)this.m_20270_(this.getAnchorClientSide()) > minDist) {
                    float distance = this.m_20270_(this.getAnchorClientSide());
                    double dx = (this.getAnchorClientSide().m_20185_() - this.m_20185_()) / (double)distance;
                    double dy = (this.getAnchorClientSide().m_20186_() - this.m_20186_()) / (double)distance;
                    double dz = (this.getAnchorClientSide().m_20189_() - this.m_20189_()) / (double)distance;
                    player.m_20334_(Math.copySign(dx * dx * ((double)distance / 5.0) * 0.45, dx), Math.copySign(dy * dy * ((double)distance / 5.0) * 0.45, dy), Math.copySign(dz * dz * ((double)distance / 5.0) * 0.45, dz));
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onAddAdditionalSaveData(CompoundTag tag, CallbackInfo info) {
        if (!this.m_9236_().m_5776_() && this.isAnchored()) {
            tag.m_128362_(ANCHOR_TAG, this.getAnchor().m_20148_());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onReadAdditionalSaveData(CompoundTag tag, CallbackInfo info) {
        if (!this.m_9236_().m_5776_()) {
            if (tag.m_128441_(ANCHOR_TAG)) {
                this.uuidToBeLoaded = tag.m_128342_(ANCHOR_TAG);
                this.shouldBeLoaded = true;
            } else {
                this.setAnchor(null);
            }
        }
    }
}

