/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.items.base;

import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.cap.RestrainableCapability;
import com.lazrproductions.cuffed.cap.base.IRestrainableCapability;
import com.lazrproductions.cuffed.init.ModEnchantments;
import com.lazrproductions.cuffed.items.base.AbstractArmRestraintItem;
import com.lazrproductions.cuffed.items.base.AbstractHeadRestraintItem;
import com.lazrproductions.cuffed.items.base.AbstractLegRestraintItem;
import com.lazrproductions.cuffed.restraints.RestraintAPI;
import com.lazrproductions.cuffed.restraints.base.AbstractArmRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractHeadRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractLegRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractRestraint;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class AbstractRestraintItem
extends Item {
    public AbstractRestraintItem(Item.Properties p) {
        super(p);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44986_) {
            return true;
        }
        if (enchantment == Enchantments.f_44975_) {
            return true;
        }
        if (enchantment == ModEnchantments.IMBUE.get()) {
            return true;
        }
        if (enchantment == ModEnchantments.FAMINE.get()) {
            return true;
        }
        if (enchantment == ModEnchantments.SHROUD.get()) {
            return true;
        }
        if (enchantment == ModEnchantments.EXHAUST.get()) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 1;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> components, @Nonnull TooltipFlag tooltipFlag) {
        components.add((Component)Component.m_237119_());
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"info.cuffed.restraint_type.extra").m_130940_(ChatFormatting.WHITE));
        } else {
            components.add((Component)Component.m_237115_((String)"info.cuffed.restraint_type.showextra").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, level, components, tooltipFlag);
    }

    public static boolean dispenseRestraint(BlockSource source, ItemStack stack) {
        BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        Predicate<Entity> restraintSelector = new PlayerCanEquipArmRestraintEntitySelector(stack);
        RestraintType typeToEquip = RestraintType.Arm;
        boolean isAmbiguousRestraint = false;
        if (stack.m_41720_() instanceof AbstractHeadRestraintItem) {
            restraintSelector = new PlayerCanEquipHeadRestraintEntitySelector(stack);
            typeToEquip = RestraintType.Head;
        } else if (stack.m_41720_() instanceof AbstractArmRestraintItem) {
            restraintSelector = new PlayerCanEquipArmRestraintEntitySelector(stack);
            typeToEquip = RestraintType.Arm;
        } else if (stack.m_41720_() instanceof AbstractLegRestraintItem) {
            restraintSelector = new PlayerCanEquipLegRestraintEntitySelector(stack);
            typeToEquip = RestraintType.Leg;
        } else if (stack.m_41720_() instanceof AbstractRestraintItem) {
            restraintSelector = new PlayerEntitySelector(stack);
            isAmbiguousRestraint = true;
        } else if (stack.m_150930_(Items.f_151058_) && BundleItem.m_150766_((ItemStack)stack) <= 0.0f) {
            restraintSelector = new PlayerCanEquipHeadRestraintEntitySelector(stack);
            typeToEquip = RestraintType.Head;
        }
        List list = source.m_7727_().m_6443_(Player.class, new AABB(blockpos), EntitySelector.f_20408_.and(restraintSelector));
        if (list.isEmpty()) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)list.get(0);
        RestrainableCapability entity = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
        ItemStack itemstack = stack.m_255036_(1);
        if (isAmbiguousRestraint) {
            typeToEquip = player.m_20182_().m_7098_() + 1.0 > (double)blockpos.m_123342_() ? RestraintType.Leg : RestraintType.Arm;
            AbstractRestraint restraint = RestraintAPI.getRestraintFromStack(itemstack, typeToEquip, player, player);
            if (typeToEquip == RestraintType.Arm && restraint instanceof AbstractArmRestraint && !entity.armsRestrained()) {
                return entity.TryEquipRestraint(player, player, (AbstractArmRestraint)restraint);
            }
            if (typeToEquip == RestraintType.Leg && restraint instanceof AbstractLegRestraint && !entity.legsRestrained()) {
                return entity.TryEquipRestraint(player, player, (AbstractLegRestraint)restraint);
            }
            return false;
        }
        if (typeToEquip == RestraintType.Arm && !entity.armsRestrained()) {
            AbstractRestraint restraint = RestraintAPI.getRestraintFromStack(itemstack, typeToEquip, player, player);
            return entity.TryEquipRestraint(player, player, (AbstractArmRestraint)restraint);
        }
        if (typeToEquip == RestraintType.Leg && !entity.legsRestrained()) {
            AbstractRestraint restraint = RestraintAPI.getRestraintFromStack(itemstack, typeToEquip, player, player);
            return entity.TryEquipRestraint(player, player, (AbstractLegRestraint)restraint);
        }
        if (typeToEquip == RestraintType.Head && !entity.headRestrained()) {
            AbstractRestraint restraint = RestraintAPI.getRestraintFromStack(itemstack, typeToEquip, player, player);
            return entity.TryEquipRestraint(player, player, (AbstractHeadRestraint)restraint);
        }
        return false;
    }

    public static class PlayerCanEquipArmRestraintEntitySelector
    implements Predicate<Entity> {
        private final ItemStack itemStack;

        public PlayerCanEquipArmRestraintEntitySelector(ItemStack stack) {
            this.itemStack = stack;
        }

        @Override
        public boolean test(@Nullable Entity entity) {
            if (entity == null) {
                return false;
            }
            if (!entity.m_6084_()) {
                return false;
            }
            if (!(this.itemStack.m_41720_() instanceof AbstractArmRestraintItem)) {
                return false;
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer a = (ServerPlayer)entity;
                IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)a);
                return !cap.armsRestrained();
            }
            return false;
        }
    }

    public static class PlayerCanEquipHeadRestraintEntitySelector
    implements Predicate<Entity> {
        private final ItemStack itemStack;

        public PlayerCanEquipHeadRestraintEntitySelector(ItemStack stack) {
            this.itemStack = stack;
        }

        @Override
        public boolean test(@Nullable Entity entity) {
            if (entity == null) {
                return false;
            }
            if (!entity.m_6084_()) {
                return false;
            }
            if (!(this.itemStack.m_41720_() instanceof AbstractHeadRestraintItem || this.itemStack.m_150930_(Items.f_151058_) && BundleItem.m_150766_((ItemStack)this.itemStack) <= 0.0f)) {
                return false;
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer a = (ServerPlayer)entity;
                IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)a);
                return !cap.headRestrained();
            }
            return false;
        }
    }

    public static class PlayerCanEquipLegRestraintEntitySelector
    implements Predicate<Entity> {
        private final ItemStack itemStack;

        public PlayerCanEquipLegRestraintEntitySelector(ItemStack stack) {
            this.itemStack = stack;
        }

        @Override
        public boolean test(@Nullable Entity entity) {
            if (entity == null) {
                return false;
            }
            if (!entity.m_6084_()) {
                return false;
            }
            if (!(this.itemStack.m_41720_() instanceof AbstractLegRestraintItem)) {
                return false;
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer a = (ServerPlayer)entity;
                IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)a);
                return !cap.legsRestrained();
            }
            return false;
        }
    }

    public static class PlayerEntitySelector
    implements Predicate<Entity> {
        private final ItemStack itemStack;

        public PlayerEntitySelector(ItemStack stack) {
            this.itemStack = stack;
        }

        @Override
        public boolean test(@Nullable Entity entity) {
            if (entity == null) {
                return false;
            }
            if (!entity.m_6084_()) {
                return false;
            }
            if (!(this.itemStack.m_41720_() instanceof AbstractRestraintItem)) {
                return false;
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer a = (ServerPlayer)entity;
                IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)a);
                return cap != null;
            }
            return false;
        }
    }
}

