/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks;

import com.lazrproductions.cuffed.blocks.entity.BunkBlockEntity;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class BunkBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    protected static final int HEIGHT = 9;
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape NORTH_HEAD_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)1.0, (double)15.0, (double)9.0, (double)16.0));
    protected static final VoxelShape NORTH_FOOT_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)0.0, (double)15.0, (double)9.0, (double)15.0));
    protected static final VoxelShape SOUTH_HEAD_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)0.0, (double)15.0, (double)9.0, (double)15.0));
    protected static final VoxelShape SOUTH_FOOT_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)1.0, (double)15.0, (double)9.0, (double)16.0));
    protected static final VoxelShape EAST_HEAD_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)7.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0));
    protected static final VoxelShape EAST_FOOT_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)1.0, (double)16.0, (double)9.0, (double)15.0));
    protected static final VoxelShape WEST_HEAD_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)1.0, (double)16.0, (double)9.0, (double)15.0));
    protected static final VoxelShape WEST_FOOT_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)7.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0));

    public BunkBlock(BlockBehaviour.Properties p) {
        super(p);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    @javax.annotation.Nullable
    public static Direction getBedOrientation(BlockGetter level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        return blockstate.m_60734_() instanceof BunkBlock ? (Direction)blockstate.m_61143_((Property)f_54117_) : null;
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player interactor, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_(PART) != BedPart.HEAD && !(state = level.m_8055_(pos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!BunkBlock.canSetSpawn(level)) {
            level.m_7471_(pos, false);
            BlockPos blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
            if (level.m_8055_(blockpos).m_60713_((Block)this)) {
                level.m_7471_(blockpos, false);
            }
            Vec3 vec3 = pos.m_252807_();
            level.m_254951_((Entity)null, level.m_269111_().m_269488_(vec3), (ExplosionDamageCalculator)null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
            interactor.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            return InteractionResult.SUCCESS;
        }
        interactor.m_7720_(pos).ifLeft(sleepProblem -> {
            Component c;
            if (sleepProblem != null && (c = sleepProblem.m_36423_()) != null) {
                interactor.m_5661_(c, true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public static boolean canSetSpawn(Level level) {
        return level.m_6042_().f_63862_();
    }

    public void m_142072_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Entity entity, float f) {
        super.m_142072_(level, state, pos, entity, f * 0.5f);
    }

    public void m_5548_(@Nonnull BlockGetter getter, @Nonnull Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(getter, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * (double)0.66f * d0, vec3.f_82481_);
        }
    }

    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState otherState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
        if (direction == BunkBlock.getNeighbourDirection((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)f_54117_))) {
            return otherState.m_60713_((Block)this) && otherState.m_61143_(PART) != state.m_61143_(PART) ? (BlockState)state.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)otherState.m_61143_((Property)OCCUPIED))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, otherState, level, pos, otherPos);
    }

    private static Direction getNeighbourDirection(BedPart p_49534_, Direction p_49535_) {
        return p_49534_ == BedPart.FOOT ? p_49535_ : p_49535_.m_122424_();
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!level.f_46443_ && player.m_7500_() && (bedpart = (BedPart)state.m_61143_(PART)) == BedPart.FOOT && (blockstate = level.m_8055_(blockpos = pos.m_121945_(BunkBlock.getNeighbourDirection(bedpart, (Direction)state.m_61143_((Property)f_54117_))))).m_60713_((Block)this) && blockstate.m_61143_(PART) == BedPart.HEAD) {
            level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(level, pos, state, player);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_175364_(Direction.Axis.Y);
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        Level level = context.m_43725_();
        Direction face = context.m_43719_();
        if (face == Direction.DOWN || face == Direction.UP) {
            return null;
        }
        return level.m_8055_(blockpos1).m_60629_(context) && level.m_6857_().m_61937_(blockpos1) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext collisionContext) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch (direction) {
            case NORTH: {
                return state.m_61143_(PART) == BedPart.HEAD ? NORTH_HEAD_SHAPE : NORTH_FOOT_SHAPE;
            }
            case SOUTH: {
                return state.m_61143_(PART) == BedPart.HEAD ? SOUTH_HEAD_SHAPE : SOUTH_FOOT_SHAPE;
            }
            case WEST: {
                return state.m_61143_(PART) == BedPart.HEAD ? WEST_HEAD_SHAPE : WEST_FOOT_SHAPE;
            }
        }
        return state.m_61143_(PART) == BedPart.HEAD ? EAST_HEAD_SHAPE : EAST_FOOT_SHAPE;
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return state.m_61143_(PART) == BedPart.HEAD ? direction.m_122424_() : direction;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        BedPart bedpart = (BedPart)state.m_61143_(PART);
        return bedpart == BedPart.HEAD ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> entityType, CollisionGetter collision, BlockPos pos, Direction facing, float f) {
        Direction direction = facing.m_122427_();
        Direction direction1 = direction.m_122370_(f) ? direction.m_122424_() : direction;
        int[][] aint = BunkBlock.bedStandUpOffsets(facing, direction1);
        Optional<Vec3> optional = BunkBlock.findStandUpPositionAtOffset(entityType, collision, pos, aint, true);
        return optional.isPresent() ? optional : BunkBlock.findStandUpPositionAtOffset(entityType, collision, pos, aint, false);
    }

    private static Optional<Vec3> findStandUpPositionAtOffset(EntityType<?> entityType, CollisionGetter collision, BlockPos pos, int[][] p_49473_, boolean p_49474_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int[] aint : p_49473_) {
            blockpos$mutableblockpos.m_122178_(pos.m_123341_() + aint[0], pos.m_123342_(), pos.m_123343_() + aint[1]);
            Vec3 vec3 = DismountHelper.m_38441_(entityType, (CollisionGetter)collision, (BlockPos)blockpos$mutableblockpos, (boolean)p_49474_);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED});
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new BunkBlockEntity(pos, state);
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @javax.annotation.Nullable LivingEntity entity, @Nonnull ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_) {
            BlockPos blockpos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            level.m_7731_(blockpos, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public long m_7799_(@Nonnull BlockState p_49522_, @Nonnull BlockPos p_49523_) {
        BlockPos blockpos = p_49523_.m_5484_((Direction)p_49522_.m_61143_((Property)f_54117_), p_49522_.m_61143_(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)blockpos.m_123341_(), (int)p_49523_.m_123342_(), (int)blockpos.m_123343_());
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType path) {
        return false;
    }

    private static int[][] bedStandUpOffsets(Direction p_49539_, Direction p_49540_) {
        return (int[][])ArrayUtils.addAll((Object[])BunkBlock.bedSurroundStandUpOffsets(p_49539_, p_49540_), (Object[])BunkBlock.bedAboveStandUpOffsets(p_49539_));
    }

    private static int[][] bedSurroundStandUpOffsets(Direction p_49552_, Direction p_49553_) {
        return new int[][]{{p_49553_.m_122429_(), p_49553_.m_122431_()}, {p_49553_.m_122429_() - p_49552_.m_122429_(), p_49553_.m_122431_() - p_49552_.m_122431_()}, {p_49553_.m_122429_() - p_49552_.m_122429_() * 2, p_49553_.m_122431_() - p_49552_.m_122431_() * 2}, {-p_49552_.m_122429_() * 2, -p_49552_.m_122431_() * 2}, {-p_49553_.m_122429_() - p_49552_.m_122429_() * 2, -p_49553_.m_122431_() - p_49552_.m_122431_() * 2}, {-p_49553_.m_122429_() - p_49552_.m_122429_(), -p_49553_.m_122431_() - p_49552_.m_122431_()}, {-p_49553_.m_122429_(), -p_49553_.m_122431_()}, {-p_49553_.m_122429_() + p_49552_.m_122429_(), -p_49553_.m_122431_() + p_49552_.m_122431_()}, {p_49552_.m_122429_(), p_49552_.m_122431_()}, {p_49553_.m_122429_() + p_49552_.m_122429_(), p_49553_.m_122431_() + p_49552_.m_122431_()}};
    }

    private static int[][] bedAboveStandUpOffsets(Direction p_49537_) {
        return new int[][]{{0, 0}, {-p_49537_.m_122429_(), -p_49537_.m_122431_()}};
    }
}

